/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.RevocationInfo;
import com.avaya.asm.trustmgmt.RevocationInfoManager;
import com.avaya.common.logging.client.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CRL;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class TrustKeyManagerFactorySupplier {
    private static final String ALGO_PKIX = "PKIX";
    private static final String ALGO_X509 = "X.509";
    private static final String PROVIDER_SUN = "SUN";
    private static final String SYSTEM_PARAM_KEY_STORE = "javax.net.ssl.keyStore";
    private static final String SYSTEM_PARAM_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String SYSTEM_PARAM_KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    private static final String SYSTEM_PARAM_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    private static final String SYSTEM_PARAM_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String SYSTEM_PARAM_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    private static final String SYSTEM_PARAM_TRUST_STORE_PROVIDER = "javax.net.ssl.trustStoreProvider";
    private static final String SYSTEM_PARAM_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private static final String SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    private static final String DEFAULT_TRUST_STORE_PATH = System.getProperty("javax.net.ssl.trustStore", null);
    private static final String DEFAULT_TRUST_STORE_TYPE = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    private static final String DEFAULT_TRUST_STORE_PROVIDER = System.getProperty("javax.net.ssl.trustStoreProvider", null);
    private static final String DEFAULT_TRUST_STORE_PASSWORD = System.getProperty("javax.net.ssl.trustStorePassword", null);
    private static final String DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM = System.getProperty("ssl.TrustManagerFactory.algorithm", null);
    private static final String DEFAULT_KEY_STORE_PATH = System.getProperty("javax.net.ssl.keyStore", null);
    private static final String DEFAULT_KEY_STORE_TYPE = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
    private static final String DEFAULT_KEY_STORE_PROVIDER = System.getProperty("javax.net.ssl.keyStoreProvider", null);
    private static final String DEFAULT_KEY_STORE_PASSWORD = System.getProperty("javax.net.ssl.keyStorePassword", null);
    private static final String DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM = System.getProperty("ssl.KeyManagerFactory.algorithm", null);
    private static final boolean useDefaultRevocationChecker = Boolean.getBoolean("com.avaya.asm.trustmgmt.useDefaultRevocationChecker");
    private static boolean dumpStackIsEnabled = false;
    private static Logger log = AsmLogger.getLogger(TrustKeyManagerFactorySupplier.class);

    public KeyManagerFactory getKeyMgrFactory(String keyStorePath, String keyStoreType, String keyStoreProvider, char[] keyStorePassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        return this.getKeyMgrFactory(keyStorePath, keyStoreType, keyStoreProvider, new String(keyStorePassword));
    }

    public KeyManagerFactory getKeyMgrFactory(String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        return this.getKeyMgrFactory(keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword, keyManagerFactoryAlgorithm);
    }

    public KeyManagerFactory getKeyMgrFactory(String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword, String keyManagerFactoryAlgorithm) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String functionName = "getKeyMgrFactory";
        boolean isFineEnabled = log.isFineEnabled();
        KeyManagerFactory keyMgrFactory = null;
        try {
            if (isFineEnabled) {
                log.fine((Object)("getKeyMgrFactory: keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", " + SYSTEM_PARAM_KEY_STORE + "=" + DEFAULT_KEY_STORE_PATH + ", " + SYSTEM_PARAM_KEY_STORE_TYPE + "=" + DEFAULT_KEY_STORE_TYPE + ", " + SYSTEM_PARAM_KEY_STORE_PROVIDER + "=" + DEFAULT_KEY_STORE_PROVIDER + ", " + SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM + "=" + DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM + ", KeyManagerFactory.getDefaultAlgorithm()=" + KeyManagerFactory.getDefaultAlgorithm()));
            }
            if (keyStorePath == null) {
                keyStorePath = DEFAULT_KEY_STORE_PATH;
            }
            if (keyStoreType == null) {
                keyStoreType = DEFAULT_KEY_STORE_TYPE;
            }
            if (keyStoreProvider == null) {
                keyStoreProvider = DEFAULT_KEY_STORE_PROVIDER;
            }
            if (keyStorePassword == null) {
                keyStorePassword = DEFAULT_KEY_STORE_PASSWORD;
            }
            if (keyManagerFactoryAlgorithm == null && (keyManagerFactoryAlgorithm = DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM) == null) {
                keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            KeyStore keyStore = this.getKeyStore(keyStorePath, keyStoreType, keyStoreProvider, keyStorePassword);
            keyMgrFactory = this.getKeyMgrFactory(keyStore, keyStorePassword, keyManagerFactoryAlgorithm);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error((Object)("getKeyMgrFactory: Error getting keyMgrFactory.: keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", " + SYSTEM_PARAM_KEY_STORE + "=" + DEFAULT_KEY_STORE_PATH + ", " + SYSTEM_PARAM_KEY_STORE_TYPE + "=" + DEFAULT_KEY_STORE_TYPE + ", " + SYSTEM_PARAM_KEY_STORE_PROVIDER + "=" + DEFAULT_KEY_STORE_PROVIDER + ", " + SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM + "=" + DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM + ", KeyManagerFactory.getDefaultAlgorithm()=" + KeyManagerFactory.getDefaultAlgorithm()), (Throwable)e);
            throw e;
        }
        return keyMgrFactory;
    }

    public KeyManagerFactory getKeyMgrFactory(KeyStore keyStore, String keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        return this.getKeyMgrFactory(keyStore, keyStorePassword, keyManagerFactoryAlgorithm);
    }

    public KeyManagerFactory getKeyMgrFactory(KeyStore keyStore, String keyStorePassword, String keyManagerFactoryAlgorithm) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String functionName = "getKeyMgrFactory";
        boolean isFineEnabled = log.isFineEnabled();
        boolean isInfoEnabled = log.isInfoEnabled();
        KeyManagerFactory keyMgrFactory = null;
        try {
            if (isFineEnabled) {
                log.fine((Object)("getKeyMgrFactory: keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", " + SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM + "=" + DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM + ", KeyManagerFactory.getDefaultAlgorithm()=" + KeyManagerFactory.getDefaultAlgorithm()));
            }
            if (dumpStackIsEnabled) {
                Thread.dumpStack();
            }
            if (keyStorePassword == null) {
                keyStorePassword = DEFAULT_KEY_STORE_PASSWORD;
            }
            if (keyManagerFactoryAlgorithm == null && (keyManagerFactoryAlgorithm = DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM) == null) {
                keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            keyMgrFactory = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm);
            keyMgrFactory.init(keyStore, keyStorePassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.error((Object)("getKeyMgrFactory: Error getting keyMgrFactory., keyManagerFactoryAlgorithm=" + keyManagerFactoryAlgorithm + ", " + SYSTEM_PARAM_KEY_MANAGER_FACTORY_ALGORITHM + "=" + DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM + ", KeyManagerFactory.getDefaultAlgorithm()=" + KeyManagerFactory.getDefaultAlgorithm()), (Throwable)e);
            throw e;
        }
        return keyMgrFactory;
    }

    public KeyStore getKeyStore(String keyStorePath, String keyStoreType, String keyStoreProvider, String keyStorePassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getKeyStore";
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)("getKeyStore: keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", " + SYSTEM_PARAM_KEY_STORE + "=" + DEFAULT_KEY_STORE_PATH + ", " + SYSTEM_PARAM_KEY_STORE_TYPE + "=" + DEFAULT_KEY_STORE_TYPE + ", " + SYSTEM_PARAM_KEY_STORE_PROVIDER + "=" + DEFAULT_KEY_STORE_PROVIDER));
        }
        if (keyStorePath == null) {
            keyStorePath = DEFAULT_KEY_STORE_PATH;
        }
        if (keyStoreType == null) {
            keyStoreType = DEFAULT_KEY_STORE_TYPE;
        }
        if (keyStoreProvider == null) {
            keyStoreProvider = DEFAULT_KEY_STORE_PROVIDER;
        }
        if (keyStorePassword == null) {
            keyStorePassword = DEFAULT_KEY_STORE_PASSWORD;
        }
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = new FileInputStream(keyStorePath);){
            keyStore = keyStoreProvider == null ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, keyStoreProvider);
            keyStore.load(fileInputStream, keyStorePassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            log.error((Object)("getKeyStore: Error getting KeyStore. keyStorePath=" + keyStorePath + ", keyStoreType=" + keyStoreType + ", keyStoreProvider=" + keyStoreProvider + ", " + SYSTEM_PARAM_KEY_STORE + "=" + DEFAULT_KEY_STORE_PATH + ", " + SYSTEM_PARAM_KEY_STORE_TYPE + "=" + DEFAULT_KEY_STORE_TYPE + ", " + SYSTEM_PARAM_KEY_STORE_PROVIDER + "=" + DEFAULT_KEY_STORE_PROVIDER), (Throwable)e);
            throw e;
        }
        return keyStore;
    }

    private PKIXParameters getPKIXParametersFromTrustStore(KeyStore trustStore) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getPKIXParametersFromTrustStore";
        boolean isInfoEnabled = log.isInfoEnabled();
        boolean isFineEnabled = log.isFineEnabled();
        RevocationInfo revocationInfo = RevocationInfoManager.getInstance().getRevocationInfo();
        if (isFineEnabled) {
            log.fine((Object)("getPKIXParametersFromTrustStore RevocationInfo=" + revocationInfo + ", useDefaultRevocationChecker=" + useDefaultRevocationChecker));
        }
        PKIXBuilderParameters params = null;
        try {
            params = new PKIXBuilderParameters(trustStore, null);
            if (revocationInfo.isRevocationCheckingEnabled()) {
                if (isInfoEnabled) {
                    log.info((Object)"getPKIXParametersFromTrustStore: Revocation Checking is enabled");
                }
                if (revocationInfo.isCrlRevocationCheckingEnabled()) {
                    List<X509CRL> crlList = revocationInfo.getCrlList();
                    if (isFineEnabled) {
                        log.fine((Object)("getPKIXParametersFromTrustStore: CRL List Retrieved: " + crlList));
                    }
                    CollectionCertStoreParameters cparam = new CollectionCertStoreParameters(crlList);
                    CertStore cs = CertStore.getInstance("Collection", cparam);
                    params.addCertStore(cs);
                }
                if (useDefaultRevocationChecker) {
                    params.setRevocationEnabled(true);
                } else {
                    params.addCertPathChecker(this.getRevocationChecker());
                    params.setRevocationEnabled(false);
                }
            } else {
                if (isInfoEnabled) {
                    log.info((Object)"getPKIXParametersFromTrustStore: Revocation Checking is NOT enabled");
                }
                params.setRevocationEnabled(false);
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)("getPKIXParametersFromTrustStore: Error getting PKIX Parameters from trustStore., params=" + params + ", RevocationInfo=" + revocationInfo), (Throwable)e);
            throw e;
        }
        return params;
    }

    private PKIXRevocationChecker getRevocationChecker() throws NoSuchAlgorithmException, NoSuchProviderException, UnsupportedOperationException {
        String functionName = "getRevocationChecker";
        boolean isFineEnabled = log.isFineEnabled();
        String certPathValidatorAlgorithm = ALGO_PKIX;
        String certPathValidatorProvider = PROVIDER_SUN;
        RevocationInfo revocationInfo = RevocationInfoManager.getInstance().getRevocationInfo();
        PKIXRevocationChecker revocationChecker = null;
        CertPathValidator cpv = null;
        try {
            cpv = CertPathValidator.getInstance(ALGO_PKIX, PROVIDER_SUN);
            if (isFineEnabled) {
                log.fine((Object)("getRevocationChecker:  revocationInfo=" + revocationInfo + ", CertPathValidator.getDefaultType()=" + CertPathValidator.getDefaultType() + ", certPathValidatorAlgorithm=" + ALGO_PKIX + ", certPathValidatorProvider=" + PROVIDER_SUN + ", cpv.getProvider()=" + cpv.getProvider() + ", cpv.getAlgorithm()=" + cpv.getAlgorithm()));
            }
            revocationChecker = (PKIXRevocationChecker)cpv.getRevocationChecker();
            HashSet<PKIXRevocationChecker.Option> set = new HashSet<PKIXRevocationChecker.Option>();
            if (revocationInfo.isSoftFailAllowed()) {
                set.add(PKIXRevocationChecker.Option.SOFT_FAIL);
            }
            if (revocationInfo.checkEndEntityOnly()) {
                set.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
            }
            if (!revocationInfo.isFallbackAllowed()) {
                set.add(PKIXRevocationChecker.Option.NO_FALLBACK);
            }
            if (!revocationInfo.isOcspPreferred()) {
                set.add(PKIXRevocationChecker.Option.PREFER_CRLS);
            }
            if (!set.isEmpty()) {
                revocationChecker.setOptions(set);
            }
            if (isFineEnabled) {
                log.fine((Object)("getRevocationChecker: Revocation Options set. set=" + set + " rc=" + revocationChecker + ", revocationInfo=" + revocationInfo));
            }
        }
        catch (UnsupportedOperationException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)("getRevocationChecker: Error getting revocation checker. revocationInfo=" + revocationInfo + ", CertPathValidator.getDefaultType()=" + CertPathValidator.getDefaultType() + ", certPathValidatorAlgorithm=" + ALGO_PKIX + ", certPathValidatorProvider=" + PROVIDER_SUN), (Throwable)e);
            throw e;
        }
        return revocationChecker;
    }

    public TrustManagerFactory getTrustMgrFactory(String trustStorePath, String trustStoreType, String trustStoreProvider, char[] trustStorePassword) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        return this.getTrustMgrFactory(trustStorePath, trustStoreType, trustStoreProvider, new String(trustStorePassword));
    }

    public TrustManagerFactory getTrustMgrFactory(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String trustManagerFactoryAlgorithm = ALGO_PKIX;
        return this.getTrustMgrFactory(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword, ALGO_PKIX);
    }

    public TrustManagerFactory getTrustMgrFactory(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword, String trustManagerFactoryAlgorithm) throws CertificateException, InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, UnrecoverableKeyException {
        String functionName = "getTrustMgrFactory";
        boolean isFineEnabled = log.isFineEnabled();
        TrustManagerFactory trustMgrFactory = null;
        try {
            if (isFineEnabled) {
                log.fine((Object)("getTrustMgrFactory: trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", " + SYSTEM_PARAM_TRUST_STORE + "=" + DEFAULT_TRUST_STORE_PATH + ", " + SYSTEM_PARAM_TRUST_STORE_TYPE + "=" + DEFAULT_TRUST_STORE_TYPE + ", " + SYSTEM_PARAM_TRUST_STORE_PROVIDER + "=" + DEFAULT_TRUST_STORE_PROVIDER + ", " + SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM + "=" + DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM + ", TrustManagerFactory.getDefaultAlgorithm()=" + TrustManagerFactory.getDefaultAlgorithm() + ", useDefaultRevocationChecker=" + useDefaultRevocationChecker));
            }
            if (trustStorePath == null) {
                trustStorePath = DEFAULT_TRUST_STORE_PATH;
            }
            if (trustStoreType == null) {
                trustStoreType = DEFAULT_TRUST_STORE_TYPE;
            }
            if (trustStorePassword == null) {
                trustStorePassword = DEFAULT_TRUST_STORE_PASSWORD;
            }
            if (trustStoreProvider == null) {
                trustStoreProvider = DEFAULT_TRUST_STORE_PROVIDER;
            }
            if (trustManagerFactoryAlgorithm == null && (trustManagerFactoryAlgorithm = DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM) == null) {
                trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            KeyStore trustStore = this.getTrustStore(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword);
            trustMgrFactory = this.getTrustMgrFactory(trustStore, trustManagerFactoryAlgorithm);
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException e) {
            log.error((Object)("getTrustMgrFactory: Error getting TrustMgrFactory.: trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", " + SYSTEM_PARAM_TRUST_STORE + "=" + DEFAULT_TRUST_STORE_PATH + ", " + SYSTEM_PARAM_TRUST_STORE_TYPE + "=" + DEFAULT_TRUST_STORE_TYPE + ", " + SYSTEM_PARAM_TRUST_STORE_PROVIDER + "=" + DEFAULT_TRUST_STORE_PROVIDER + ", " + SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM + "=" + DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM + ", TrustManagerFactory.getDefaultAlgorithm()=" + TrustManagerFactory.getDefaultAlgorithm() + ", useDefaultRevocationChecker=" + useDefaultRevocationChecker), (Throwable)e);
            throw e;
        }
        return trustMgrFactory;
    }

    public TrustManagerFactory getTrustMgrFactory(KeyStore trustStore) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getTrustMgrFactory";
        boolean isFineEnabled = log.isFineEnabled();
        String trustManagerFactoryAlgorithm = ALGO_PKIX;
        if (isFineEnabled) {
            log.fine((Object)"getTrustMgrFactory: no algorithm specified, defaulting to PKIX");
        }
        return this.getTrustMgrFactory(trustStore, ALGO_PKIX);
    }

    public TrustManagerFactory getTrustMgrFactory(KeyStore trustStore, String trustManagerFactoryAlgorithm) throws InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getTrustMgrFactory";
        boolean isFineEnabled = log.isFineEnabled();
        TrustManagerFactory trustMgrFactory = null;
        try {
            if (isFineEnabled) {
                log.fine((Object)("getTrustMgrFactory: trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", " + SYSTEM_PARAM_TRUST_MANAGER_FACTORY_ALGORITHM + "=" + DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM + ", TrustManagerFactory.getDefaultAlgorithm()=" + TrustManagerFactory.getDefaultAlgorithm() + ", useDefaultRevocationChecker=" + useDefaultRevocationChecker));
            }
            if (dumpStackIsEnabled) {
                Thread.dumpStack();
            }
            if (trustManagerFactoryAlgorithm == null && (trustManagerFactoryAlgorithm = DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM) == null) {
                trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            PKIXParameters params = this.getPKIXParametersFromTrustStore(trustStore);
            CertPathTrustManagerParameters certPathParams = new CertPathTrustManagerParameters(params);
            trustMgrFactory = TrustManagerFactory.getInstance(trustManagerFactoryAlgorithm);
            trustMgrFactory.init(certPathParams);
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error((Object)("getTrustMgrFactory: Error getting trustMgrFactory. trustManagerFactoryAlgorithm=" + trustManagerFactoryAlgorithm + ", DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM=" + DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM + ", TrustManagerFactory.getDefaultAlgorithm()=" + TrustManagerFactory.getDefaultAlgorithm() + ", useDefaultRevocationChecker=" + useDefaultRevocationChecker), (Throwable)e);
            throw e;
        }
        return trustMgrFactory;
    }

    public KeyStore getTrustStore(String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "getTrustStore";
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)("getTrustStore: trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", " + SYSTEM_PARAM_TRUST_STORE + "=" + DEFAULT_TRUST_STORE_PATH + ", " + SYSTEM_PARAM_TRUST_STORE_TYPE + "=" + DEFAULT_TRUST_STORE_TYPE + ", " + SYSTEM_PARAM_TRUST_STORE_PROVIDER + "=" + DEFAULT_TRUST_STORE_PROVIDER));
        }
        if (trustStorePath == null) {
            trustStorePath = DEFAULT_TRUST_STORE_PATH;
        }
        if (trustStoreType == null) {
            trustStoreType = DEFAULT_TRUST_STORE_TYPE;
        }
        if (trustStoreProvider == null) {
            trustStoreProvider = DEFAULT_TRUST_STORE_PROVIDER;
        }
        if (trustStorePassword == null) {
            trustStorePassword = DEFAULT_TRUST_STORE_PASSWORD;
        }
        KeyStore trustStore = null;
        try (FileInputStream fileInputStream = new FileInputStream(trustStorePath);){
            trustStore = trustStoreProvider == null ? KeyStore.getInstance(trustStoreType) : KeyStore.getInstance(trustStoreType, trustStoreProvider);
            trustStore.load(fileInputStream, trustStorePassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            log.error((Object)("getTrustStore: Error getting trustStore.: trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", " + SYSTEM_PARAM_TRUST_STORE + "=" + DEFAULT_TRUST_STORE_PATH + ", " + SYSTEM_PARAM_TRUST_STORE_TYPE + "=" + DEFAULT_TRUST_STORE_TYPE + ", " + SYSTEM_PARAM_TRUST_STORE_PROVIDER + "=" + DEFAULT_TRUST_STORE_PROVIDER), (Throwable)e);
            throw e;
        }
        return trustStore;
    }

    public boolean isCertificateTrusted(List<Certificate> certificateChain, String trustStorePath, String trustStoreType, String trustStoreProvider, char[] trustStorePassword) throws CertificateException, CertPathValidatorException, InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.isCertificateTrusted(certificateChain, trustStorePath, trustStoreType, trustStoreProvider, new String(trustStorePassword));
    }

    public boolean isCertificateTrusted(List<Certificate> certificateChain, String trustStorePath, String trustStoreType, String trustStoreProvider, String trustStorePassword) throws CertificateException, CertPathValidatorException, InvalidAlgorithmParameterException, IOException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException {
        String functionName = "isCertificateTrusted";
        boolean isFineEnabled = log.isFineEnabled();
        try {
            if (isFineEnabled) {
                log.fine((Object)("isCertificateTrusted certificateChain=" + certificateChain + ", trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", CertPathValidator.getDefaultType()=" + CertPathValidator.getDefaultType() + ", " + SYSTEM_PARAM_TRUST_STORE + "=" + DEFAULT_TRUST_STORE_PATH + ", " + SYSTEM_PARAM_TRUST_STORE_TYPE + "=" + DEFAULT_TRUST_STORE_TYPE + ", " + SYSTEM_PARAM_TRUST_STORE_PROVIDER + "=" + DEFAULT_TRUST_STORE_PROVIDER));
            }
            if (trustStorePath == null) {
                trustStorePath = DEFAULT_TRUST_STORE_PATH;
            }
            if (trustStoreType == null) {
                trustStoreType = DEFAULT_TRUST_STORE_TYPE;
            }
            if (trustStoreProvider == null) {
                trustStoreProvider = DEFAULT_TRUST_STORE_PROVIDER;
            }
            if (trustStorePassword == null) {
                trustStorePassword = DEFAULT_TRUST_STORE_PASSWORD;
            }
            KeyStore trustStore = this.getTrustStore(trustStorePath, trustStoreType, trustStoreProvider, trustStorePassword);
            PKIXParameters params = this.getPKIXParametersFromTrustStore(trustStore);
            String certificateFactoryAlgorithm = ALGO_X509;
            String certificateFactoryProvider = null;
            CertificateFactory cf = null;
            cf = certificateFactoryProvider == null ? CertificateFactory.getInstance(ALGO_X509) : CertificateFactory.getInstance(ALGO_X509, certificateFactoryProvider);
            String certPathValidatorAlgorithm = ALGO_PKIX;
            String certPathValidatorProvider = null;
            CertPathValidator cpv = null;
            cpv = certPathValidatorProvider == null ? CertPathValidator.getInstance(ALGO_PKIX) : CertPathValidator.getInstance(ALGO_PKIX, certPathValidatorProvider);
            CertPath certPath = cf.generateCertPath(certificateChain);
            cpv.validate(certPath, params);
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertPathValidatorException | CertificateException e) {
            log.error((Object)("isCertificateTrusted: Error validating certificate chain. certificateChain=" + certificateChain + ", trustStorePath=" + trustStorePath + ", trustStoreType=" + trustStoreType + ", trustStoreProvider=" + trustStoreProvider + ", " + SYSTEM_PARAM_TRUST_STORE + "=" + DEFAULT_TRUST_STORE_PATH + ", " + SYSTEM_PARAM_TRUST_STORE_TYPE + "=" + DEFAULT_TRUST_STORE_TYPE + ", " + SYSTEM_PARAM_TRUST_STORE_PROVIDER + "=" + DEFAULT_TRUST_STORE_PROVIDER), (Throwable)e);
            throw e;
        }
        return true;
    }
}

