/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraClientProperties;
import java.util.Arrays;
import javax.net.ssl.SSLContext;

public class CassandraSSLOptions {
    private SSLContext sslContext = null;
    private final Logger log = AsmLogger.getLogger(this.getClass());
    public static final String[] DEFAULT_CASSANDRA_CIPHER_SUITES = new String[]{"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"};
    private String[] cipherSuites = null;

    public CassandraSSLOptions(SSLContext sslContext, String[] cipherSuites) {
        this.sslContext = sslContext;
        this.cipherSuites = cipherSuites;
    }

    public CassandraSSLOptions(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.setCiphers();
    }

    private void setCiphers() {
        String fcn_name = "setCiphers";
        CassandraClientProperties ccp = CassandraClientProperties.getInstance();
        if (ccp == null) {
            this.log.error((Object)"setCiphers: CassandraClientProperties.getInstance() returned null");
        } else {
            this.cipherSuites = ccp.getCipherSuite();
            if (this.cipherSuites != null) {
                this.log.info((Object)("setCiphers: loaded cipher suites " + Arrays.toString(this.cipherSuites)));
            }
        }
        if (this.cipherSuites == null) {
            this.cipherSuites = DEFAULT_CASSANDRA_CIPHER_SUITES;
            this.log.info((Object)("setCiphers: using default cipher suites " + Arrays.toString(this.cipherSuites)));
        }
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public String toString() {
        return "UStoreDAOSSLOptions [sslContext=" + this.sslContext + ", cipherSuites=" + Arrays.toString(this.cipherSuites) + "]";
    }
}

