/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.cassandra.locator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMLocatorDAO {
    final String url = "jdbc:postgresql://localhost/asm?ssl";
    final String user = "asm";
    final String password = "asm";
    static Object mutex = new Object();
    Connection db;
    static SMLocatorDAO instance = null;
    List<String> smList = null;
    Map<Long, List<InetAddress>> userCommAsmMap = null;
    Boolean connInit = false;
    private static final Logger logger = LoggerFactory.getLogger(SMLocatorDAO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMLocatorDAO getInstance() {
        String fcn_name = "getInstance";
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                try {
                    Class.forName("org.postgresql.Driver");
                }
                catch (ClassNotFoundException e) {
                    logger.error("getInstance: ClassNotFoundException received: ", (Throwable)e);
                }
                if (instance == null) {
                    instance = new SMLocatorDAO();
                }
            }
        }
        return instance;
    }

    public SMLocatorDAO() {
        this.queryUserCommunities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnection() {
        String fcn_name = "initConnection";
        if (!this.connInit.booleanValue()) {
            Boolean bl = this.connInit;
            synchronized (bl) {
                if (!this.connInit.booleanValue()) {
                    try {
                        this.db = DriverManager.getConnection("jdbc:postgresql://localhost/asm?ssl", "asm", "asm");
                    }
                    catch (SQLException e) {
                        logger.error("initConnection: SQLException received: ", (Throwable)e);
                    }
                }
                this.connInit = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSMs() {
        if (this.smList == null) {
            Object object = mutex;
            synchronized (object) {
                if (this.smList == null) {
                    this.querySMs();
                }
            }
        }
        return this.smList;
    }

    private void querySMs() {
        Statement st;
        String fcn_name = "querySMs";
        String sqlCmd = "SELECT managementaccesspointhostname FROM asminstance WHERE sm_type = 'SM';";
        this.initConnection();
        try {
            st = this.db.createStatement();
        }
        catch (SQLException e) {
            logger.error("querySMs: SQLException received for createStatement: ", (Throwable)e);
            return;
        }
        ResultSet rs = null;
        this.smList = new ArrayList<String>();
        try {
            rs = st.executeQuery("SELECT managementaccesspointhostname FROM asminstance WHERE sm_type = 'SM';");
        }
        catch (SQLException e) {
            logger.error("querySMs: SQLException received for executeQuery: ", (Throwable)e);
            try {
                st.close();
            }
            catch (SQLException e1) {
                logger.error("querySMs: SQLException received for st.close(): ", (Throwable)e1);
            }
            return;
        }
        try {
            while (rs.next()) {
                this.smList.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error("querySMs: SQLException received for rs operation: ", (Throwable)e);
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            logger.error("querySMs: SQLException received for st.close: ", (Throwable)e);
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            logger.error("querySMs: SQLException received for rs.close: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserCommunities() {
        Object object = mutex;
        synchronized (object) {
            this.queryUserCommunities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InetAddress> getReplicasByUserCommunity(long commId) {
        if (this.userCommAsmMap == null) {
            Object object = mutex;
            synchronized (object) {
                if (this.userCommAsmMap == null) {
                    this.queryUserCommunities();
                }
            }
        }
        return this.userCommAsmMap.get(commId);
    }

    private void queryUserCommunities() {
        Statement st;
        String fcn_name = "queryUserCommunities";
        String sqlCmd = "SELECT assign.asmusercommunity_id, inst.managementaccesspointhostname FROM  asminstance inst, asmusercommunityassign assign WHERE  assign.asminstance_id=inst.id;";
        this.initConnection();
        try {
            st = this.db.createStatement();
        }
        catch (SQLException e) {
            logger.error("queryUserCommunities: SQLException received for createStatement: ", (Throwable)e);
            return;
        }
        ResultSet rs = null;
        this.userCommAsmMap = new HashMap<Long, List<InetAddress>>();
        try {
            rs = st.executeQuery("SELECT assign.asmusercommunity_id, inst.managementaccesspointhostname FROM  asminstance inst, asmusercommunityassign assign WHERE  assign.asminstance_id=inst.id;");
        }
        catch (SQLException e) {
            logger.error("queryUserCommunities: SQLException received for executeQuery: ", (Throwable)e);
            try {
                st.close();
            }
            catch (SQLException e1) {
                logger.error("queryUserCommunities: SQLException received for st.close(): ", (Throwable)e1);
            }
            return;
        }
        try {
            while (rs.next()) {
                Long userCommId = rs.getLong(1);
                List<InetAddress> addresses = this.userCommAsmMap.get(userCommId);
                if (addresses == null) {
                    addresses = new ArrayList<InetAddress>(2);
                    this.userCommAsmMap.put(userCommId, addresses);
                }
                InetAddress address = null;
                String addrStr = rs.getString(2);
                try {
                    address = InetAddress.getByName(addrStr);
                }
                catch (UnknownHostException uhe) {
                    logger.error("queryUserCommunities: UnknownHostException for " + addrStr + ", userCommId " + userCommId);
                    continue;
                }
                addresses.add(address);
            }
        }
        catch (SQLException e) {
            logger.error("queryUserCommunities: SQLException received for rs operation: ", (Throwable)e);
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            logger.error("queryUserCommunities: SQLException received for st.close: ", (Throwable)e);
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            logger.error("queryUserCommunities: SQLException received for rs.close: ", (Throwable)e);
        }
    }
}

