/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.core.LocalSettings;
import com.avaya.asm.core.exceptions.ConfigFileEntryException;
import com.avaya.asm.datamgr.DMConstants;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.RtsHostDAO;
import com.avaya.common.logging.client.Logger;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Scanner;

public class DMUtilities {
    private static Logger log = AsmLogger.getLogger(DMUtilities.class);
    private static volatile String productVersion = null;
    private static volatile String smgrIpAddr = null;
    private static volatile DMConstants.ProductType productType = null;
    private static volatile Boolean isBranch = null;
    private static volatile String installType = null;
    public static final long jUnitAsmInstanceId = 123456L;
    public static long jUnitCurrentTime = 0L;

    public static long getCurrentTime() {
        if (AsmCommon.jUnitEnvironment) {
            return jUnitCurrentTime;
        }
        return System.currentTimeMillis();
    }

    public static String getPoolName(int whichPool, boolean shortName) {
        return DMUtilities.getPoolName(whichPool, shortName, false);
    }

    public static Object[] getLocalAsmInstanceParams() {
        if (AsmCommon.jUnitEnvironment) {
            return new Object[]{123456L};
        }
        Long myAsmInstanceId = ((AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
        return new Object[]{myAsmInstanceId == null ? 0L : myAsmInstanceId};
    }

    public static Long getMyAsmInstanceId() {
        if (AsmCommon.jUnitEnvironment) {
            return 0L;
        }
        return ((AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
    }

    public static Object[] getLocalAsmInstanceParams(Object id) {
        if (AsmCommon.jUnitEnvironment) {
            return new Object[]{123456L, id};
        }
        Long myAsmInstanceId = ((AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
        if (myAsmInstanceId == null) {
            myAsmInstanceId = 0L;
        }
        return new Object[]{myAsmInstanceId, id};
    }

    public static String getPoolName(int whichPool, boolean shortName, boolean canBorrow) {
        if (whichPool == 0) {
            if (canBorrow) {
                return "overall";
            }
            return shortName ? "A" : "audio";
        }
        if (whichPool == 1) {
            return shortName ? "V" : "multimedia";
        }
        if (whichPool == 2) {
            return shortName ? "B" : "borrow";
        }
        if (whichPool == 4) {
            return shortName ? "T" : "text";
        }
        if (whichPool == 3) {
            return shortName ? "F" : "fax";
        }
        if (whichPool == 5) {
            return shortName ? "O" : "other";
        }
        if (whichPool == 6) {
            return shortName ? "CD" : "call denial";
        }
        return shortName ? "U" : "unknown";
    }

    public static String getStackTrace(Throwable e) {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        e.printStackTrace(pw);
        return ((Object)out).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getInstallType() {
        if (installType != null) return installType;
        if (AsmCommon.jUnitEnvironment) {
            return "SM";
        }
        Class<DMUtilities> clazz = DMUtilities.class;
        synchronized (DMUtilities.class) {
            installType = DMUtilities.readPropFile("/opt/Avaya/install.properties", "SmInstallType");
            if (installType != null) {
                installType = installType.trim();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            log.info((Object)("SmInstallType in /opt/Avaya/install.properties is " + installType + "."));
            return installType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static DMConstants.ProductType getProductType() {
        block8: {
            block7: {
                block9: {
                    if (productType != null) break block8;
                    if (AsmCommon.jUnitEnvironment) {
                        return DMConstants.ProductType.UNKNOWN;
                    }
                    Class<DMUtilities> clazz = DMUtilities.class;
                    // MONITORENTER : com.avaya.asm.datamgr.DMUtilities.class
                    String installType = DMUtilities.getInstallType();
                    if (installType == null) break block9;
                    if ((installType = installType.trim()).contains("AUS")) {
                        productType = DMConstants.ProductType.AUS_INSTANCE;
                        break block7;
                    } else if (installType.contains("SM")) {
                        productType = DMConstants.ProductType.SM_INSTANCE;
                        break block7;
                    } else {
                        ConfigFileEntryException e = new ConfigFileEntryException(ConfigFileEntryException.eType.ProductTypeInvalidValue, "\"InstallType\" has invalid value in properties file \"/opt/Avaya/install.properties\"");
                        GenericAlarmHandler.handleFailureEvent(null, e);
                    }
                    break block7;
                }
                ConfigFileEntryException e = new ConfigFileEntryException(ConfigFileEntryException.eType.ProductTypeNotFound, "\"InstallType\" not found in properties file \"/opt/Avaya/install.properties\"");
                GenericAlarmHandler.handleFailureEvent(null, e);
            }
            // MONITOREXIT : clazz
        }
        if (productType != null) return productType;
        return DMConstants.ProductType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBranch() {
        if (isBranch != null) return isBranch;
        if (AsmCommon.jUnitEnvironment) {
            return false;
        }
        Class<DMUtilities> clazz = DMUtilities.class;
        synchronized (DMUtilities.class) {
            String installType = DMUtilities.getInstallType();
            isBranch = installType != null && installType.startsWith("BSM") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return isBranch;
        }
    }

    public static void setInstallType(String type) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to set installType programatically instead of reading from configuration file!");
        }
        installType = type;
    }

    public static void setProductType(DMConstants.ProductType type) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to set Product Type programatically instead of reading from configuration file!");
        }
        productType = type;
    }

    public static void setBranch(boolean branch) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to set isBranch programatically instead of reading from configuration file!");
        }
        isBranch = branch;
    }

    public static boolean isAusInstance() {
        return DMUtilities.getProductType() == DMConstants.ProductType.AUS_INSTANCE;
    }

    public static boolean isSmInstance() {
        return DMUtilities.getProductType() == DMConstants.ProductType.SM_INSTANCE;
    }

    public static boolean isUnknownInstance() {
        return DMUtilities.getProductType() == DMConstants.ProductType.UNKNOWN;
    }

    public static boolean is8300DBSM() {
        return DMUtilities.getInstallType() != null && DMUtilities.getInstallType().equals("BSMD");
    }

    public static boolean is8300EBSM() {
        return DMUtilities.getInstallType() != null && DMUtilities.getInstallType().equals("BSME");
    }

    public static boolean isMidSizeBSM() {
        return DMUtilities.getInstallType() != null && DMUtilities.getInstallType().equals("BSM");
    }

    public static boolean isLargeBSM() {
        return DMUtilities.getInstallType() != null && DMUtilities.getInstallType().equals("BSML");
    }

    public static void modifyDefaultLocalSettingsPerArchitecture() {
        if (!DMUtilities.isBranch() || DMUtilities.isLargeBSM()) {
            int numOfCPUs = Runtime.getRuntime().availableProcessors();
            if (numOfCPUs == 2) {
                AsmSettings.setPollingSubscribesPerSecond(10L);
            } else if (numOfCPUs < 7) {
                AsmSettings.setPollingSubscribesPerSecond(numOfCPUs * 10);
            }
            return;
        }
        AsmSettings.setPollingSubscribeBaseRateIncrease(0L);
        AsmSettings.setPollingSubscribeOverloadRateIncrease(0L);
        AsmSettings.setPollingSubscribeRateDecrease(0L);
        AsmSettings.setPollingSubscribesPerSecond(20L);
        if (LocalSettings.getDBValue("THROTTLED_PPM_REQUESTS_PER_SECOND") == null) {
            LocalSettings.setDBValue("THROTTLED_PPM_REQUESTS_PER_SECOND", DMUtilities.isMidSizeBSM() ? "150" : "74");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getProductVersion() {
        if (productVersion == null) {
            if (AsmCommon.jUnitEnvironment) {
                return "JUnitVersion";
            }
            Class<DMUtilities> clazz = DMUtilities.class;
            // MONITORENTER : com.avaya.asm.datamgr.DMUtilities.class
            productVersion = DMUtilities.readPropFile("/opt/Avaya/install.properties", "Release");
            // MONITOREXIT : clazz
        }
        if (productVersion != null) return productVersion;
        ConfigFileEntryException e = new ConfigFileEntryException(ConfigFileEntryException.eType.VersionNotFound, "\"Release\" not found in properties file \"/opt/Avaya/install.properties\"");
        GenericAlarmHandler.handleFailureEvent(null, e);
        return productVersion;
    }

    public static void setProductVersion(String version) {
        productVersion = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSMGRIpAddr() {
        if (smgrIpAddr != null) return smgrIpAddr;
        if (AsmCommon.jUnitEnvironment) {
            return "JUnitSMGR";
        }
        Class<DMUtilities> clazz = DMUtilities.class;
        synchronized (DMUtilities.class) {
            if (smgrIpAddr != null) return smgrIpAddr;
            String smgrAddress = DMUtilities.readPropFile("/opt/Avaya/install.properties", "InterClusterName");
            if (smgrAddress == null) {
                smgrAddress = DMUtilities.readPropFile("/opt/Avaya/install.properties", "SmgrIP");
            }
            if (smgrAddress != null) {
                try {
                    InetAddress[] addresses;
                    InetAddress[] inetAddressArray = addresses = InetAddress.getAllByName(smgrAddress);
                    int n = inetAddressArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        String address;
                        InetAddress iNetAddress = inetAddressArray[n2];
                        smgrIpAddr = address = iNetAddress.getHostAddress();
                    }
                }
                catch (UnknownHostException e) {
                    smgrIpAddr = smgrAddress;
                }
            }
            if (smgrIpAddr != null) return smgrIpAddr;
            log.fatal((Object)"SMGR IP address not found");
            // ** MonitorExit[var0] (shouldn't be in output)
            return smgrIpAddr;
        }
    }

    public static void setSmgrIpAddr(String smgrIp) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to set SMGR IP Address programatically instead of reading from configuration file!");
        }
        smgrIpAddr = smgrIp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readPropFile(String file, String property) {
        String ret = null;
        try (Scanner scanner = new Scanner(new FileInputStream(file));){
            String line;
            do {
                if (!scanner.hasNextLine()) return ret;
            } while (!(line = scanner.nextLine()).startsWith(property));
            String string = ret = line.substring(line.indexOf(61) + 1);
            return string;
        }
        catch (Exception e) {
            if (AsmCommon.jUnitEnvironment) {
                log.error((Object)("Error retrieving " + property + " from " + file));
                return ret;
            }
            log.error((Object)("Error retrieving " + property + " from " + file), (Throwable)e);
        }
        return ret;
    }

    public static String getCurrentThreadCLName() {
        return DMUtilities.getSimpleClassLoaderName(null);
    }

    public static String getSimpleClassLoaderName(ClassLoader cl) {
        try {
            String clName = cl == null ? Thread.currentThread().getContextClassLoader().toString().trim() : cl.toString().trim();
            int idx = clName.indexOf(93);
            if (idx > 0) {
                clName = clName.substring(0, idx + 1);
            }
            return new String(clName);
        }
        catch (Exception e) {
            log.warn((Object)("getContextClassLoader is null in " + Thread.currentThread()), (Throwable)e);
            return "";
        }
    }

    public static String getCurrentThreadIdentity(ClassLoader cl) {
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            log.warn((Object)"getContextClassLoader is null.");
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(System.identityHashCode(cl));
        ClassLoader parentCl = cl.getParent();
        if (parentCl == null) {
            return sb.toString();
        }
        sb.append("_");
        sb.append(System.identityHashCode(parentCl));
        return sb.toString();
    }

    public static boolean isApplicationConfigured(String appSystemName) {
        RtsHostDAO rhDAO = (RtsHostDAO)DMFactory.getInstance().getDataMgr(RtsHostDAO.class);
        Long appSystemTypeId = rhDAO.getApplicationSystemTypeId(appSystemName);
        return rhDAO.isApplicationConfigured(appSystemTypeId);
    }
}

