/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.CallHistoryDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.SMCallHistoryAPI;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.SetCommunityDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CallHistoryKey;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SMCallHistoryDM
extends DataAccessObject
implements SMCallHistoryAPI {
    CallHistoryDM callHistoryDM = new CallHistoryDM();
    private final Logger log = AsmLogger.getLogger(SMCallHistoryDM.class);
    private static DMFactory factory;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public void setFactory(DMFactory dmFactory) {
        factory = dmFactory;
    }

    @Override
    public void addCallHistory(long cscommprofilesetId, Integer maxLogs, List<CallLog> callLogs) throws DMException {
        String fcn_name = "addCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLog=" + maxLogs + ", callLogs.size()=" + callLogs.size()));
        }
        CallHistoryKey key = this.getKey(cscommprofilesetId);
        this.callHistoryDM.addCallHistory(key, maxLogs, callLogs);
        if (isFiner) {
            this.log.finer((Object)"addCallHistory: leave");
        }
    }

    @Override
    public void deleteCallHistoryById(long cscommprofilesetId, List<UUID> callLogUuids) throws DMException {
        CallHistoryKey key;
        String fcn_name = "deleteCallHistoryById";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryById: enter, cscommProfilesetId=" + cscommprofilesetId + ", callLogUuids.size()=" + callLogUuids.size()));
        }
        if ((key = this.getKey(cscommprofilesetId)) == null) {
            this.log.warn((Object)("deleteCallHistoryById: cannot get key for set id " + cscommprofilesetId));
            return;
        }
        this.callHistoryDM.deleteCallHistoryById(key, callLogUuids);
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryById: leave");
        }
    }

    @Override
    public void deleteCallHistoryByLimit(long cscommprofilesetId, int maxLogs) throws DMException {
        String fcn_name = "deleteCallHistoryByLimit";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryByLimit: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs));
        }
        CallHistoryKey key = this.getKey(cscommprofilesetId);
        this.callHistoryDM.deleteCallHistoryByLimit(key, maxLogs);
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryByLimit: leave");
        }
    }

    @Override
    public List<CallLog> getCallHistory(long cscommprofilesetId, Integer maxLogs) throws DMException {
        String fcn_name = "getCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs));
        }
        CallHistoryKey key = this.getKey(cscommprofilesetId);
        List<CallLog> callLogs = null;
        callLogs = this.callHistoryDM.getCallHistory(key, maxLogs);
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: leave, having found " + callLogs.size() + " Call Logs."));
        }
        return callLogs;
    }

    @Override
    public void init() {
        this.log.info((Object)"Started initializing SMCallHistoryDM");
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (dmTypes dm : dmTypes.values()) {
            DataMgr dataMgr = dm.get();
            if (dataMgr.okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
        this.log.info((Object)"Finished initializing SMCallHistoryDM");
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
    }

    protected CallHistoryKey getKey(long cscommprofilesetId) {
        String fcn_name = "getKey";
        Long userCommId = ((SetCommunityDAO)dmTypes.SET_COMMUNITY_DAO.get()).getUserCommunityId(cscommprofilesetId);
        if (userCommId == null) {
            this.log.warn((Object)("getKey: cannot get userCommId for set id " + cscommprofilesetId));
            return null;
        }
        List<Long> asmInstIds = ((UserCommunityDAO)dmTypes.USER_COMMUNITY_DAO.get()).getUserCommAsmInstanceIds(userCommId);
        if (asmInstIds == null) {
            this.log.warn((Object)("getKey: cannot get asmInstIds for comm id " + userCommId + ", set id " + cscommprofilesetId));
            return null;
        }
        ArrayList<AsmInstance> instances = new ArrayList<AsmInstance>();
        for (Long id : asmInstIds) {
            AsmInstance instance = ((AsmInstanceDAO)dmTypes.ASM_INSTANCE_DAO.get()).getAsmInstance(id);
            if (instance == null) {
                this.log.warn((Object)("getKey: cannot get AsmInstance for comm id " + userCommId + ", set id " + cscommprofilesetId + ", asm instance id " + id));
                return null;
            }
            instances.add(instance);
        }
        UserStoreKeyspace keyspace = new UserStoreKeyspace(instances);
        return new CallHistoryKey(cscommprofilesetId, keyspace);
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return null;
    }

    @Override
    public void deleteAllCallHistory(long cscommprofilesetId) throws DMException {
    }

    @Override
    public void moveCallHistory(long oldCommProfileSetId, long newCommProfileSetId) throws DMException {
    }

    public static enum dmTypes implements BLDMEnumType
    {
        ASM_INSTANCE_DAO(AsmInstanceDAO.class),
        USER_COMMUNITY_DAO(UserCommunityDAO.class),
        SET_COMMUNITY_DAO(SetCommunityDAO.class);

        private Class<? extends DataMgr> subDM;

        private dmTypes(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return SMCallHistoryDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

