/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.loadrulekeys.FilterSurvivabilityServer;
import com.avaya.asm.datamgr.loadrulekeys.HandleTypes;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={FilterSurvivabilityServer.class, HandleTypes.class})
public class CsHandleDAO
extends IsDeletedHandler {
    private final Logger log = AsmLogger.getLogger(CsHandleDAO.class);
    protected Set<String> handleTypes = null;
    protected Long survivabilityServerId = null;
    final Object[] emptyParams = new Object[0];
    protected Map<Long, String> handleTypeMap = new HashMap<Long, String>();
    protected Map<Long, String> handleSubTypeMap = new HashMap<Long, String>();
    protected Map<Long, CsHandle> handleByIdMap = new HashMap<Long, CsHandle>();
    protected Map<Long, Map<String, Object>> handleMap = new HashMap<Long, Map<String, Object>>();
    protected Map<Long, Set<CsHandle>> commProfileSetMap = new HashMap<Long, Set<CsHandle>>();
    protected Long foreignDomainId = null;
    protected final String[] caseSensitiveHandleTypes = new String[]{"sip"};
    protected final Set<Long> setIdFlexCache = new HashSet<Long>();
    protected final LinkedList<CsHandle> flexCache = new LinkedList();
    protected String getAllHandles = "SELECT id, handle, csdomainid, credential, cscommprofilesetid, cshandletypeid, cshandlesubtypeid FROM cshandle";
    protected String getHandleById = this.getAllHandles + " WHERE id = ?";
    protected String getHandleByHandle = this.getAllHandles + " WHERE csdomainid = ? AND LOWER(handle) = LOWER(?)";
    protected String getHandleBySetId = this.getAllHandles + " WHERE cscommprofilesetid = ?";
    protected String getHandleByAsmId = this.getAllHandles;
    protected String getAllHandlesSurvivable = "SELECT h.id, h.handle, h.csdomainid, h.credential, h.cscommprofilesetid, h.cshandletypeid, h.cshandlesubtypeid FROM cshandle h, asmcommprofile asm, cscommprofile cs WHERE h.cscommprofilesetid NOT IN (" + isDeletedCommProfileSetId + ") AND h.cscommprofilesetid = cs.cscommprofilesetid AND cs.id = asm.id AND asm.survivability_server_id = ?";
    public static final String getSurvivabilityServerId = "SELECT asm.survivability_server_id AS id FROM asmcommprofile asm JOIN cscommprofile cs ON cs.id = asm.id WHERE cs.cscommprofilesetid = ?";
    public static final String getSurvivabilityServerIdByAsmId = "SELECT survivability_server_id FROM asmcommprofile WHERE id = ?";
    protected static final String getAllHandleTypes = "SELECT id, name FROM cshandletypeenum";
    protected static final String getHandleTypeById = "SELECT id, name FROM cshandletypeenum WHERE id = ?";
    protected static final String getAllHandleSubTypes = "SELECT id, name FROM cshandlesubtypeenum";
    protected static final String getHandleSubTypeById = "SELECT id, name FROM cshandlesubtypeenum WHERE id = ?";
    protected static final String getForeignDomainId = "SELECT id FROM csdomain WHERE domainname = '__foreign__'";
    protected static final ResultSetMapper idMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return (Long)rs.getObject("id");
            }
            return null;
        }
    };
    protected static final ResultSetMapper survivableIdMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return (Long)rs.getObject("survivability_server_id");
            }
            return null;
        }
    };
    protected static final ResultSetMapper handleTypeMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, String> map = new HashMap<Long, String>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getString("name"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper handleSubTypeMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, String> map = new HashMap<Long, String>();
            while (rs.next()) {
                map.put(rs.getLong("id"), rs.getString("name"));
            }
            return map;
        }
    };
    protected static final ResultSetMapper handleMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, CsHandle> map = new HashMap<Long, CsHandle>();
            while (rs.next()) {
                map.put(rs.getLong("id"), new CsHandle(rs.getLong("id"), rs.getString("handle"), rs.getLong("csdomainid"), rs.getString("credential"), rs.getLong("cscommprofilesetid"), rs.getLong("cshandletypeid"), (Long)rs.getObject("cshandlesubtypeid")));
            }
            return map;
        }
    };

    protected String getAllHandleQuery() {
        return this.getAllHandles;
    }

    protected Object[] getAllHandleParams() {
        if (this.survivabilityServerId == null) {
            return new Object[0];
        }
        return new Object[]{this.survivabilityServerId};
    }

    protected Object[] getHandleByIdParams(Long handleId) {
        if (this.survivabilityServerId == null) {
            return new Object[]{handleId};
        }
        return new Object[]{this.survivabilityServerId, handleId};
    }

    protected Object[] getHandleBySetIdParams(Long csCommProfileSetId) {
        if (this.survivabilityServerId == null) {
            return new Object[]{csCommProfileSetId};
        }
        return new Object[]{this.survivabilityServerId, csCommProfileSetId};
    }

    protected String getHandleQuery() {
        return this.getHandleById;
    }

    protected Object[] getHandleParam(Object id) {
        return new Object[]{id};
    }

    public CsHandleDAO() {
        super(true);
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("filtersurvivabilityserver".equals(((String)entry.getKey()).toLowerCase())) {
                boolean filter = false;
                for (String value : (Set)entry.getValue()) {
                    if (!Boolean.parseBoolean(value)) continue;
                    filter = true;
                }
                reinit |= this.setFilterSurvivabilityServer(filter);
                continue;
            }
            if ("handletypes".equals(((String)entry.getKey()).toLowerCase())) {
                HashSet<String> superSet = new HashSet<String>();
                for (String value : (Set)entry.getValue()) {
                    String[] types = value.split(",");
                    if (types.length == 1 && ("null".equals(types[0]) || "all".equals(types[0]))) {
                        superSet = null;
                        continue;
                    }
                    if (superSet == null) continue;
                    for (String type : types) {
                        superSet.add(type.toLowerCase());
                    }
                }
                reinit |= this.setHandleTypes(superSet);
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected synchronized boolean setFilterSurvivabilityServer(boolean filter) {
        if (filter) {
            Long id = this.getAsmInstanceDAO().getMySIPEntityId();
            if (id == null) {
                id = 0L;
            }
            if (this.survivabilityServerId != null && this.survivabilityServerId.equals(id)) {
                return false;
            }
            this.survivabilityServerId = id;
        } else {
            if (this.survivabilityServerId == null) {
                return false;
            }
            this.survivabilityServerId = null;
        }
        this.setIdFlexCache.clear();
        this.flexCache.clear();
        this.rebuildQueries();
        return true;
    }

    protected synchronized boolean setHandleTypes(Set<String> types) {
        if (types == null && this.handleTypes == null || types != null && types.equals(this.handleTypes)) {
            return false;
        }
        this.handleTypes = types != null ? new HashSet<String>(types) : null;
        this.rebuildQueries();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rebuildQueries() {
        StringBuffer allHandleQuery = new StringBuffer("SELECT h.id, h.handle, h.csdomainid, h.credential, h.cscommprofilesetid, h.cshandletypeid, h.cshandlesubtypeid FROM cshandle h WHERE h.cscommprofilesetid NOT IN (" + isDeletedCommProfileSetId + ")");
        if (this.handleTypes != null) {
            boolean first = true;
            for (String type : this.handleTypes) {
                if (first) {
                    first = false;
                    allHandleQuery.append(" AND h.cshandletypeid IN (SELECT id FROM cshandletypeenum WHERE name='" + type + "'");
                    continue;
                }
                allHandleQuery.append(" OR name='" + type + "'");
            }
            if (!first) {
                allHandleQuery.append(")");
            }
        }
        try {
            this.lock.acquireWriteLock();
            this.getAllHandles = allHandleQuery.toString();
            this.getHandleById = this.getAllHandles + " AND h.id = ?";
            this.getHandleBySetId = this.getAllHandles + " AND h.cscommprofilesetid = ?";
            if (this.survivabilityServerId != null) {
                this.getAllHandles = this.getAllHandlesSurvivable;
                this.getHandleById = this.getAllHandles + " AND h.id = ?";
                this.getHandleBySetId = this.getAllHandles + " AND h.cscommprofilesetid = ?";
                this.getHandleByAsmId = this.getAllHandles.replace("asm.survivability_server_id = ?", "asm.id = ?");
                this.getHandleByHandle = this.getAllHandles.replace(" asm.survivability_server_id = ?", "") + " h.csdomainid = ? AND LOWER(h.handle) = LOWER(?)";
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        if (!this.uninitialized()) {
            this.reinit();
        }
    }

    protected Long getForeignDomainIdFromDB() throws DMException {
        Long id = null;
        id = (Long)this.dataSource.executeQuery(getForeignDomainId, this.emptyParams, idMapper);
        return id;
    }

    protected String getHandleMapKey(CsHandle handle) {
        return this.getHandleMapKey(handle.getHandle(), handle.getCsDomainId());
    }

    protected String getHandleMapKey(String handle, long csDomainId) {
        return handle != null && this.isForeignDomain(csDomainId) ? handle.toLowerCase() : handle;
    }

    protected boolean isForeignDomain(long csDomainId) {
        return this.foreignDomainId != null && this.foreignDomainId.equals(csDomainId);
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map handleByIdMapTMP;
        Map handleSubTypeMapTMP;
        Map handleTypeMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + CsHandleDAO.class.getSimpleName()));
        }
        HashMap<Long, Map<String, Object>> handleMapTMP = new HashMap<Long, Map<String, Object>>();
        HashMap<Long, Set<CsHandle>> commProfileSetMapTMP = new HashMap<Long, Set<CsHandle>>();
        Object[] params = new Object[]{};
        try {
            if (this.survivabilityServerId != null) {
                this.survivabilityServerId = this.getAsmInstanceDAO().getMySIPEntityId();
                if (this.survivabilityServerId == null) {
                    this.survivabilityServerId = 0L;
                }
            }
            this.foreignDomainId = this.getForeignDomainIdFromDB();
            this.setStatus(DataMgr.Status.UNINITIALIZED);
            this.rebuildQueries();
            handleTypeMapTMP = (Map)this.dataSource.executeQuery(getAllHandleTypes, params, handleTypeMapper);
            handleSubTypeMapTMP = (Map)this.dataSource.executeQuery(getAllHandleSubTypes, params, handleSubTypeMapper);
            handleByIdMapTMP = (Map)this.dataSource.executeQuery(this.getAllHandleQuery(), this.getAllHandleParams(), handleMapper);
            for (CsHandle handle : handleByIdMapTMP.values()) {
                this.putHandleInMap(handleMapTMP, handle);
                long csCommProfileSetId = handle.getCsCommProfileSetId();
                if (!commProfileSetMapTMP.containsKey(csCommProfileSetId)) {
                    commProfileSetMapTMP.put(csCommProfileSetId, new HashSet());
                }
                ((Set)commProfileSetMapTMP.get(csCommProfileSetId)).add(handle);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName() + ": " + e));
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.handleTypeMap = handleTypeMapTMP;
                this.handleSubTypeMap = handleSubTypeMapTMP;
                this.handleByIdMap = handleByIdMapTMP;
                this.handleMap = handleMapTMP;
                this.commProfileSetMap = commProfileSetMapTMP;
                this.setIdFlexCache.clear();
                this.flexCache.clear();
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    private void putHandleInMap(Map<Long, Map<String, Object>> map, CsHandle handle) {
        String handleKey;
        Object object;
        long csDomainId = handle.getCsDomainId();
        Map<String, Object> domainMap = map.get(csDomainId);
        if (domainMap == null) {
            domainMap = new HashMap<String, Object>();
            map.put(csDomainId, domainMap);
        }
        if ((object = domainMap.get(handleKey = this.getHandleMapKey(handle))) == null) {
            domainMap.put(handleKey, handle);
        } else if (object instanceof CsHandle) {
            ArrayList<CsHandle> handleList = new ArrayList<CsHandle>();
            handleList.add((CsHandle)object);
            handleList.add(handle);
            domainMap.put(handleKey, handleList);
        } else {
            ((List)object).add(handle);
        }
    }

    private void removeHandleFromMap(CsHandle handle) {
        if (handle == null) {
            return;
        }
        long csDomainId = handle.getCsDomainId();
        Map<String, Object> domainMap = this.handleMap.get(csDomainId);
        if (domainMap == null) {
            return;
        }
        String handleKey = this.getHandleMapKey(handle);
        Object object = domainMap.get(handleKey);
        if (object == null) {
            return;
        }
        if (object instanceof CsHandle) {
            if (object.equals(handle)) {
                domainMap.remove(handleKey);
            }
        } else {
            List handleList = (List)object;
            handleList.remove(handle);
            if (handleList.size() == 0) {
                domainMap.remove(handleKey);
            } else if (handleList.size() == 1) {
                CsHandle remainingHandle = (CsHandle)handleList.get(0);
                domainMap.put(handleKey, remainingHandle);
            }
        }
        if (domainMap.isEmpty()) {
            this.handleMap.remove(csDomainId);
        }
    }

    @Override
    public DataMgr.Status reinit() {
        Object collection;
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)"CsHandleDAO reinit");
        }
        if (!((collection = this.getMainCollection()) instanceof Map)) {
            this.log.warn((Object)"Encountered unexpected object type in main collection during CsHandleDAO reinit");
            return super.reinit();
        }
        Map oldMap = (Map)collection;
        if (oldMap == null || oldMap.isEmpty()) {
            this.init();
            return DataMgr.Status.OKAY;
        }
        return super.reinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        ArrayList<CsHandle> oldCsHandles = new ArrayList<CsHandle>();
        ArrayList<CsHandle> newCsHandles = new ArrayList<CsHandle>();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean locked = false;
        try {
            Map tMap;
            Object[] params;
            Object[] params2;
            if ("csuser".equals(tableName) && operation == DAOReplicationEvent.OperationType.UPDATE) {
                Object[] params3 = new Object[]{id};
                Map userMap = (Map)this.dataSource.executeQuery(this.getIdsByUserId, params3, userMapper);
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)(this.logTag(operation, tableName, id) + "CsCommProfileSets for user now have deleted state: " + userMap));
                }
                HashSet<CsHandle> deletedHandles = new HashSet<CsHandle>();
                HashSet addedHandles = new HashSet();
                for (Map.Entry entry : userMap.entrySet()) {
                    if (((Boolean)entry.getValue()).booleanValue()) {
                        Set<CsHandle> handles = this.getHandles((Long)entry.getKey());
                        if (handles == null) continue;
                        deletedHandles.addAll(handles);
                        continue;
                    }
                    params3 = this.getHandleBySetIdParams((Long)entry.getKey());
                    Map map = (Map)this.dataSource.executeQuery(this.getHandleBySetId, params3, handleMapper);
                    addedHandles.addAll(map.values());
                    if (this.survivabilityServerId == null || map.size() != 0 || this.commProfileSetMap.get(entry.getKey()) == null || this.commProfileSetMap.get(entry.getKey()).size() <= 0) continue;
                    Long ssId = null;
                    params3 = new Object[]{entry.getKey()};
                    ssId = (Long)this.dataSource.executeQuery(getSurvivabilityServerId, params3, idMapper);
                    if (this.survivabilityServerId.equals(ssId)) continue;
                    deletedHandles.addAll((Collection)this.commProfileSetMap.get(entry.getKey()));
                }
                this.lock.acquireWriteLock();
                locked = true;
                for (CsHandle handle : deletedHandles) {
                    this.handleByIdMap.remove(handle.getId());
                    long csCommProfileSetId = handle.getCsCommProfileSetId();
                    if (this.commProfileSetMap.containsKey(csCommProfileSetId)) {
                        this.commProfileSetMap.get(csCommProfileSetId).remove(handle);
                        if (this.commProfileSetMap.get(csCommProfileSetId).isEmpty()) {
                            this.commProfileSetMap.remove(csCommProfileSetId);
                        }
                    }
                    this.removeHandleFromMap(handle);
                    oldCsHandles.add(handle);
                    newCsHandles.add(null);
                }
                for (CsHandle handle : addedHandles) {
                    CsHandle oldHandle = this.handleByIdMap.get(handle.getId());
                    this.handleByIdMap.put(handle.getId(), handle);
                    this.removeHandleFromMap(oldHandle);
                    this.putHandleInMap(this.handleMap, handle);
                    long csCommProfileSetId = handle.getCsCommProfileSetId();
                    if (!this.commProfileSetMap.containsKey(csCommProfileSetId)) {
                        this.commProfileSetMap.put(csCommProfileSetId, new HashSet());
                    }
                    this.commProfileSetMap.get(csCommProfileSetId).remove(oldHandle);
                    this.commProfileSetMap.get(csCommProfileSetId).add(handle);
                    oldCsHandles.add(oldHandle);
                    newCsHandles.add(handle);
                }
                this.setIdFlexCache.clear();
                this.flexCache.clear();
            }
            if ("asmcommprofile".equals(tableName) && operation == DAOReplicationEvent.OperationType.UPDATE && this.survivabilityServerId != null) {
                HashSet addedHandles = new HashSet();
                HashSet deletedHandles = new HashSet();
                params2 = new Object[]{id};
                Map map = (Map)this.dataSource.executeQuery(this.getHandleByAsmId, params2, handleMapper);
                Long ssId = null;
                ssId = (Long)this.dataSource.executeQuery(getSurvivabilityServerIdByAsmId, params2, survivableIdMapper);
                if (this.survivabilityServerId.equals(ssId)) {
                    addedHandles.addAll(map.values());
                } else {
                    deletedHandles.addAll(map.values());
                }
                this.lock.acquireWriteLock();
                locked = true;
                for (CsHandle handle : deletedHandles) {
                    this.handleByIdMap.remove(handle.getId());
                    long csCommProfileSetId = handle.getCsCommProfileSetId();
                    if (this.commProfileSetMap.containsKey(csCommProfileSetId)) {
                        this.commProfileSetMap.get(csCommProfileSetId).remove(handle);
                        if (this.commProfileSetMap.get(csCommProfileSetId).isEmpty()) {
                            this.commProfileSetMap.remove(csCommProfileSetId);
                        }
                    }
                    this.removeHandleFromMap(handle);
                    oldCsHandles.add(handle);
                    newCsHandles.add(null);
                }
                for (CsHandle handle : addedHandles) {
                    CsHandle oldHandle = this.handleByIdMap.get(handle.getId());
                    this.handleByIdMap.put(handle.getId(), handle);
                    this.removeHandleFromMap(oldHandle);
                    this.putHandleInMap(this.handleMap, handle);
                    long csCommProfileSetId = handle.getCsCommProfileSetId();
                    if (!this.commProfileSetMap.containsKey(csCommProfileSetId)) {
                        this.commProfileSetMap.put(csCommProfileSetId, new HashSet());
                    }
                    this.commProfileSetMap.get(csCommProfileSetId).remove(oldHandle);
                    this.commProfileSetMap.get(csCommProfileSetId).add(handle);
                    oldCsHandles.add(oldHandle);
                    newCsHandles.add(handle);
                }
                this.setIdFlexCache.clear();
                this.flexCache.clear();
            }
            if ("cshandletypeenum".equals(tableName)) {
                String handleType = null;
                if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                    params = new Object[]{id};
                    tMap = (Map)this.dataSource.executeQuery(getHandleTypeById, params, handleTypeMapper);
                    handleType = (String)tMap.get(id);
                }
                this.lock.acquireWriteLock();
                locked = true;
                if (handleType != null) {
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "Retrieved new csHandleType " + handleType));
                    }
                    this.handleTypeMap.put(id, handleType);
                } else {
                    this.handleTypeMap.remove(id);
                }
            } else if ("cshandlesubtypeenum".equals(tableName)) {
                String handleSubType = null;
                if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                    params = new Object[]{id};
                    tMap = (Map)this.dataSource.executeQuery(getHandleSubTypeById, params, handleSubTypeMapper);
                    handleSubType = (String)tMap.get(id);
                }
                this.lock.acquireWriteLock();
                locked = true;
                if (handleSubType != null) {
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "Retrieved new csHandleSubType " + handleSubType));
                    }
                    this.handleSubTypeMap.put(id, handleSubType);
                } else {
                    this.handleSubTypeMap.remove(id);
                }
            } else if ("cshandle".equals(tableName)) {
                CsHandle newCsHandle = null;
                if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                    params = this.getHandleByIdParams(id);
                    Map hMap = (Map)this.dataSource.executeQuery(this.getHandleQuery(), params, handleMapper);
                    newCsHandle = (CsHandle)hMap.get(id);
                }
                Long ssId = null;
                if (this.survivabilityServerId != null && newCsHandle != null) {
                    params2 = new Object[]{newCsHandle.getCsCommProfileSetId()};
                    ssId = (Long)this.dataSource.executeQuery(getSurvivabilityServerId, params2, idMapper);
                }
                this.lock.acquireWriteLock();
                locked = true;
                CsHandle oldCsHandle = this.handleByIdMap.remove(id);
                if (oldCsHandle != null) {
                    long csCommProfileSetId = oldCsHandle.getCsCommProfileSetId();
                    if (this.commProfileSetMap.containsKey(csCommProfileSetId)) {
                        this.commProfileSetMap.get(csCommProfileSetId).remove(oldCsHandle);
                        if (this.commProfileSetMap.get(csCommProfileSetId).isEmpty()) {
                            this.commProfileSetMap.remove(csCommProfileSetId);
                        }
                    }
                    this.removeHandleFromMap(oldCsHandle);
                }
                if (newCsHandle != null && this.survivabilityServerId != null && !this.survivabilityServerId.equals(ssId)) {
                    newCsHandle = null;
                }
                if (newCsHandle != null) {
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)(this.logTag(operation, tableName, id) + "Retrieved new CsHandle " + newCsHandle));
                    }
                    this.handleByIdMap.put(id, newCsHandle);
                    this.putHandleInMap(this.handleMap, newCsHandle);
                    long csCommProfileSetId = newCsHandle.getCsCommProfileSetId();
                    if (!this.commProfileSetMap.containsKey(csCommProfileSetId)) {
                        this.commProfileSetMap.put(csCommProfileSetId, new HashSet());
                    }
                    this.commProfileSetMap.get(csCommProfileSetId).add(newCsHandle);
                }
                this.setIdFlexCache.clear();
                this.flexCache.clear();
                oldCsHandles.add(oldCsHandle);
                newCsHandles.add(newCsHandle);
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + CsHandleDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            oldCsHandles.clear();
            newCsHandles.clear();
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        for (int i = 0; i < oldCsHandles.size(); ++i) {
            if (oldCsHandles.get(i) == null && newCsHandles.get(i) == null) continue;
            this.updateListeners(oldCsHandles.get(i), newCsHandles.get(i));
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    @Override
    public String getMainTable() {
        return "cshandle";
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("cshandle");
        list.add("asmcommprofile");
        list.add("cshandletypeenum");
        list.add("cshandlesubtypeenum");
        list.add("csuser");
        return list;
    }

    protected int getFlexCacheSizeLimit() {
        return Math.min(this.commProfileSetMap.size() / 2, 16);
    }

    protected void pruneFlexCache() {
        while (this.flexCache.size() > this.getFlexCacheSizeLimit()) {
            CsHandle handle = this.flexCache.removeLast();
            long setId = handle.getCsCommProfileSetId();
            if (!this.setIdFlexCache.contains(setId)) continue;
            this.setIdFlexCache.remove(setId);
            for (int i = 0; i < this.flexCache.size(); ++i) {
                if (this.flexCache.get(i).getCsCommProfileSetId() != setId) continue;
                this.flexCache.remove(i--);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsHandle getHandle(Long csHandleId) {
        try {
            this.lock.acquireReadLock();
            if (this.survivabilityServerId == null || this.handleByIdMap.containsKey(csHandleId)) {
                CsHandle csHandle = this.handleByIdMap.get(csHandleId);
                return csHandle;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        CsHandle retVal = null;
        try {
            this.lock.acquireReadLock();
            for (CsHandle handle : this.flexCache) {
                if (handle.getId() != csHandleId.longValue()) continue;
                retVal = handle;
                break;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retVal != null) {
            try {
                this.lock.acquireWriteLock();
                this.flexCache.remove(retVal);
                this.flexCache.addFirst(retVal);
                this.pruneFlexCache();
            }
            finally {
                this.lock.releaseWriteLock();
            }
            return retVal;
        }
        Object[] params = this.getHandleByIdParams(csHandleId);
        Map map = null;
        try {
            map = (Map)this.dataSource.executeQuery(this.getHandleById, params, handleMapper);
        }
        catch (DMException e) {
            this.log.warn((Object)("Exception querying for handle with parameters " + csHandleId));
        }
        if (map != null) {
            try {
                this.lock.acquireWriteLock();
                Iterator iterator = map.values().iterator();
                if (iterator.hasNext()) {
                    CsHandle handle = (CsHandle)iterator.next();
                    this.flexCache.remove(handle);
                    this.flexCache.addFirst(handle);
                    this.pruneFlexCache();
                    CsHandle csHandle = handle;
                    return csHandle;
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsHandle> getHandles(Long csCommProfileSetId) {
        try {
            this.lock.acquireReadLock();
            if (this.survivabilityServerId == null || this.commProfileSetMap.containsKey(csCommProfileSetId)) {
                Set<CsHandle> set = this.commProfileSetMap.get(csCommProfileSetId);
                return set;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        HashSet<CsHandle> retVal = null;
        try {
            this.lock.acquireReadLock();
            if (this.setIdFlexCache.contains(csCommProfileSetId)) {
                retVal = new HashSet<CsHandle>();
                for (CsHandle handle : this.flexCache) {
                    if (handle.getCsCommProfileSetId() != csCommProfileSetId.longValue()) continue;
                    retVal.add(handle);
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retVal != null) {
            try {
                this.lock.acquireWriteLock();
                for (CsHandle handle : retVal) {
                    this.flexCache.remove(handle);
                    this.flexCache.addFirst(handle);
                }
                this.pruneFlexCache();
            }
            finally {
                this.lock.releaseWriteLock();
            }
            return retVal;
        }
        Object[] params = this.getHandleBySetIdParams(csCommProfileSetId);
        Map map = null;
        try {
            map = (Map)this.dataSource.executeQuery(this.getHandleBySetId, params, handleMapper);
        }
        catch (DMException e) {
            this.log.warn((Object)("Exception querying for handle with CommProfileSet ID " + csCommProfileSetId));
        }
        if (map != null) {
            try {
                this.lock.acquireWriteLock();
                this.setIdFlexCache.add(csCommProfileSetId);
                for (CsHandle handle : map.values()) {
                    this.flexCache.remove(handle);
                    this.flexCache.addFirst(handle);
                }
                this.pruneFlexCache();
                HashSet hashSet = new HashSet(map.values());
                return hashSet;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return null;
    }

    public CsHandle getHandle(String handleString, long csDomainId) {
        List<CsHandle> handles = this.getHandles(handleString, csDomainId);
        if (handles.isEmpty()) {
            return null;
        }
        return handles.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CsHandle> getHandles(String handleString, long csDomainId) {
        ArrayList<CsHandle> handles = new ArrayList<CsHandle>();
        String handleMapKey = this.getHandleMapKey(handleString, csDomainId);
        try {
            this.lock.acquireReadLock();
            Map<String, Object> domainMap = this.handleMap.get(csDomainId);
            if (domainMap == null) {
                ArrayList<CsHandle> arrayList = handles;
                return arrayList;
            }
            Object object = domainMap.get(handleMapKey);
            if (object == null) {
                if (handleMapKey != null) {
                    object = domainMap.get(handleMapKey.toLowerCase());
                }
                if (object == null) {
                    ArrayList<CsHandle> arrayList = handles;
                    return arrayList;
                }
            }
            if (object instanceof CsHandle) {
                CsHandle handle = (CsHandle)object;
                if (this.handleMatches(handle, handleString)) {
                    handles.add(handle);
                }
            } else {
                List handleList = (List)object;
                for (CsHandle handle : handleList) {
                    if (!this.handleMatches(handle, handleString)) continue;
                    handles.add(handle);
                }
            }
            ArrayList<CsHandle> arrayList = handles;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected boolean handleMatches(CsHandle csHandle, String handleString) {
        if (csHandle.getHandle().equals(handleString)) {
            return true;
        }
        if (this.isForeignDomain(csHandle.getCsDomainId())) {
            boolean caseSensitive = this.getCaseSensitivity(csHandle.getCsHandleTypeId());
            String[] csHandleComps = this.decomposeHandle(csHandle.getHandle());
            String[] handleStrComps = this.decomposeHandle(handleString);
            String csHandleUser = csHandleComps[0];
            String csHandleDomain = csHandleComps[1];
            String handleStrUser = handleStrComps[0];
            String handleStrDomain = handleStrComps[1];
            if (csHandleUser == null) {
                return handleStrUser == null;
            }
            if (handleStrUser == null) {
                return false;
            }
            if (caseSensitive ? !csHandleUser.equals(handleStrUser) : !csHandleUser.equalsIgnoreCase(handleStrUser)) {
                return false;
            }
            if (csHandleDomain == null) {
                return handleStrDomain == null;
            }
            if (handleStrDomain == null) {
                return false;
            }
            return csHandleDomain.equalsIgnoreCase(handleStrDomain);
        }
        boolean caseSensitive = this.getCaseSensitivity(csHandle.getCsHandleTypeId());
        return !caseSensitive && csHandle.getHandle().equalsIgnoreCase(handleString);
    }

    private String[] decomposeHandle(String handle) {
        String[] retArr = new String[2];
        if (handle == null) {
            retArr[0] = null;
            retArr[1] = null;
        } else {
            int pos = handle.indexOf(64);
            if (pos == -1) {
                retArr[0] = handle;
                retArr[1] = null;
            } else {
                retArr[0] = handle.substring(0, pos);
                retArr[1] = handle.substring(pos + 1);
            }
        }
        return retArr;
    }

    private boolean getCaseSensitivity(long csHandleTypeId) {
        String typeName = this.handleTypeMap.get(csHandleTypeId);
        if (typeName == null) {
            return true;
        }
        for (String caseSensitiveTypeNames : this.caseSensitiveHandleTypes) {
            if (!typeName.equalsIgnoreCase(caseSensitiveTypeNames)) continue;
            return true;
        }
        return false;
    }

    @SMConsole(description="Get all cached Handle objects.")
    public Map<Long, CsHandle> getAllHandles() {
        this.lock.acquireReadLock();
        try {
            Map<Long, CsHandle> map = this.handleByIdMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get CsHandles in handleMap")
    public List<CsHandle> getHandleMap() {
        ArrayList<CsHandle> handleArray = new ArrayList<CsHandle>();
        this.lock.acquireReadLock();
        try {
            for (Map<String, Object> domainMap : this.handleMap.values()) {
                for (Object object : domainMap.values()) {
                    if (object instanceof CsHandle) {
                        handleArray.add((CsHandle)object);
                        continue;
                    }
                    handleArray.addAll((List)object);
                }
            }
            ArrayList<CsHandle> arrayList = handleArray;
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned Handle Type mappings.")
    public Map<Long, String> getAllHandleTypes() {
        this.lock.acquireReadLock();
        try {
            Map<Long, String> map = this.handleTypeMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get commProfileSetMap.")
    public Map<Long, Set<CsHandle>> getCommProfileSetMap() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Set<CsHandle>> map = this.commProfileSetMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned Handle SubType mappings.")
    public Map<Long, String> getAllHandleSubTypes() {
        this.lock.acquireReadLock();
        try {
            Map<Long, String> map = this.handleSubTypeMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public String getCsHandleType(Long csHandleTypeId) {
        try {
            this.lock.acquireReadLock();
            String string = this.handleTypeMap.get(csHandleTypeId);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public String getCsHandleSubType(Long csHandleSubTypeId) {
        try {
            this.lock.acquireReadLock();
            String string = this.handleSubTypeMap.get(csHandleSubTypeId);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.handleByIdMap;
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmInstance || newObject instanceof AsmInstance) {
            if (this.survivabilityServerId == null) {
                return;
            }
            AsmInstance curInstance = this.getAsmInstanceDAO().getMyAsmInstance();
            if (curInstance == null) {
                return;
            }
            AsmInstance newInstance = (AsmInstance)newObject;
            if (curInstance == newInstance) {
                AsmInstance oldInstance = (AsmInstance)oldObject;
                if (oldInstance != null) {
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)("Doing nothing as result of " + AsmInstance.class.getSimpleName() + " change."));
                    }
                    return;
                }
                this.log.fine((Object)"Reinitializing because we have a new AsmInstance identity");
                this.reinit();
            } else if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Doing nothing as result of " + AsmInstance.class.getSimpleName() + " change."));
            }
        } else {
            this.log.warn((Object)("Received unexpected change alert for " + oldObject + " changing to " + newObject + "; re-initializing"));
            this.reinit();
        }
    }

    public static void main(String[] args) {
        CsHandleDAO dao = new CsHandleDAO();
        dao.rebuildQueries();
        System.out.println("SM_getAllHandles=" + dao.getAllHandles);
        System.out.println("SM_getHandleById=" + dao.getHandleById);
        System.out.println("SM_getHandleBySetId=" + dao.getHandleBySetId);
        System.out.println("SM_getHandleByHandle=" + dao.getHandleByHandle);
        dao = new CsHandleDAO();
        dao.survivabilityServerId = 0L;
        dao.rebuildQueries();
        System.out.println("BSM_getAllHandles=" + dao.getAllHandles);
        System.out.println("BSM_getHandleById=" + dao.getHandleById);
        System.out.println("BSM_getHandleBySetId=" + dao.getHandleBySetId);
        System.out.println("BSM_getHandleByHandle=" + dao.getHandleByHandle);
    }
}

