/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.DigitMapRouter;
import com.avaya.asm.datamgr.objectapi.DigitMapRow;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DigitMapRouterDAO
extends DataAccessObject {
    protected static final Logger log = AsmLogger.getLogger(DigitMapRouterDAO.class);
    protected Map<Long, Map<Long, Map<Long, DigitMapRouter>>> dmrMap = new ConcurrentHashMap<Long, Map<Long, Map<Long, DigitMapRouter>>>();
    protected Map<Long, DigitMapRow> digitMapTable = new ConcurrentHashMap<Long, DigitMapRow>();
    protected static final String queryDMR = "SELECT id, mindigits, maxdigits, digitpattern, deny, routingorigination_id, sipdomain_id, digitmap_origination_pattern_set_id, treatasemergency FROM digitmap";
    protected static final String queryDMRRow = "SELECT id, mindigits, maxdigits, digitpattern, deny, routingorigination_id, sipdomain_id, digitmap_origination_pattern_set_id, treatasemergency FROM digitmap WHERE id = ?";
    protected static final ResultSetMapper digitMapRowsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, DigitMapRow> digRowMap = new ConcurrentHashMap<Long, DigitMapRow>();
            while (rs.next()) {
                long id = rs.getLong("id");
                digRowMap.put(id, new DigitMapRow(id, rs.getShort("mindigits"), rs.getShort("maxdigits"), rs.getString("digitpattern"), rs.getBoolean("deny"), rs.getLong("routingorigination_id"), rs.getLong("sipdomain_id"), rs.getLong("digitmap_origination_pattern_set_id"), rs.getBoolean("treatasemergency")));
            }
            return digRowMap;
        }
    };

    protected void insertRowIntoDmrMap(Map<Long, Map<Long, Map<Long, DigitMapRouter>>> dmrMap, Long id, DigitMapRow row) throws DMException {
        DigitMapRouter dmr;
        Map<Long, DigitMapRouter> origMap;
        if (row == null) {
            return;
        }
        Long origPatSetId = row.getOrigPatternSetId();
        Long sipDomainId = row.getSipDomainId();
        Long routingOriginationId = row.getRoutingOrigId();
        Map<Long, Map<Long, DigitMapRouter>> domainMap = dmrMap.get(origPatSetId);
        if (domainMap == null) {
            domainMap = new ConcurrentHashMap<Long, Map<Long, DigitMapRouter>>();
            dmrMap.put(origPatSetId, domainMap);
        }
        if ((origMap = domainMap.get(sipDomainId)) == null) {
            origMap = new ConcurrentHashMap<Long, DigitMapRouter>();
            domainMap.put(sipDomainId, origMap);
        }
        if ((dmr = origMap.get(routingOriginationId)) == null) {
            dmr = new DigitMapRouter();
            origMap.put(routingOriginationId, dmr);
        }
        try {
            for (DigitMapRow subrow : row.getSubrows()) {
                dmr.insert(subrow.getDigits(), subrow.getMin(), subrow.getMax(), row);
            }
        }
        catch (IllegalArgumentException e1) {
            throw new DMException(e1);
        }
        catch (UnsupportedOperationException e2) {
            throw new DMException(e2);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("Inserted " + row + " into DigitMapRouter"));
        }
    }

    private void deleteRowFromDmrMap(DigitMapRow row) throws DMException {
        DigitMapRouter dmr;
        Map<Long, DigitMapRouter> origMap;
        Map<Long, Map<Long, DigitMapRouter>> domainMap;
        block11: {
            if (row == null) {
                return;
            }
            domainMap = this.dmrMap.get(row.getOrigPatternSetId());
            if (domainMap == null) {
                throw new DMException(row + " existed in digitMapTable but not in dmrMap!");
            }
            origMap = domainMap.get(row.getSipDomainId());
            if (origMap == null) {
                throw new DMException(row + " existed in digitMapTable but not in dmrMap!");
            }
            dmr = origMap.get(row.getRoutingOrigId());
            if (dmr == null) {
                throw new DMException(row + " existed in digitMapTable but not in dmrMap!");
            }
            try {
                for (DigitMapRow subrow : row.getSubrows()) {
                    dmr.delete(subrow.getDigits(), subrow.getMin(), subrow.getMax(), row);
                }
            }
            catch (UnsupportedOperationException e) {
                if ("pattern/min/max not found".equals(e.getMessage())) break block11;
                throw new DMException(e);
            }
        }
        if (dmr.isEmpty()) {
            origMap.remove(row.getRoutingOrigId());
            if (origMap.isEmpty()) {
                domainMap.remove(row.getSipDomainId());
                if (domainMap.isEmpty()) {
                    this.dmrMap.remove(row.getOrigPatternSetId());
                }
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("Removed " + row + " from DigitMapRouter"));
        }
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    @Override
    public synchronized void init() {
        if (log.isFineEnabled()) {
            log.info((Object)("Initializing " + DigitMapRouterDAO.class.getSimpleName()));
        }
        ConcurrentHashMap<Long, Map<Long, Map<Long, DigitMapRouter>>> dmrMapTMP = new ConcurrentHashMap<Long, Map<Long, Map<Long, DigitMapRouter>>>();
        Map digitMapTableTMP = new ConcurrentHashMap();
        try {
            DMException innerException = null;
            Object[] params = new Object[]{};
            digitMapTableTMP = (Map)this.dataSource.executeQuery(queryDMR, params, digitMapRowsMapper);
            for (Map.Entry entry : digitMapTableTMP.entrySet()) {
                try {
                    this.insertRowIntoDmrMap(dmrMapTMP, (Long)entry.getKey(), (DigitMapRow)entry.getValue());
                }
                catch (DMException e1) {
                    this.setStatus(DataMgr.Status.FAIL);
                    log.error((Object)("Error on initializing for key=" + entry.getKey() + ", and value=" + entry.getValue()), (Throwable)e1);
                    innerException = e1;
                }
            }
            if (this.failed() && innerException != null) {
                throw innerException;
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e2) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e2);
            this.handleFailureEvent(e2);
        }
        this.dmrMap = dmrMapTMP;
        this.digitMapTable = digitMapTableTMP;
    }

    @Override
    public synchronized void updateDAO(DAOTableEvent event) {
        block12: {
            DAOReplicationEvent.OperationType operation = event.getOperation();
            String tableName = event.getTableName();
            if (!this.getDependentTables().contains(tableName) || operation == null) {
                return;
            }
            Long id = event.getKey();
            if (log.isFineEnabled()) {
                log.fine((Object)(DigitMapRouterDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
            }
            try {
                DigitMapRow remRow = this.digitMapTable.remove(id);
                if (remRow != null) {
                    this.deleteRowFromDmrMap(remRow);
                } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                    log.warn((Object)("Tried to remove a DigitMapRow for a " + (Object)((Object)operation) + " that didn't exist; we are probably out of sync."));
                }
                if (operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) {
                    Object[] params = new Object[]{id};
                    Map rows = (Map)this.dataSource.executeQuery(queryDMRRow, params, digitMapRowsMapper);
                    DigitMapRow row = (DigitMapRow)rows.get(id);
                    if (row == null) {
                        throw new DMException("updateDAO query returned null");
                    }
                    if (log.isFinerEnabled()) {
                        log.finer((Object)("Retrieved new DigitMapRow " + row));
                    }
                    this.digitMapTable.put(id, row);
                    this.insertRowIntoDmrMap(this.dmrMap, id, row);
                }
            }
            catch (DMException e) {
                log.error((Object)("Error updating " + DigitMapRouterDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (this.okay()) break block12;
                log.finer((Object)"Update NOT successful.");
                return;
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(DigitMapRouterDAO.class.getSimpleName() + " update successful"));
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)this.toString());
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("digitmap");
        return list;
    }

    public DigitMapRow getDigitMapRow(Long digitMapRowId) {
        return this.digitMapTable.get(digitMapRowId);
    }

    public DigitMapRouter getDigitMapRouter(Long origPatternSetId, Long domainId, Long locationId) {
        Map<Long, Map<Long, DigitMapRouter>> domainMap;
        Long locationKey;
        Long domainKey;
        Long origPatSetKey = origPatternSetId;
        if (origPatSetKey == null) {
            origPatSetKey = 0L;
        }
        if ((domainKey = domainId) == null) {
            domainKey = 0L;
        }
        if ((locationKey = locationId) == null) {
            locationKey = 0L;
        }
        if ((domainMap = this.dmrMap.get(origPatSetKey)) == null) {
            if (log.isFineEnabled()) {
                log.fine((Object)("DigitMapRouter for origPatternSet " + origPatternSetId + " domain " + domainId + " and location " + locationId + " not found"));
            }
            return null;
        }
        Map<Long, DigitMapRouter> origMap = domainMap.get(domainKey);
        if (origMap == null) {
            if (log.isFineEnabled()) {
                log.fine((Object)("DigitMapRouter for origPatternSet " + origPatternSetId + " domain " + domainId + " and location " + locationId + " not found"));
            }
            return null;
        }
        DigitMapRouter dmr = origMap.get(locationKey);
        if (log.isFineEnabled()) {
            log.fine((Object)("DigitMapRouter for origPatternSet " + origPatternSetId + " domain " + domainId + " and location " + locationId + (dmr == null ? " not found" : " found")));
        }
        return dmr;
    }

    @SMConsole(description="Get the global Digit Map Router.")
    public String getAllDigitMapRouter() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("Key: OrigPatternSetID_SIPDomainID_LocationID");
        for (Map.Entry<Long, Map<Long, Map<Long, DigitMapRouter>>> origEntry : this.dmrMap.entrySet()) {
            Long origPatternSetId = origEntry.getKey();
            for (Map.Entry<Long, Map<Long, DigitMapRouter>> domainEntry : origEntry.getValue().entrySet()) {
                Long sipDomainId = domainEntry.getKey();
                for (Map.Entry<Long, DigitMapRouter> dmrEntry : domainEntry.getValue().entrySet()) {
                    buf.append("\n");
                    buf.append(origPatternSetId);
                    buf.append("_");
                    buf.append(sipDomainId);
                    buf.append("_");
                    buf.append(dmrEntry.getKey());
                    buf.append(":\n");
                    buf.append(dmrEntry.getValue().dumpTree());
                }
            }
        }
        return buf.toString();
    }

    public static void setLogLevelForJUnit() {
        log.setLevel(LogLevel.INFO);
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

