/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.OldNewDataDiffs;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.LocalObject;
import com.avaya.asm.datamgr.objectapi.UserCommunityAssign;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LocalSipObjectDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(LocalSipObjectDAO.class);
    protected Map<Long, Long> mainCollection = new HashMap<Long, Long>();
    protected Map<Long, Set<Long>> reverseCollection = new HashMap<Long, Set<Long>>();
    protected static final String getCommunityCount = "SELECT count(*) FROM asmcommprofile WHERE usercommunity_id = ?";
    protected static final ResultSetMapper localMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            while (rs.next()) {
                map.put(rs.getLong("asmid"), rs.getLong("id"));
            }
            return map;
        }
    };
    protected final ResultSetMapper deletedMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList<DeletedState> collection = new ArrayList<DeletedState>();
            while (rs.next()) {
                collection.add(new DeletedState(rs.getLong("id"), rs.getLong("asmid"), rs.getBoolean("isdeleted")));
            }
            return collection;
        }
    };
    protected static final ResultSetMapper communityMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return null;
        }
    };

    public LocalSipObjectDAO() {
        super(true);
    }

    protected abstract LocalObject construct(long var1);

    protected Object[] getAllParams() {
        Long myAsmInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myAsmInstanceId == null) {
            myAsmInstanceId = 0L;
        }
        return new Object[]{myAsmInstanceId};
    }

    protected Object[] getSingleParams(Long id) {
        Long myAsmInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myAsmInstanceId == null) {
            myAsmInstanceId = 0L;
        }
        return new Object[]{myAsmInstanceId, id};
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class);
    }

    protected UserCommunityDAO getUserCommunityDAO() {
        return (UserCommunityDAO)this.getDataMgr(UserCommunityDAO.class);
    }

    protected abstract String getLocalIDsQuery();

    protected abstract String isLocalQuery();

    protected abstract String getDeletedByUserIdQuery();

    @Override
    protected Object getMainCollection() {
        return this.mainCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map mainCollectionTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        this.getAsmInstanceDAO();
        if (!DMUtilities.isBranch()) {
            this.getUserCommunityDAO();
        }
        HashMap<Long, Set<Long>> reverseCollectionTMP = new HashMap<Long, Set<Long>>();
        try {
            mainCollectionTMP = (Map)this.dataSource.executeQuery(this.getLocalIDsQuery(), this.getAllParams(), localMapper);
            for (Map.Entry entry : mainCollectionTMP.entrySet()) {
                Long cpId = (Long)entry.getKey();
                Long id = (Long)entry.getValue();
                HashSet<Long> cpIds = (HashSet<Long>)reverseCollectionTMP.get(id);
                if (cpIds == null) {
                    cpIds = new HashSet<Long>();
                    reverseCollectionTMP.put(id, cpIds);
                }
                cpIds.add(cpId);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.mainCollection = mainCollectionTMP;
                this.reverseCollection = reverseCollectionTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    protected List<OldNewDataDiffs> compareOldNewData(Object oldData, Object newData) {
        ArrayList<OldNewDataDiffs> diffList = new ArrayList<OldNewDataDiffs>();
        Collection oldCollection = ((Map)oldData).values();
        Collection newCollection = ((Map)newData).values();
        for (Long id : oldCollection) {
            if (newCollection.contains(id)) continue;
            diffList.add(new OldNewDataDiffs(this.construct(id), null));
        }
        for (Long id : newCollection) {
            if (oldCollection.contains(id)) continue;
            diffList.add(new OldNewDataDiffs(null, this.construct(id)));
        }
        return diffList;
    }

    protected abstract String getMainTable();

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmcommprofile");
        list.add("csuser");
        list.add("cshandle");
        list.add("cscommprofile");
        list.add("cscommprofileset");
        list.add("csuser");
        list.add("asmcommprofile");
        list.add("pscommprofile");
        list.add("cmcommprofile");
        list.add("zr_commprofile");
        if (!list.contains(this.getMainTable())) {
            list.add(this.getMainTable());
        }
        return list;
    }

    protected void updateMainTable(DAOReplicationEvent.OperationType operation, long id, List<Object> oldObjects, List<Object> newObjects) throws DMException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean lockHeld = false;
        ArrayList<Object> oldObjects = new ArrayList<Object>();
        ArrayList<Object> newObjects = new ArrayList<Object>();
        try {
            if ("csuser".equals(tableName)) {
                Collection collection;
                if (operation == DAOReplicationEvent.OperationType.UPDATE && !(collection = (Collection)this.dataSource.executeQuery(this.getDeletedByUserIdQuery(), this.getSingleParams(id), this.deletedMapper)).isEmpty()) {
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "User Deleted state update: " + collection));
                    }
                    boolean deleted = ((DeletedState)collection.iterator().next()).isDeleted;
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    if (deleted) {
                        for (DeletedState state : collection) {
                            Long oldId = this.mainCollection.remove(state.asmId);
                            Set<Long> cpIds = this.reverseCollection.get(oldId);
                            boolean removed = false;
                            if (cpIds != null) {
                                cpIds.remove(state.asmId);
                                if (cpIds.size() == 0) {
                                    this.reverseCollection.remove(oldId);
                                    removed = true;
                                }
                            }
                            if (oldId == null || !removed) continue;
                            oldObjects.add(this.construct(oldId));
                            newObjects.add(null);
                        }
                    } else {
                        for (DeletedState state : collection) {
                            if (this.mainCollection.containsKey(state.asmId)) continue;
                            Set<Long> cpIds = this.reverseCollection.get(state.id);
                            if (cpIds == null) {
                                cpIds = new HashSet<Long>();
                                this.reverseCollection.put(state.id, cpIds);
                                oldObjects.add(null);
                                newObjects.add(this.construct(state.id));
                            }
                            this.mainCollection.put(state.asmId, state.id);
                            cpIds.add(state.asmId);
                        }
                    }
                }
            } else if ("asmcommprofile".equals(tableName)) {
                Map map = null;
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    map = (Map)this.dataSource.executeQuery(this.isLocalQuery(), this.getSingleParams(id), localMapper);
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                if (map != null && map.containsKey(id)) {
                    if (!this.mainCollection.containsKey(id)) {
                        Long localId = (Long)map.get(id);
                        Set<Long> cpIds = this.reverseCollection.get(localId);
                        if (cpIds == null) {
                            cpIds = new HashSet<Long>();
                            this.reverseCollection.put(localId, cpIds);
                            oldObjects.add(null);
                            newObjects.add(this.construct(localId));
                        }
                        this.mainCollection.put(id, localId);
                        cpIds.add(id);
                    }
                } else {
                    Long oldId = this.mainCollection.remove(id);
                    Set<Long> cpIds = this.reverseCollection.get(oldId);
                    boolean removed = false;
                    if (cpIds != null) {
                        cpIds.remove(id);
                        if (cpIds.size() == 0) {
                            this.reverseCollection.remove(oldId);
                            removed = true;
                        }
                    }
                    if (oldId != null && removed) {
                        oldObjects.add(this.construct(oldId));
                        newObjects.add(null);
                    }
                }
            } else if (tableName.equals(this.getMainTable())) {
                this.lock.acquireWriteLock();
                lockHeld = true;
                this.updateMainTable(operation, id, oldObjects, newObjects);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            oldObjects.clear();
            newObjects.clear();
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (!oldObjects.isEmpty()) {
            this.updateListeners(oldObjects, newObjects);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmInstance || newObject instanceof AsmInstance) {
            AsmInstance myInstance = this.getAsmInstanceDAO().getMyAsmInstance();
            if (myInstance == null) {
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)("My instance is null - doing nothing as result of " + AsmInstance.class.getSimpleName() + " change"));
                }
                return;
            }
            AsmInstance newInstance = (AsmInstance)newObject;
            if (myInstance == newInstance) {
                AsmInstance oldInstance = (AsmInstance)oldObject;
                if (oldInstance == null) {
                    this.log.fine((Object)"Reinitializing because my instance became non-null");
                    this.reinit();
                } else {
                    if (IPAddress.areEqual(oldInstance.getManagementAccessPointHostName(), newInstance.getManagementAccessPointHostName())) {
                        if (this.log.isFinestEnabled()) {
                            this.log.finest((Object)("My instance was updated - doing nothing as result of " + AsmInstance.class.getSimpleName() + " change"));
                        }
                        return;
                    }
                    this.log.fine((Object)"Reinitializing because my instance's address changed");
                    this.reinit();
                }
            } else if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("New instance is not my instance - doing nothing as result of " + AsmInstance.class.getSimpleName() + " change"));
            }
        } else if (oldObject instanceof UserCommunityAssign || newObject instanceof UserCommunityAssign) {
            AsmInstance myInstance;
            Integer count = null;
            Object[] params = null;
            try {
                params = oldObject != null ? new Object[]{((UserCommunityAssign)oldObject).getAsmusercommunity_id()} : new Object[]{((UserCommunityAssign)newObject).getAsmusercommunity_id()};
                count = (Integer)this.dataSource.executeQuery(getCommunityCount, params, communityMapper);
            }
            catch (Exception e) {
                this.log.warn((Object)(e + " - while querying for number of AsmCommProfiles in community " + Arrays.toString(params)));
            }
            if (count != null && count > 0 && (myInstance = this.getAsmInstanceDAO().getMyAsmInstance()) != null) {
                UserCommunityAssign oldAssign = (UserCommunityAssign)oldObject;
                UserCommunityAssign newAssign = (UserCommunityAssign)newObject;
                if (oldAssign != null && myInstance.getId() == oldAssign.getAsmInstance_id() || newAssign != null && myInstance.getId() == newAssign.getAsmInstance_id()) {
                    this.log.error((Object)"A User Community that we are a member of was modified even though there are AsmCommProfiles assigned to it. This should never happen! Reinitializing, since we can't handle this in-line.");
                    this.reinit();
                    return;
                }
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Doing nothing as result of " + UserCommunityAssign.class.getSimpleName() + " change."));
            }
        } else {
            this.log.warn((Object)(this.getClass().getSimpleName() + ": Received unexpected change alert for " + oldObject + " changing to " + newObject + "; re-initializing"));
            this.reinit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(long id) {
        this.lock.acquireReadLock();
        try {
            boolean bl = this.reverseCollection.containsKey(id);
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected void printQueries() {
        System.out.println("getLocalIDs=" + this.getLocalIDsQuery());
        System.out.println("getDeletedByUserId=" + this.getDeletedByUserIdQuery());
        System.out.println("isLocal=" + this.isLocalQuery());
    }

    protected static class DeletedState {
        public final long id;
        public final long asmId;
        public final boolean isDeleted;

        public DeletedState(long id, long asmId, boolean isDeleted) {
            this.id = id;
            this.asmId = asmId;
            this.isDeleted = isDeleted;
        }

        public String toString() {
            return "DeletedState[id=" + this.id + ", asmId=" + this.asmId + ", isDeleted=" + this.isDeleted + "]";
        }
    }
}

