/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.dao.CommProfileDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import com.avaya.asm.datamgr.objectapi.PsCommProfile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PsCommProfileDAO
extends CommProfileDAO {
    public static final String commProfileType = "PS";
    private static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, PsCommProfile> profileMap = new ConcurrentHashMap<Long, PsCommProfile>();
            while (rs.next()) {
                long id = rs.getLong("id");
                profileMap.put(id, new PsCommProfile(id, (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid"), (Long)rs.getObject("ps_sipentity_id"), (Long)rs.getObject("im_gateway_sipentity_id")));
            }
            return profileMap;
        }
    };

    @Override
    public String getMainTable() {
        return "pscommprofile";
    }

    @Override
    protected String getSelectFields() {
        return "SELECT cs.id, cs.cscommprofilesetid, cs.preferredhandleid, ps.ps_sipentity_id, ps.im_gateway_sipentity_id FROM cscommprofile cs JOIN pscommprofile ps ON cs.id=ps.id";
    }

    @Override
    protected ResultSetMapper getMapper() {
        return mapper;
    }

    public PsCommProfile getPsCommProfile(Long id) {
        try {
            this.lock.acquireReadLock();
            if (id != null) {
                PsCommProfile psCommProfile = (PsCommProfile)this.csCommProfileMap.get(id);
                return psCommProfile;
            }
            PsCommProfile psCommProfile = null;
            return psCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsCommProfile getPsCommProfileBySetId(Long setId) {
        try {
            this.lock.acquireReadLock();
            Long id = (Long)this.setIdMap.get(setId);
            if (id != null) {
                PsCommProfile psCommProfile = (PsCommProfile)this.csCommProfileMap.get(id);
                return psCommProfile;
            }
            PsCommProfile psCommProfile = null;
            return psCommProfile;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all PsCommProfiles cached in memory.")
    public Map<Long, CsCommProfile> getPsCommProfiles() {
        this.lock.acquireReadLock();
        try {
            Map<Long, CsCommProfile> map = Collections.unmodifiableMap(this.csCommProfileMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public static void main(String[] args) {
        PsCommProfileDAO dao = new PsCommProfileDAO();
        dao.printQueries();
    }

    @Override
    protected String getCommProfileType() {
        return commProfileType;
    }
}

