/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.UserCommunityAssign;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UserCommunityDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(UserCommunityDAO.class);
    protected Map<Long, UserCommunityAssign> assignMap = new HashMap<Long, UserCommunityAssign>();
    protected Map<Long, List<UserCommunityAssign>> instanceAssignMap = new HashMap<Long, List<UserCommunityAssign>>();
    protected Map<Long, List<UserCommunityAssign>> communityAssignMap = new HashMap<Long, List<UserCommunityAssign>>();
    public static final String getUserCommunityAssigns = "SELECT id, asmInstance_id, asmusercommunity_id, priorityorder FROM asmusercommunityassign";
    public static final String getUserCommunityAssign = "SELECT id, asmInstance_id, asmusercommunity_id, priorityorder FROM asmusercommunityassign WHERE id = ?";
    protected static final ResultSetMapper userCommunityAssignMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, UserCommunityAssign> map = new HashMap<Long, UserCommunityAssign>();
            while (rs.next()) {
                UserCommunityAssign assign = new UserCommunityAssign(rs.getLong("asmInstance_id"), rs.getLong("asmusercommunity_id"), rs.getInt("priorityorder"));
                map.put(rs.getLong("id"), assign);
            }
            return map;
        }
    };

    public UserCommunityDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap<Long, List<UserCommunityAssign>> communityAssignMapTMP;
        HashMap<Long, List<UserCommunityAssign>> instanceAssignMapTMP;
        Map assignMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + UserCommunityDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            assignMapTMP = (Map)this.dataSource.executeQuery(getUserCommunityAssigns, params, userCommunityAssignMapper);
            instanceAssignMapTMP = new HashMap<Long, List<UserCommunityAssign>>();
            communityAssignMapTMP = new HashMap<Long, List<UserCommunityAssign>>();
            for (UserCommunityAssign assign : assignMapTMP.values()) {
                UserCommunityAssign a;
                Long asmInstanceId = assign.getAsmInstance_id();
                Long userCommunityId = assign.getAsmusercommunity_id();
                if (!instanceAssignMapTMP.containsKey(asmInstanceId)) {
                    instanceAssignMapTMP.put(asmInstanceId, new ArrayList());
                }
                ((List)instanceAssignMapTMP.get(asmInstanceId)).add(assign);
                if (!communityAssignMapTMP.containsKey(userCommunityId)) {
                    communityAssignMapTMP.put(userCommunityId, new ArrayList());
                }
                int idx = 0;
                List assigns = (List)communityAssignMapTMP.get(userCommunityId);
                Iterator iterator = assigns.iterator();
                while (iterator.hasNext() && (a = (UserCommunityAssign)iterator.next()).getPriorityorder() < assign.getPriorityorder()) {
                    ++idx;
                }
                assigns.add(idx, assign);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.assignMap = assignMapTMP;
                this.instanceAssignMap = instanceAssignMapTMP;
                this.communityAssignMap = communityAssignMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        boolean locked = false;
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(UserCommunityDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        UserCommunityAssign oldAssign = null;
        UserCommunityAssign newAssign = null;
        try {
            this.lock.acquireWriteLock();
            locked = true;
            try {
                oldAssign = this.assignMap.remove(id);
                if (oldAssign != null) {
                    Long instanceId = oldAssign.getAsmInstance_id();
                    Long communityId = oldAssign.getAsmusercommunity_id();
                    List<UserCommunityAssign> assigns = this.instanceAssignMap.get(instanceId);
                    assigns.remove(oldAssign);
                    if (assigns.isEmpty()) {
                        this.instanceAssignMap.remove(instanceId);
                    }
                    assigns = this.communityAssignMap.get(communityId);
                    assigns.remove(oldAssign);
                    if (assigns.isEmpty()) {
                        this.communityAssignMap.remove(communityId);
                    }
                } else if (operation != DAOReplicationEvent.OperationType.INSERT) {
                    this.log.warn((Object)("AssignList was null for " + (Object)((Object)operation) + "; we are probably out of sync"));
                }
                if (operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getUserCommunityAssign, params, userCommunityAssignMapper);
                    newAssign = (UserCommunityAssign)map.get(id);
                    if (newAssign == null) {
                        throw new DMException("Data does not exist for " + (Object)((Object)operation) + " event");
                    }
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("Retrieved new community assignment " + newAssign));
                    }
                    this.assignMap.put(id, newAssign);
                    Long instanceId = newAssign.getAsmInstance_id();
                    Long userCommunityId = newAssign.getAsmusercommunity_id();
                    if (!this.instanceAssignMap.containsKey(instanceId)) {
                        this.instanceAssignMap.put(instanceId, new ArrayList());
                    }
                    this.instanceAssignMap.get(instanceId).add(newAssign);
                    if (!this.communityAssignMap.containsKey(userCommunityId)) {
                        this.communityAssignMap.put(userCommunityId, new ArrayList());
                    }
                    this.communityAssignMap.get(userCommunityId).add(newAssign);
                    Collections.sort(this.communityAssignMap.get(userCommunityId), new UserCommunityAssign.PriorityComparator());
                }
            }
            catch (DMException e) {
                if (locked) {
                    this.lock.releaseWriteLock();
                    locked = false;
                }
                this.log.error((Object)("Error updating " + UserCommunityDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
                this.reinit();
                if (!this.okay()) {
                    this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                    if (locked) {
                        this.lock.releaseWriteLock();
                        locked = false;
                    }
                    return;
                }
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (oldAssign != null || newAssign != null) {
            this.updateListeners(oldAssign, newAssign);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(UserCommunityDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmusercommunityassign");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"instanceId"}, description="Get the IDs of User Communities that the given instance belongs to.")
    public List<Long> getUserCommunityIds(long instanceId) {
        ArrayList<Long> returnList = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            List<UserCommunityAssign> assigns = this.instanceAssignMap.get(instanceId);
            if (assigns != null) {
                for (UserCommunityAssign assign : assigns) {
                    returnList.add(assign.getAsmusercommunity_id());
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return returnList;
    }

    @SMConsole(description="Get the IDs of all User Communities containing this Session Manager")
    public List<Long> getMyUserCommunityIds() {
        Long instanceId = ((AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class)).getMyInstanceId();
        if (instanceId != null) {
            return this.getUserCommunityIds(instanceId);
        }
        return new ArrayList<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"userCommunityId"}, description="Get the IDs of Session Managers in the given User Community.")
    public List<Long> getUserCommAsmInstanceIds(Long userCommunityId) {
        ArrayList<Long> returnList = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            List<UserCommunityAssign> assigns = this.communityAssignMap.get(userCommunityId);
            if (assigns != null) {
                for (UserCommunityAssign assign : assigns) {
                    returnList.add(assign.getAsmInstance_id());
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"userCommunityId"}, description="Get the ASM instances of Session Managers in the given User Community.")
    public List<UserCommunityAssign> getUserCommAsmInstances(Long userCommunityId) {
        this.lock.acquireReadLock();
        try {
            List<UserCommunityAssign> assigns = this.communityAssignMap.get(userCommunityId);
            if (assigns != null) {
                List<UserCommunityAssign> list = assigns;
                return list;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return new ArrayList<UserCommunityAssign>();
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (!(oldObject instanceof AsmInstance) && !(newObject instanceof AsmInstance)) {
            this.log.warn((Object)("Received unexpected change alert for " + oldObject + " changing to " + newObject + "; re-initializing"));
            this.reinit();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.assignMap;
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

