/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.CallpCsHandleDAO;
import com.avaya.asm.datamgr.dao.CsHandleDAO;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.loadrulekeys.FilterSurvivabilityServer;
import com.avaya.asm.datamgr.loadrulekeys.HandleTypes;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={FilterSurvivabilityServer.class, HandleTypes.class})
public class BranchCallpCsHandleDAO
extends CallpCsHandleDAO {
    private final Logger log = AsmLogger.getLogger(BranchCallpCsHandleDAO.class);
    protected Set<String> enterpriseSipHandles = new HashSet<String>();
    protected static final String getAllEnterpriseSipHandles = "SELECT h.handle FROM cshandle h, cscommprofile cs, asmcommprofile asm WHERE h.cscommprofilesetid=cs.cscommprofilesetid AND asm.id=cs.id AND h.cshandletypeid=(SELECT id FROM cshandletypeenum WHERE name='sip') AND cs.commprofiletype='SIP' AND cs.cscommprofilesetid NOT IN (" + IsDeletedHandler.isDeletedCommProfileSetId + ")";
    protected static final String getSipHandlesBySetId = "SELECT cshandle.handle FROM cshandle JOIN cscommprofile ON cshandle.cscommprofilesetid=cscommprofile.cscommprofilesetid JOIN asmcommprofile ON asmcommprofile.id=cscommprofile.id WHERE cshandle.cshandletypeid=(SELECT id FROM cshandletypeenum WHERE name='sip') AND cscommprofile.commprofiletype='SIP'  AND cscommprofile.cscommprofilesetid=?";
    protected static final String getHandleByHandleId = "SELECT cshandle.handle, cshandle.id FROM cshandle JOIN cscommprofile ON cshandle.cscommprofilesetid=cscommprofile.cscommprofilesetid JOIN cscommprofileset ON cscommprofile.cscommprofilesetid=cscommprofileset.id JOIN csuser ON cscommprofileset.csuserid=csuser.id JOIN asmcommprofile ON asmcommprofile.id=cscommprofile.id WHERE cshandle.cshandletypeid=(SELECT id FROM cshandletypeenum WHERE name='sip') AND cscommprofile.commprofiletype='SIP' AND csuser.isdeleted=false AND cshandle.id=?";
    protected static final ResultSetMapper enterpriseSipHandleMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashSet<String> set = new HashSet<String>();
            while (rs.next()) {
                set.add(rs.getString("handle"));
            }
            return set;
        }
    };
    protected static final ResultSetMapper handleStringMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getString("handle");
            }
            return null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + BranchCallpCsHandleDAO.class.getSimpleName()));
        }
        super.init();
        Set enterpriseSipHandlesTMP = new HashSet();
        Object[] params = new Object[]{};
        try {
            enterpriseSipHandlesTMP = (Set)this.dataSource.executeQuery(getAllEnterpriseSipHandles, params, enterpriseSipHandleMapper);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName() + ": " + e));
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.enterpriseSipHandles = enterpriseSipHandlesTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        super.updateDAO(event);
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean locked = false;
        try {
            if ("csuser".equals(tableName)) {
                if (operation == DAOReplicationEvent.OperationType.UPDATE) {
                    Object[] params = new Object[]{id};
                    Map userMap = (Map)this.dataSource.executeQuery(this.getIdsByUserId, params, userMapper);
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "CsCommProfileSets for user now have deleted state: " + userMap));
                    }
                    HashSet addedHandles = new HashSet();
                    HashSet deletedHandles = new HashSet();
                    for (Map.Entry entry : userMap.entrySet()) {
                        params = this.getHandleParam(entry.getKey());
                        Set handleSet = (Set)this.dataSource.executeQuery(getSipHandlesBySetId, params, enterpriseSipHandleMapper);
                        if (handleSet == null) continue;
                        if (((Boolean)entry.getValue()).booleanValue()) {
                            deletedHandles.addAll(handleSet);
                            continue;
                        }
                        addedHandles.addAll(handleSet);
                    }
                    this.lock.acquireWriteLock();
                    locked = true;
                    this.enterpriseSipHandles.remove(deletedHandles);
                    this.enterpriseSipHandles.addAll(addedHandles);
                }
            } else if ("cshandle".equals(tableName)) {
                Object[] params;
                String newHandle = null;
                if ((operation == DAOReplicationEvent.OperationType.INSERT || operation == DAOReplicationEvent.OperationType.UPDATE) && (newHandle = (String)this.dataSource.executeQuery(getHandleByHandleId, params = this.getHandleParam(id), handleStringMapper)) != null) {
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)(this.logTag(operation, tableName, id) + "Retrieved new Handle " + newHandle));
                    }
                    this.lock.acquireWriteLock();
                    locked = true;
                    this.enterpriseSipHandles.add(newHandle);
                }
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + CsHandleDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsHandle getEnterpriseHandle(String handleString, long csDomainId) {
        CsHandle csHandle = this.getHandle(handleString, csDomainId);
        if (csHandle != null) {
            return csHandle;
        }
        CsHandle retVal = null;
        try {
            this.lock.acquireReadLock();
            for (CsHandle handle : this.flexCache) {
                if (handle.getCsDomainId() != csDomainId) continue;
                if (this.isForeignDomain(csDomainId)) {
                    if (!handle.getHandle().equalsIgnoreCase(handleString) || !this.handleMatches(handle, handleString)) continue;
                    retVal = handle;
                } else {
                    if (!handle.getHandle().equals(handleString)) continue;
                    retVal = handle;
                }
                break;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retVal != null) {
            try {
                this.lock.acquireWriteLock();
                this.flexCache.remove(retVal);
                this.flexCache.addFirst(retVal);
                this.pruneFlexCache();
            }
            finally {
                this.lock.releaseWriteLock();
            }
            return retVal;
        }
        if (!this.enterpriseSipHandles.contains(handleString)) {
            return null;
        }
        Object[] params = new Object[]{csDomainId, handleString};
        Map map = null;
        try {
            map = (Map)this.dataSource.executeQuery(this.getHandleByHandle, params, handleMapper);
        }
        catch (DMException e) {
            this.log.warn((Object)("Exception querying for handle with parameters " + handleString + " " + csDomainId));
        }
        if (map != null) {
            try {
                this.lock.acquireWriteLock();
                for (CsHandle handle : map.values()) {
                    if (!this.handleMatches(handle, handleString)) continue;
                    this.flexCache.remove(handle);
                    this.flexCache.addFirst(handle);
                    this.pruneFlexCache();
                    CsHandle csHandle2 = handle;
                    return csHandle2;
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            try {
                this.lock.acquireWriteLock();
                this.enterpriseSipHandles.remove(handleString);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return null;
    }

    @SMConsole(description="Get all enterprise Sip Handles on a BSM.")
    public Set<String> getAllEnterpriseSipHandles() {
        this.lock.acquireReadLock();
        try {
            Set<String> set = this.enterpriseSipHandles;
            return set;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get flexCache.")
    public LinkedList<CsHandle> getFlexCache() {
        this.lock.acquireReadLock();
        try {
            LinkedList linkedList = this.flexCache;
            return linkedList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

