/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.dao.cassandra.ContactUserDefinedType;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserTypeName;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UserType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public abstract class UserTypes<E extends Enum<E>> {
    private final Logger log = AsmLogger.getLogger(UserTypes.class);
    private final Class<E> enumType;
    protected final SessionDAO dao;
    protected Map<UserStoreKeyspace, EnumMap<E, UserType>> keyspaceMap = new HashMap<UserStoreKeyspace, EnumMap<E, UserType>>();

    public UserTypes(Class<E> enumType, SessionDAO dao) {
        this.enumType = enumType;
        this.dao = dao;
    }

    protected abstract UserType getUserDefinedType(E var1, UserStoreKeyspace var2);

    public synchronized UserType getUserType(E userType, UserStoreKeyspace keyspace) {
        String fcn_name = "getUserType";
        boolean isFinerEnabled = this.log.isFinerEnabled();
        boolean isFinestEnabled = this.log.isFinestEnabled();
        if (isFinerEnabled) {
            this.log.finer((Object)("getUserType: enter with userType = " + userType + ", userType name = " + ContactUserDefinedType.valueOf(((Enum)userType).toString()).getTypeName() + ", keyspace = " + keyspace));
        }
        if (userType == null || keyspace == null) {
            this.log.warn((Object)("getUserType : Parameters should not be null. UserType : " + userType + " ,KeySpace : " + keyspace));
            return null;
        }
        UserType udt = null;
        EnumMap<E, Object> udtMap = this.keyspaceMap.get(keyspace);
        if (udtMap == null) {
            udtMap = new EnumMap(this.enumType);
            this.keyspaceMap.put(keyspace, udtMap);
            if (isFinestEnabled) {
                this.log.finest((Object)("getUserType: had to create a new keyspaceMap entry for keyspace = " + keyspace));
            }
        } else if (isFinestEnabled) {
            this.log.finest((Object)("getUserType: found an existing keyspaceMap entry for keyspace = " + keyspace));
        }
        if ((udt = udtMap.get(userType)) == null) {
            Session session;
            if (isFinestEnabled) {
                this.log.finest((Object)("getUserType: have to go get the UDT from Cassandra for userType: " + userType + ", keyspace = " + keyspace));
            }
            if ((session = this.dao.getSession()) == null) {
                this.log.error((Object)"getUserType: found that the session was null, so return");
                return udt;
            }
            Cluster cluster = session.getCluster();
            if (cluster == null) {
                this.log.error((Object)"getUserType: found that the cluster was null, so return");
                return udt;
            }
            Metadata metadata = cluster.getMetadata();
            if (metadata == null) {
                this.log.error((Object)"getUserType: found that the metadata was null, so return");
                return udt;
            }
            KeyspaceMetadata ksMetadata = metadata.getKeyspace(keyspace.getName());
            if (ksMetadata == null) {
                this.log.error((Object)"getUserType: found that the keyspace metadata was null, so return");
                return udt;
            }
            udt = ksMetadata.getUserType(((UserTypeName)userType).getTypeName());
            if (udt == null) {
                this.log.error((Object)"getUserType: found that the udt was still null, so return");
                return udt;
            }
            udtMap.put(userType, (Object)udt);
            if (isFinestEnabled) {
                this.log.finest((Object)("getUserType: got the UDT from Cassandra for userType: " + userType + ", keyspace = " + keyspace));
            }
        }
        if (isFinerEnabled) {
            this.log.finer((Object)("getUserType: leave with userType = " + udt));
        }
        return udt;
    }
}

