/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.LocalUserDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.ContactRecord;
import com.avaya.asm.datamgr.objectapi.ContactRecords;
import com.avaya.asm.datamgr.objectapi.LocalUser;
import com.avaya.asm.datamgr.objectapi.ppm.CsPrivateContactInfo;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.List;

public class CsPrivContInfoDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(CsPrivContInfoDAO.class);

    public CsPrivContInfoDAO() {
        super(false);
    }

    protected LocalUserDAO getLocalUserDAO() {
        return (LocalUserDAO)this.getDataMgr(LocalUserDAO.class);
    }

    @Override
    public synchronized void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        this.getLocalUserDAO();
        this.setStatus(DataMgr.Status.OKAY);
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csprivatecontactinfo");
        return list;
    }

    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        Long id = tableEvent.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof LocalUser || newObject instanceof LocalUser) {
            if (newObject == null) {
                long userId = ((LocalUser)oldObject).getId();
                this.updateDAO(new DAOTableEvent("csuser", DAOReplicationEvent.OperationType.DELETE, userId));
            } else if (oldObject == null) {
                long userid = ((LocalUser)newObject).getId();
                this.updateDAO(new DAOTableEvent("csuser", DAOReplicationEvent.OperationType.INSERT, userid));
            }
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }

    public CsPrivateContactInfo getCsPrivateContactInfoByOwnerId(ContactRecords dbRecords, Long id) {
        CsPrivateContactInfo csPrivateContactInfo = null;
        boolean isFinest = this.log.isFinestEnabled();
        String fcn_name = "getCsPrivateContactInfo";
        if (isFinest) {
            this.log.finest((Object)("getCsPrivateContactInfo: id = " + id + " CR = " + dbRecords.toString()));
        }
        if (id == null) {
            return csPrivateContactInfo;
        }
        List<ContactRecord> contactRecordList = dbRecords.getContactRecordList();
        for (ContactRecord record : contactRecordList) {
            if (isFinest) {
                this.log.finest((Object)("getCsPrivateContactInfo: record = " + record.toString()));
            }
            if (id.equals(record.getCsprivatecontactinfoid()) && !id.equals(0L)) {
                if (isFinest) {
                    this.log.finest((Object)("getCsPrivateContactInfo: id = " + id + " record.getCsprivatecontactinfoid() = " + record.getCsprivatecontactinfoid()));
                }
                csPrivateContactInfo = this.createCsPrivateContactInfo(record);
                return csPrivateContactInfo;
            }
            if (!isFinest) continue;
            this.log.finest((Object)("getCsPrivateContactInfo: contactRecord does not have PCI - " + record));
        }
        return csPrivateContactInfo;
    }

    public List<CsPrivateContactInfo> getCsPrivateContactInfo(ContactRecords dbRecords) {
        ArrayList<CsPrivateContactInfo> csPrivateContactInfoList = null;
        String fcn_name = "getCsPrivateContactInfo";
        boolean isFinest = this.log.isFinestEnabled();
        if (dbRecords != null) {
            csPrivateContactInfoList = new ArrayList<CsPrivateContactInfo>();
            List<ContactRecord> contactRecordList = dbRecords.getContactRecordList();
            for (ContactRecord record : contactRecordList) {
                if (isFinest) {
                    this.log.finest((Object)("getCsPrivateContactInfo: record.getCsPrivContInfoId = " + record.getCsprivatecontactinfoid() + " record.hasPCI = " + record.isHasPCI()));
                }
                if (!record.isHasPCI()) continue;
                CsPrivateContactInfo csPrivateContactInfo = null;
                csPrivateContactInfo = this.createCsPrivateContactInfo(record);
                csPrivateContactInfoList.add(csPrivateContactInfo);
            }
        }
        return csPrivateContactInfoList;
    }

    @Override
    protected Object getMainCollection() {
        return null;
    }

    private CsPrivateContactInfo createCsPrivateContactInfo(ContactRecord record) {
        CsPrivateContactInfo csPrivateContactInfo = new CsPrivateContactInfo(record.getP_id(), record.getPrivate_displayname(), record.getPrivate_notes(), record.getPrivate_personid(), record.isCsUserId(), record.getOwnerid(), null);
        return csPrivateContactInfo;
    }

    @Override
    public int numChangesBeforeReinit() {
        return Integer.MAX_VALUE;
    }
}

