/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.AppParamsPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.AppParamsPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.NullUserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.asm.datamgr.dao.ustore.UpdatedContactsHistoryDAO;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.AppParams;
import com.avaya.ustore.objectapi.NetworkTopologyInfo;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UDTValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AppParamsDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(UpdatedContactsHistoryDAO.class);
    protected AppParamsPreparedStatements preparedStatements;
    protected final String UNASSIGNED_RF_COLNAME = "unassigned_rf";
    private UserStoreKeyspaceBuilder ksBuilder = new NullUserStoreKeyspaceBuilder(new UserStoreKeyspace("global_dc"));

    public AppParamsDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new AppParamsPreparedStatements(sessionDAO);
    }

    public AppParams getAppParamsByAppName(final String appName) throws DMException {
        String fcn_name = "getAppParamsByAppName";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAppParamsByAppName: enter, appName=" + appName));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(new AppParamsStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = AppParamsDAO.this.preparedStatements.getPreparedStatement(AppParamsPreparedStatementType.GET_ENTRY, AppParamsDAO.this.ksBuilder);
                return ps.bind(new Object[]{appName});
            }
        });
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)("getAppParamsByAppName: prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
        if (rs.isExhausted()) {
            if (isFiner) {
                this.log.finer((Object)("getAppParamsByAppName: leave, no record found for appName=" + appName));
            }
            return null;
        }
        AppParams appParams = this.createAppParams(rs.one());
        if (isFiner) {
            this.log.finer((Object)("getAppParamsByAppName: leave, appParams=" + appParams));
        }
        return appParams;
    }

    public List<String> getAllNames() throws DMException {
        String fcn_name = "getAllNames";
        ArrayList<String> names = new ArrayList<String>();
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)"getAllNames: enter");
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(new AppParamsStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = AppParamsDAO.this.preparedStatements.getPreparedStatement(AppParamsPreparedStatementType.GET_APP_NAMES, AppParamsDAO.this.ksBuilder);
                return ps.bind();
            }
        });
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)("getAllNames: prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
        for (Row row : rs) {
            names.add(row.getString(0));
        }
        if (isFiner) {
            this.log.finer((Object)("getAllNames: leave, names=" + names));
        }
        return names;
    }

    public Set<NetworkTopologyInfo> getAllNetworkTopologyByAppName(final String appName) throws DMException {
        String fcn_name = "getAllNetworkTopologyByAppName";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("getAllNetworkTopologyByAppName: enter, appName=" + appName));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(new AppParamsStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = AppParamsDAO.this.preparedStatements.getPreparedStatement(AppParamsPreparedStatementType.GET_NETWORK_TOPOLOGY_KS, AppParamsDAO.this.ksBuilder);
                return ps.bind(new Object[]{appName});
            }
        });
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)("getAllNetworkTopologyByAppName: prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
        if (rs.isExhausted()) {
            if (isFiner) {
                this.log.finer((Object)("getAllNetworkTopologyByAppName: leave, no record found for appName=" + appName));
            }
            return null;
        }
        Set<NetworkTopologyInfo> networktopology_ks = this.getRowNetworkTopologyInfo(rs.one(), "networktopology_ks");
        if (isFiner) {
            this.log.finer((Object)("getAllNetworkTopologyByAppName: leave, networktopology_ks=" + networktopology_ks));
        }
        return networktopology_ks;
    }

    private AppParams createAppParams(Row row) {
        String name = row.getString("name");
        Set<String> backup_ks = AppParamsDAO.getRowStringSet(row, "backup_ks");
        Set<String> ks_cfs = AppParamsDAO.getRowStringSet(row, "ks_cfs");
        Set<NetworkTopologyInfo> networktopology_ks = this.getRowNetworkTopologyInfo(row, "networktopology_ks");
        return new AppParams(name, ks_cfs, backup_ks, networktopology_ks);
    }

    private Set<NetworkTopologyInfo> getRowNetworkTopologyInfo(Row row, String column) {
        if (row.isNull(column)) {
            return null;
        }
        Set udtValueSet = row.getSet(column, UDTValue.class);
        HashSet<NetworkTopologyInfo> ntInfoSet = new HashSet<NetworkTopologyInfo>();
        for (UDTValue udtValue : udtValueSet) {
            int unassigned_rf = udtValue.isNull("unassigned_rf") ? 0 : udtValue.getInt("unassigned_rf");
            NetworkTopologyInfo ntInfo = new NetworkTopologyInfo(udtValue.getString("ks_name"), udtValue.getInt("rep_factor"), unassigned_rf);
            ntInfoSet.add(ntInfo);
        }
        return ntInfoSet;
    }

    private static Set<String> getRowStringSet(Row row, String column) {
        return row.isNull(column) ? null : row.getSet(column, String.class);
    }

    private abstract class AppParamsStatementBuilder
    implements UserStoreStatementBuilder {
        private AppParamsStatementBuilder() {
        }

        @Override
        public abstract Statement getStatement() throws DMException;

        @Override
        public void newSession() {
            AppParamsDAO.this.preparedStatements.clearMap();
        }
    }
}

