/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CassandraNodeData;
import com.avaya.asm.datamgr.dao.cassandra.CassandraSystemPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.CassandraSystemPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import java.util.Collection;
import java.util.UUID;

public class CassandraSystemDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(this.getClass());
    protected CassandraSystemPreparedStatements preparedStatements;
    private ClearMapKeyspaceBuilder keyspaceBuilder = new ClearMapKeyspaceBuilder();

    public CassandraSystemDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new CassandraSystemPreparedStatements(sessionDAO);
    }

    public void getAllColumnFamilies(Collection<ColumnFamilyMetaData> columnFamilies) throws DMException {
        String fcn_name = "getAllColumnFamilies";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter, columnFamilies.size=" + columnFamilies.size()));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(new CassandraSystemStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CassandraSystemDAO.this.preparedStatements.getPreparedStatement(CassandraSystemPreparedStatementType.GET_ALL_COLUMNFAMILIES, CassandraSystemDAO.this.keyspaceBuilder);
                return ps.bind();
            }
        }, this.keyspaceBuilder);
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)(fcn_name + ": prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
        for (Row row : rs) {
            String ksName = row.getString(0);
            String cfName = row.getString(1);
            UUID uuid = row.getUUID(2);
            ColumnFamilyMetaData cfmd = new ColumnFamilyMetaData(ksName, cfName);
            cfmd.setCfId(uuid);
            columnFamilies.add(cfmd);
            if (!isFinest) continue;
            this.log.finest((Object)(fcn_name + ": added cfmd=" + cfmd));
        }
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": leave, columnFamilies.size=" + columnFamilies.size()));
        }
    }

    public void getLocalCassandraNodeData(CassandraNodeData nodeData) throws DMException {
        Row row;
        String fcn_name = "getLocalCassandraNodeData";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter"));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(new CassandraSystemStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CassandraSystemDAO.this.preparedStatements.getPreparedStatement(CassandraSystemPreparedStatementType.GET_LOCAL_CASSANDRA_NODE_DATA, CassandraSystemDAO.this.keyspaceBuilder);
                return ps.bind();
            }
        }, this.keyspaceBuilder);
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)(fcn_name + ": prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
        if ((row = rs.one()) == null) {
            String msg = fcn_name + ": no data found from system.local";
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        nodeData.setAddress(row.getInet("listen_address"));
        nodeData.setHostId(row.getUUID("host_id"));
        nodeData.setDataCenter(row.getString("data_center"));
        nodeData.setReleaseVersion(row.getString("release_version"));
        nodeData.setSchemaVersion(row.getUUID("schema_version"));
        if (isFiner) {
            this.log.finer((Object)(fcn_name + "leave, nodeData=" + nodeData));
        }
    }

    public void getAllRemoteCassandraNodeData(Collection<CassandraNodeData> nodeDataRecs) throws DMException {
        String fcn_name = "getAllRemoteCassandraNodeData";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter"));
        }
        long startTimeMS = 0L;
        long prepTimeMS = 0L;
        long execTimeMS = 0L;
        if (isFinest) {
            startTimeMS = System.currentTimeMillis();
        }
        if (isFinest) {
            prepTimeMS = System.currentTimeMillis();
        }
        ResultSet rs = this.sessionDAO.executeStatement(new CassandraSystemStatementBuilder(){

            @Override
            public Statement getStatement() throws DMException {
                PreparedStatement ps = CassandraSystemDAO.this.preparedStatements.getPreparedStatement(CassandraSystemPreparedStatementType.GET_ALL_REMOTE_CASSANDRA_NODE_DATA, CassandraSystemDAO.this.keyspaceBuilder);
                return ps.bind();
            }
        }, this.keyspaceBuilder);
        if (isFinest) {
            execTimeMS = System.currentTimeMillis();
            this.log.finest((Object)(fcn_name + ": prepareTimeMS=" + (prepTimeMS - startTimeMS) + ", executeTimeMS=" + (execTimeMS - prepTimeMS)));
        }
        for (Row row : rs) {
            CassandraNodeData nodeData = new CassandraNodeData();
            nodeData.setAddress(row.getInet("peer"));
            nodeData.setHostId(row.getUUID("host_id"));
            nodeData.setDataCenter(row.getString("data_center"));
            nodeData.setReleaseVersion(row.getString("release_version"));
            nodeData.setSchemaVersion(row.getUUID("schema_version"));
            nodeDataRecs.add(nodeData);
        }
        if (isFiner) {
            this.log.finer((Object)(fcn_name + "leave, nodeDataRecs.size()=" + nodeDataRecs.size()));
        }
    }

    private abstract class CassandraSystemStatementBuilder
    implements UserStoreStatementBuilder {
        private CassandraSystemStatementBuilder() {
        }

        @Override
        public abstract Statement getStatement() throws DMException;

        @Override
        public void newSession() {
            CassandraSystemDAO.this.preparedStatements.clearMap();
        }
    }

    private class ClearMapKeyspaceBuilder
    extends UserStoreKeyspaceBuilder {
        public ClearMapKeyspaceBuilder() {
            super(new UserStoreKeyspace("system"));
        }

        @Override
        public boolean createColumnFamilies(SessionDAO dao) throws DMException {
            CassandraSystemDAO.this.preparedStatements.clearMap();
            return true;
        }
    }
}

