/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BatchStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.BoundStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.ContactKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.ContactPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.ContactPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.ContactUserDefinedType;
import com.avaya.asm.datamgr.dao.cassandra.ContactUserDefinedTypes;
import com.avaya.asm.datamgr.dao.cassandra.KeyspaceMetaData;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraUtils;
import com.avaya.ustore.objectapi.AddressData;
import com.avaya.ustore.objectapi.HandleData;
import com.avaya.ustore.objectapi.HandleDataKey;
import com.avaya.ustore.objectapi.SmgrContactRefKey;
import com.avaya.ustore.objectapi.SmgrContactRefRecord;
import com.avaya.ustore.objectapi.UstoreContactKey;
import com.avaya.ustore.objectapi.UstoreContactRecord;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ContactDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(ContactDAO.class);
    private static final String CASSANDRA_TIMEOUT_DURING_WRITE = "Cassandra timeout during write query at consistency SERIAL";
    private static final String NOT_ENOUGH_REPLICAS_AVAILABLE = "Not enough replicas available for query at consistency SERIAL";
    protected ContactPreparedStatements preparedStatements;
    protected ContactUserDefinedTypes userDefinedTypes;

    public ContactDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new ContactPreparedStatements(sessionDAO);
        this.userDefinedTypes = new ContactUserDefinedTypes(sessionDAO);
    }

    public void addContact(UstoreContactRecord uCRecord, List<SmgrContactRefRecord> addSCRRecordList, boolean ifConditionalAddFailsTryUpdate) throws DMException {
        String fcn_name = "addContact";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("addContact: enter with uCRecord:" + uCRecord + ", with addSCRRecordList: " + addSCRRecordList + ", and with ifConditionalAddFailsTryUpdate: " + ifConditionalAddFailsTryUpdate));
        }
        UserStoreKeyspaceBuilder builder = null;
        UUID commonUUID = null;
        Long savedOwnerCsUserId = null;
        SmgrContactRefKey.RecordType savedRecType = null;
        Long savedRecId = null;
        Long savedUpdateDateTime = null;
        try {
            if (addSCRRecordList != null && !addSCRRecordList.isEmpty()) {
                builder = this.getKeyspaceBuilder(addSCRRecordList.get(0).getKey().getKeyspace());
                ContactBatchStatementBuilder batchBuilder = new ContactBatchStatementBuilder(builder);
                for (SmgrContactRefRecord sCRR : addSCRRecordList) {
                    if (commonUUID == null) {
                        commonUUID = CassandraUtils.genTimeUUID();
                    }
                    sCRR.setContactId(commonUUID);
                    if (sCRR.getKey().getRecType().equals((Object)SmgrContactRefKey.RecordType.CONTACT_LIST_MEMBER)) {
                        if (isFinest) {
                            this.log.finest((Object)"addContact: Saving smgr_contact_ref cscontactlistmember record information for use later on. ");
                        }
                        savedOwnerCsUserId = sCRR.getKey().getOwnerCsuserId();
                        savedRecType = sCRR.getKey().getRecType();
                        savedRecId = sCRR.getKey().getRecId();
                        savedUpdateDateTime = sCRR.getUpdateDateTime();
                    }
                    batchBuilder.addToBatch(ContactPreparedStatementType.ADD_SMGR_CONTACT_REF_IF_NOT_EXISTS, sCRR.getKey().getOwnerCsuserId(), sCRR.getKey().getRecType().toAbbrevString(), sCRR.getKey().getRecId(), new Date(sCRR.getUpdateDateTime()), sCRR.getClmId(), sCRR.getContactId());
                }
                ResultSet rs = this.sessionDAO.executeStatement(batchBuilder, builder);
                if (!rs.wasApplied()) {
                    SmgrContactRefRecord sCRR1 = this.getSmgrContactRef(builder.getKeyspace(), savedOwnerCsUserId, savedRecType.toAbbrevString(), savedRecId);
                    UUID contactId = sCRR1.getContactId();
                    uCRecord.setKey(new UstoreContactKey(savedOwnerCsUserId, contactId, builder.getKeyspace()));
                    if (isFinest) {
                        this.log.finest((Object)("addContact: One or more smgr_contact_ref records to be added already exist in the DB from the addSCRRecordList: " + addSCRRecordList + ". The contactId retrieved from Cassandra is: " + contactId));
                    }
                    if (ifConditionalAddFailsTryUpdate) {
                        if (isFinest) {
                            this.log.finest((Object)"addContact: We're not continuing with the addContact operation, but we will try an updateContact operation.");
                        }
                        for (SmgrContactRefRecord sCRR2 : addSCRRecordList) {
                            sCRR2.setContactId(contactId);
                        }
                        uCRecord.setCreatedDateTime(savedUpdateDateTime);
                        uCRecord.setUpdateDateTime(savedUpdateDateTime);
                        this.updateContact(uCRecord, addSCRRecordList, null, ifConditionalAddFailsTryUpdate, true);
                    } else if (isFiner) {
                        this.log.finer((Object)"addContact: We're not continuing with the addContact operation, nor are we trying an updateContact operation.");
                    }
                    return;
                }
                if (isFinest) {
                    this.log.finest((Object)"addContact: The smgr_contact_ref records to be added didn't exist already, so they were added.");
                }
            }
        }
        catch (DMException dme) {
            String theException = dme.getNestedException().toString();
            if (theException.contains(NOT_ENOUGH_REPLICAS_AVAILABLE) || theException.contains(CASSANDRA_TIMEOUT_DURING_WRITE)) {
                if (isFinest) {
                    this.log.finest((Object)("addContact: We found the '" + (theException.contains(NOT_ENOUGH_REPLICAS_AVAILABLE) ? NOT_ENOUGH_REPLICAS_AVAILABLE : CASSANDRA_TIMEOUT_DURING_WRITE) + "' exception, so we'll try an updateContact operation without LWTs for all applications, i.e. DRS events, PPM, Audits, etc.."));
                }
            } else {
                StringBuilder msg = new StringBuilder("addContact");
                msg.append(": Here's the exception we found: ");
                msg.append(dme);
                msg.append(".  We won't try an updateContact operation.");
                this.log.error((Object)(msg.toString() + " Exception - " + dme), (Throwable)dme);
                throw dme;
            }
            uCRecord.setKey(new UstoreContactKey(savedOwnerCsUserId, commonUUID, builder.getKeyspace()));
            uCRecord.setCreatedDateTime(savedUpdateDateTime);
            uCRecord.setUpdateDateTime(savedUpdateDateTime);
            this.updateContact(uCRecord, addSCRRecordList, null, ifConditionalAddFailsTryUpdate, true);
            return;
        }
        if (uCRecord != null && uCRecord != null) {
            if (builder == null) {
                builder = this.getKeyspaceBuilder(uCRecord.getKey().getKeyspace());
            }
            uCRecord.getKey().setId(commonUUID != null ? commonUUID : CassandraUtils.genTimeUUID());
            if (isFinest) {
                this.log.finest((Object)("addContact: csuserId:" + uCRecord.getCsuserId() + ": cscontactId:" + uCRecord.getCscontactId() + ": cscontactlistmember:" + uCRecord.getCscontactlistmemberId() + ": csprivatecontactinfoId:" + uCRecord.getCsprivatecontactinfoId()));
            }
            AddContactBoundStatementBuilder sb = new AddContactBoundStatementBuilder(builder, uCRecord, savedUpdateDateTime != null ? new Date(savedUpdateDateTime) : new Date());
            this.sessionDAO.executeStatement(sb, builder);
        }
        if (isFiner) {
            this.log.finer((Object)"addContact: leave");
        }
    }

    public void updateContact(UstoreContactRecord uCRecord, List<SmgrContactRefRecord> addSCRRecordList, List<SmgrContactRefKey> deleteSCRKeyList, boolean unconditionalUpdate, boolean reallyDoingAnAdd) throws DMException {
        ContactBatchStatementBuilder batchBuilder;
        String fcn_name = "updateContact";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("updateContact: enter with uCRecord:" + uCRecord + ", addSCRRecordList: " + addSCRRecordList + ", deleteSCRKeyList: " + deleteSCRKeyList + ", unconditionalUpdate: " + unconditionalUpdate + ", reallyDoingAnAdd: " + reallyDoingAnAdd));
        }
        UserStoreKeyspaceBuilder builder = null;
        Long savedUpdateDateTime = null;
        if (addSCRRecordList != null && !addSCRRecordList.isEmpty()) {
            builder = this.getKeyspaceBuilder(addSCRRecordList.get(0).getKey().getKeyspace());
            batchBuilder = new ContactBatchStatementBuilder(builder);
            if (unconditionalUpdate) {
                for (SmgrContactRefRecord sCRR : addSCRRecordList) {
                    if (savedUpdateDateTime == null) {
                        if (isFinest) {
                            this.log.finest((Object)("updateContact: (unconditionalUpdate = true) Saving smgr_contact_ref entry updatedatetime information: " + sCRR.getUpdateDateTime()));
                        }
                        savedUpdateDateTime = sCRR.getUpdateDateTime();
                    }
                    batchBuilder.addToBatch(ContactPreparedStatementType.ADD_SMGR_CONTACT_REF, sCRR.getKey().getOwnerCsuserId(), sCRR.getKey().getRecType().toAbbrevString(), sCRR.getKey().getRecId(), new Date(sCRR.getUpdateDateTime()), sCRR.getClmId(), sCRR.getContactId());
                }
                this.sessionDAO.executeStatement(batchBuilder, builder);
                if (isFinest) {
                    this.log.finest((Object)"updateContact: The smgr_contact_ref record(s) were added/updated.");
                }
            } else {
                ContactBatchStatementBuilder updBatchBuilder = new ContactBatchStatementBuilder(builder);
                ContactBatchStatementBuilder updBatchBuilderWhenOneNodeDown = new ContactBatchStatementBuilder(builder);
                ContactBatchStatementBuilder addBatchBuilder = new ContactBatchStatementBuilder(builder);
                for (SmgrContactRefRecord sCRR : addSCRRecordList) {
                    SmgrContactRefRecord sCRR1;
                    if (savedUpdateDateTime == null) {
                        if (isFinest) {
                            this.log.finest((Object)("updateContact: (unconditionalUpdate = false) Saving smgr_contact_ref entry updatedatetime information: " + sCRR.getUpdateDateTime()));
                        }
                        savedUpdateDateTime = sCRR.getUpdateDateTime();
                    }
                    if ((sCRR1 = this.getSmgrContactRef(builder.getKeyspace(), sCRR.getKey().getOwnerCsuserId(), sCRR.getKey().getRecType().toAbbrevString(), sCRR.getKey().getRecId())) == null) {
                        addBatchBuilder.addToBatch(ContactPreparedStatementType.ADD_SMGR_CONTACT_REF, sCRR.getKey().getOwnerCsuserId(), sCRR.getKey().getRecType().toAbbrevString(), sCRR.getKey().getRecId(), new Date(sCRR.getUpdateDateTime()), sCRR.getClmId(), sCRR.getContactId());
                        continue;
                    }
                    updBatchBuilder.addToBatch(ContactPreparedStatementType.UPDATE_SMGR_CONTACT_REF_IF_NOT_EQUAL, sCRR.getClmId(), sCRR.getContactId(), new Date(sCRR.getUpdateDateTime()), sCRR.getKey().getOwnerCsuserId(), sCRR.getKey().getRecType().toAbbrevString(), sCRR.getKey().getRecId(), new Date(sCRR.getUpdateDateTime()));
                    updBatchBuilderWhenOneNodeDown.addToBatch(ContactPreparedStatementType.UPDATE_SMGR_CONTACT_REF, sCRR.getClmId(), sCRR.getContactId(), new Date(sCRR.getUpdateDateTime()), sCRR.getKey().getOwnerCsuserId(), sCRR.getKey().getRecType().toAbbrevString(), sCRR.getKey().getRecId());
                }
                try {
                    if (updBatchBuilder.numStatements() > 0) {
                        ResultSet rs = this.sessionDAO.executeStatement(updBatchBuilder, builder);
                        if (!rs.wasApplied()) {
                            if (isFiner) {
                                this.log.finer((Object)"updateContact: The smgr_contact_ref record(s) to be updated already exist in the DB with the correct updatedatetime , so we didn't update those record(s) and we're not continuing with the updateContact operation.");
                            }
                            return;
                        }
                        if (isFinest) {
                            this.log.finest((Object)"updateContact: The smgr_contact_ref record(s) from the addSCRRecordList were updated in the DB. ");
                        }
                    }
                }
                catch (DMException dme) {
                    String theException = dme.getNestedException().toString();
                    if (theException.contains(NOT_ENOUGH_REPLICAS_AVAILABLE) || theException.contains(CASSANDRA_TIMEOUT_DURING_WRITE)) {
                        if (isFinest) {
                            this.log.finest((Object)("updateContact: We found the '" + (theException.contains(NOT_ENOUGH_REPLICAS_AVAILABLE) ? NOT_ENOUGH_REPLICAS_AVAILABLE : CASSANDRA_TIMEOUT_DURING_WRITE) + "' exception, so we'll try the updateContact operation without the LWT this time."));
                        }
                        this.sessionDAO.executeStatement(updBatchBuilderWhenOneNodeDown, builder);
                    }
                    StringBuilder msg = new StringBuilder("updateContact");
                    msg.append(": Here's the exception we found: ");
                    msg.append(dme);
                    msg.append(".  We won't try the updateContact operation again.");
                    this.log.error((Object)(msg.toString() + " Exception - " + dme), (Throwable)dme);
                    throw dme;
                }
                if (addBatchBuilder.numStatements() > 0) {
                    this.sessionDAO.executeStatement(addBatchBuilder, builder);
                    if (isFinest) {
                        this.log.finest((Object)"updateContact: The smgr_contact_ref record(s) from the addSCRRecordList were added to the DB. ");
                    }
                }
            }
        }
        if (deleteSCRKeyList != null && !deleteSCRKeyList.isEmpty()) {
            if (builder == null) {
                builder = this.getKeyspaceBuilder(deleteSCRKeyList.get(0).getKeyspace());
            }
            batchBuilder = new ContactBatchStatementBuilder(builder);
            for (SmgrContactRefKey sCRK : deleteSCRKeyList) {
                batchBuilder.addToBatch(ContactPreparedStatementType.DELETE_SMGR_CONTACT_REF, sCRK.getOwnerCsuserId(), sCRK.getRecType().toAbbrevString(), sCRK.getRecId());
            }
            this.sessionDAO.executeStatement(batchBuilder, builder);
        }
        if (uCRecord != null) {
            if (builder == null) {
                builder = this.getKeyspaceBuilder(uCRecord.getKey().getKeyspace());
            }
            UpdateContactBoundStatementBuilder sb = new UpdateContactBoundStatementBuilder(builder, uCRecord, reallyDoingAnAdd);
            if (isFinest) {
                this.log.finest((Object)("updateContact: csuserId:" + uCRecord.getCsuserId() + ": cscontactId:" + uCRecord.getCscontactId() + ": cscontactlistmember:" + uCRecord.getCscontactlistmemberId() + ": csprivatecontactinfoId:" + uCRecord.getCsprivatecontactinfoId()));
            }
            this.sessionDAO.executeStatement(sb, builder);
        }
        if (isFiner) {
            this.log.finer((Object)"updateContact: leave");
        }
    }

    private void fillInTheUcrFields(BoundStatement bs, UstoreContactRecord uCRecord) {
        bs.setString("displaynamelocal", uCRecord.getDisplayNameLocal());
        bs.setString("firstnamelocal", uCRecord.getFirstNameLocal());
        bs.setString("lastnamelocal", uCRecord.getLastNameLocal());
        bs.setString("displaynameascii", uCRecord.getDisplayNameAscii());
        bs.setString("firstnameascii", uCRecord.getFirstNameAscii());
        bs.setString("lastnameascii", uCRecord.getLastNameAscii());
        bs.setString("preferredlanguage", uCRecord.getPreferredLanguage());
        bs.setString("alias", uCRecord.getAlias());
        bs.setString("notes", uCRecord.getNotes());
        bs.setBool("isbuddy", uCRecord.isBuddy());
        bs.setBool("videocapable", uCRecord.isVideoCapable());
        bs.setString("primarynumber", uCRecord.getPrimaryNumber());
        if (uCRecord.getCsuserId() == null) {
            bs.setToNull("csuserid");
        } else {
            bs.setLong("csuserid", uCRecord.getCsuserId().longValue());
        }
        if (uCRecord.getCscontactId() == null) {
            bs.setToNull("cscontactid");
        } else {
            bs.setLong("cscontactid", uCRecord.getCscontactId().longValue());
        }
        bs.setMap("endpointdata", uCRecord.getEndpointData());
        bs.setString("ppmaddress", uCRecord.getPpmAddress());
        bs.setLong("cscontactlistmemberid", uCRecord.getCscontactlistmemberId());
        if (uCRecord.getCsprivatecontactinfoId() == null) {
            bs.setToNull("csprivatecontactinfoid");
        } else {
            bs.setLong("csprivatecontactinfoid", uCRecord.getCsprivatecontactinfoId().longValue());
        }
        bs.setString("manager", uCRecord.getManager());
        bs.setString("pictureurl", uCRecord.getPictureUrl());
        bs.setBool("favourite", uCRecord.isFavourite());
        bs.setBool("instantconnection", uCRecord.isInstantConnection());
        bs.setMap("servicedata", uCRecord.getServiceData());
        bs.setMap("handles", this.createHandlesUDTMap(uCRecord.getHandleData(), uCRecord.getKey().getKeyspace()));
        bs.setMap("addresses", this.createAddressesUDTMap(uCRecord.getAddressData(), uCRecord.getKey().getKeyspace()));
    }

    public Map<UDTValue, UDTValue> createHandlesUDTMap(Map<HandleDataKey, HandleData> handleData, UserStoreKeyspace keyspace) {
        HashMap<UDTValue, UDTValue> handles = new HashMap<UDTValue, UDTValue>();
        UserType keyUserType = this.userDefinedTypes.getUserDefinedType(ContactUserDefinedType.HANDLE_DATA_KEY_TYPE, keyspace);
        UserType dataUserType = this.userDefinedTypes.getUserDefinedType(ContactUserDefinedType.HANDLE_DATA_TYPE, keyspace);
        if (handleData != null && keyUserType != null && dataUserType != null) {
            for (HandleDataKey handleDataKey : handleData.keySet()) {
                HandleData hData = handleData.get(handleDataKey);
                UDTValue handleDataKeyUDTValue = (UDTValue)((UDTValue)keyUserType.newValue().setString("handle", handleDataKey.getHandle())).setString("type", handleDataKey.getType());
                UDTValue handleDataUDTValue = dataUserType.newValue();
                if (hData.getCshandleId() == null) {
                    handleDataUDTValue.setToNull("cshandleid");
                } else {
                    handleDataUDTValue.setLong("cshandleid", hData.getCshandleId().longValue());
                }
                if (hData.getCscontactaddressId() == null) {
                    handleDataUDTValue.setToNull("cscontactaddressid");
                } else {
                    handleDataUDTValue.setLong("cscontactaddressid", hData.getCscontactaddressId().longValue());
                }
                ((UDTValue)((UDTValue)((UDTValue)((UDTValue)handleDataUDTValue.setString("category", hData.getCategory())).setString("label1", hData.getLabel1())).setString("label2", hData.getLabel2())).setBool("speeddialenabled", hData.isSpeedDialEnabled())).setMap("servicedata", hData.getServiceData());
                handles.put(handleDataKeyUDTValue, handleDataUDTValue);
            }
        }
        return handles;
    }

    public Map<String, UDTValue> createAddressesUDTMap(Map<String, AddressData> addressData, UserStoreKeyspace keyspace) {
        HashMap<String, UDTValue> addresses = new HashMap<String, UDTValue>();
        UserType addrDataUserType = this.userDefinedTypes.getUserDefinedType(ContactUserDefinedType.ADDRESS_DATA_TYPE, keyspace);
        if (addressData != null && addrDataUserType != null) {
            for (String addrDataKey : addressData.keySet()) {
                AddressData addrData = addressData.get(addrDataKey);
                UDTValue addressDataUDTValue = addrDataUserType.newValue();
                if (addrData.getCsaddressId() == null) {
                    addressDataUDTValue.setToNull("csaddressid");
                } else {
                    addressDataUDTValue.setLong("csaddressid", addrData.getCsaddressId().longValue());
                }
                ((UDTValue)((UDTValue)((UDTValue)((UDTValue)((UDTValue)((UDTValue)((UDTValue)((UDTValue)((UDTValue)addressDataUDTValue.setString("streetaddress", addrData.getStreetAddress())).setString("company", addrData.getCompany())).setString("location", addrData.getLocation())).setString("city", addrData.getCity())).setString("state", addrData.getState())).setString("country", addrData.getCountry())).setString("postalcode", addrData.getPostalCode())).setString("department", addrData.getDepartment())).setString("workroomno", addrData.getWorkRoomNo())).setMap("servicedata", addrData.getServiceData());
                addresses.put(addrDataKey, addressDataUDTValue);
            }
        }
        return addresses;
    }

    public void deleteContacts(UserStoreKeyspace keyspace, long ownerCsuserId, List<UUID> contactIdsToDelete) throws DMException {
        String fcn_name = "deleteContacts";
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactBatchStatementBuilder batchBuilder = new ContactBatchStatementBuilder(builder);
        for (UUID contactId : contactIdsToDelete) {
            batchBuilder.addToBatch(ContactPreparedStatementType.DELETE_CONTACT, ownerCsuserId, contactId);
            ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_SMGR_CONTACT_REFS_BY_CONTACT_ID, builder, ownerCsuserId, contactId);
            ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
            for (Row row : rs) {
                batchBuilder.addToBatch(ContactPreparedStatementType.DELETE_SMGR_CONTACT_REF, row.getLong("ownercsuserid"), row.getString("rectype"), row.getLong("recid"));
            }
        }
        this.sessionDAO.executeStatement(batchBuilder, builder);
    }

    public void deleteAllContacts(UserStoreKeyspace keyspace, long ownerCsuserId) throws DMException {
        String fcn_name = "deleteAllContacts";
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactBatchStatementBuilder batchBuilder = new ContactBatchStatementBuilder(builder);
        batchBuilder.addToBatch(ContactPreparedStatementType.DELETE_ALL_CONTACTS, ownerCsuserId);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_SMGR_CONTACT_REFS_BY_OWNER_ID, builder, ownerCsuserId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            batchBuilder.addToBatch(ContactPreparedStatementType.DELETE_SMGR_CONTACT_REF, row.getLong("ownercsuserid"), row.getString("rectype"), row.getLong("recid"));
        }
        this.sessionDAO.executeStatement(batchBuilder, builder);
    }

    public UstoreContactRecord getContact(UserStoreKeyspace keyspace, long ownerCsuserId, UUID contactId) throws DMException {
        String fcn_name = "getContact";
        boolean isFiner = this.log.isFinerEnabled();
        UstoreContactRecord contact = null;
        ResultSet rs = null;
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_CONTACT, builder, ownerCsuserId, contactId);
        rs = this.sessionDAO.executeStatement(stBuilder, builder);
        boolean rowFound = false;
        for (Row row : rs) {
            if (rowFound) {
                throw new DMException("getContact: multiple contact CF rows were returned from the DB.");
            }
            contact = this.createUstoreContactRecord(row, keyspace);
            rowFound = true;
        }
        if (isFiner) {
            this.log.finer((Object)("getContact: contact retrieved from the DB: " + contact));
        }
        return contact;
    }

    public List<UstoreContactRecord> getAllContacts(UserStoreKeyspace keyspace, long ownerCsuserId) throws DMException {
        String fcn_name = "getAllContacts";
        boolean isFinest = this.log.isFinestEnabled();
        ArrayList<UstoreContactRecord> contacts = new ArrayList<UstoreContactRecord>();
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_ALL_CONTACTS, builder, ownerCsuserId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            UstoreContactRecord uCR = this.createUstoreContactRecord(row, keyspace);
            contacts.add(uCR);
            if (!isFinest) continue;
            this.log.finest((Object)("getAllContacts: contact retrieved from the DB: " + uCR.toString()));
        }
        return contacts;
    }

    private UstoreContactRecord createUstoreContactRecord(Row row, UserStoreKeyspace keyspace) throws DMException {
        String fcn_name = "createUstoreContactRecord";
        boolean isFiner = this.log.isFinerEnabled();
        Date createdDateTime = row.getTimestamp("createddatetime");
        long cdTimestamp = createdDateTime != null ? createdDateTime.getTime() : 0L;
        Date updateDateTime = row.getTimestamp("updatedatetime");
        long udTimestamp = updateDateTime != null ? updateDateTime.getTime() : 0L;
        UstoreContactKey uCKey = new UstoreContactKey(row.getLong("ownercsuserid"), row.getUUID("id"), keyspace);
        HashMap<HandleDataKey, HandleData> handleData = new HashMap<HandleDataKey, HandleData>();
        Map handlesUDT = row.getMap("handles", UDTValue.class, UDTValue.class);
        if (isFiner) {
            this.log.finer((Object)("createUstoreContactRecord: handlesUDT keys: " + handlesUDT.keySet().toString()));
            this.log.finer((Object)("createUstoreContactRecord: handlesUDT values: " + handlesUDT.values().toString()));
        }
        for (UDTValue handleDataKeyUDT : handlesUDT.keySet()) {
            HandleDataKey hDataKey = new HandleDataKey(handleDataKeyUDT.getString("handle"), handleDataKeyUDT.getString("type"));
            UDTValue handleDataValue = (UDTValue)handlesUDT.get(handleDataKeyUDT);
            HandleData hData = new HandleData(handleDataValue.isNull("cshandleid") ? null : Long.valueOf(handleDataValue.getLong("cshandleid")), handleDataValue.isNull("cscontactaddressid") ? null : Long.valueOf(handleDataValue.getLong("cscontactaddressid")), handleDataValue.getString("category"), handleDataValue.getString("label1"), handleDataValue.getString("label2"), handleDataValue.getBool("speeddialenabled"), handleDataValue.getMap("servicedata", String.class, String.class));
            handleData.put(hDataKey, hData);
            if (!isFiner) continue;
            this.log.finer((Object)("createUstoreContactRecord: handleData: " + handleData.toString()));
        }
        HashMap<String, AddressData> addressData = new HashMap<String, AddressData>();
        Map addressDataUDT = row.getMap("addresses", String.class, UDTValue.class);
        if (isFiner) {
            this.log.finer((Object)("createUstoreContactRecord: addressDataUDT: " + addressDataUDT.toString()));
        }
        for (String addrDataKey : addressDataUDT.keySet()) {
            UDTValue addrDataValue = (UDTValue)addressDataUDT.get(addrDataKey);
            AddressData addrData = new AddressData(addrDataValue.isNull("csaddressid") ? null : Long.valueOf(row.getLong("csaddressid")), addrDataValue.getString("streetaddress"), addrDataValue.getString("company"), addrDataValue.getString("location"), addrDataValue.getString("city"), addrDataValue.getString("state"), addrDataValue.getString("country"), addrDataValue.getString("postalcode"), addrDataValue.getString("department"), addrDataValue.getString("workroomno"), addrDataValue.getMap("servicedata", String.class, String.class));
            addressData.put(addrDataKey, addrData);
            if (!isFiner) continue;
            this.log.finer((Object)("createUstoreContactRecord: addressData: " + addressData.toString()));
        }
        UstoreContactRecord contact = new UstoreContactRecord(uCKey, row.getString("type"), cdTimestamp, udTimestamp, row.getString("displaynamelocal"), row.getString("firstnamelocal"), row.getString("lastnamelocal"), row.getString("displaynameascii"), row.getString("firstnameascii"), row.getString("lastnameascii"), row.getString("preferredlanguage"), row.getString("alias"), row.getString("notes"), row.getBool("isbuddy"), row.getBool("videocapable"), row.getString("primarynumber"), row.isNull("csuserid") ? null : Long.valueOf(row.getLong("csuserid")), row.isNull("cscontactid") ? null : Long.valueOf(row.getLong("cscontactid")), new HashMap<String, String>(row.getMap("endpointdata", String.class, String.class)), row.getString("ppmaddress"), row.isNull("cscontactlistmemberid") ? this.invalidTableIdFound("createUstoreContactRecord", "cscontactlistmemberid", 0L).longValue() : row.getLong("cscontactlistmemberid"), row.isNull("csprivatecontactinfoid") ? null : Long.valueOf(row.getLong("csprivatecontactinfoid")), row.getString("manager"), row.getString("pictureurl"), row.getBool("favourite"), row.getBool("instantconnection"), new HashMap<String, String>(row.getMap("servicedata", String.class, String.class)), handleData, addressData);
        if (isFiner) {
            this.log.finer((Object)"createUstoreContactRecord: leave");
        }
        return contact;
    }

    public SmgrContactRefRecord getSmgrContactRef(UserStoreKeyspace keyspace, long ownerCsuserId, String recType, long recId) throws DMException {
        String fcn_name = "getSmgrContactRef";
        SmgrContactRefRecord sCRR = new SmgrContactRefRecord();
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_SMGR_CONTACT_REFS, builder, ownerCsuserId, recType, recId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
        boolean rowFound = false;
        for (Row row : rs) {
            if (rowFound) {
                throw new DMException("getSmgrContactRef: multiple smgr_contact_ref CF rows were returned from the DB.");
            }
            sCRR = this.createSmgrContactRefRecord(row, keyspace);
            rowFound = true;
        }
        return sCRR;
    }

    public List<SmgrContactRefRecord> getSmgrContactRefsByRecType(UserStoreKeyspace keyspace, long ownerCsuserId, String recType) throws DMException {
        String fcn_name = "getSmgrContactRefsByRecType";
        boolean isFiner = this.log.isFinerEnabled();
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_SMGR_CONTACT_REFS_BY_RECTYPE, builder, ownerCsuserId, recType);
        ArrayList<SmgrContactRefRecord> sCRRList = new ArrayList<SmgrContactRefRecord>();
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            SmgrContactRefRecord sCRR = this.createSmgrContactRefRecord(row, keyspace);
            sCRRList.add(sCRR);
        }
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByRecType: leave: SmgrContactRef records found via rectype: " + sCRRList));
        }
        return sCRRList;
    }

    public List<SmgrContactRefRecord> getSmgrContactRefsByContactId(UserStoreKeyspace keyspace, long ownerCsuserId, UUID contactId) throws DMException {
        String fcn_name = "getSmgrContactRefsByContactId";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByContactId: enter with keyspace: " + keyspace + ", ownerCsuserId: " + ownerCsuserId + ", contactId: " + contactId));
        }
        ArrayList<SmgrContactRefRecord> sCRRList = new ArrayList<SmgrContactRefRecord>();
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_SMGR_CONTACT_REFS_BY_CONTACT_ID, builder, ownerCsuserId, contactId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            SmgrContactRefRecord sCRR = this.createSmgrContactRefRecord(row, keyspace);
            sCRRList.add(sCRR);
        }
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByContactId: leave: SmgrContactRef records found via contactId: " + sCRRList));
        }
        return sCRRList;
    }

    public List<SmgrContactRefRecord> getSmgrContactRefsByOwnerId(UserStoreKeyspace keyspace, long ownerCsuserId) throws DMException {
        String fcn_name = "getSmgrContactRefsByOwnerId";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByOwnerId: enter with keyspace: " + keyspace + ", ownerCsuserId: " + ownerCsuserId));
        }
        ArrayList<SmgrContactRefRecord> sCRRList = new ArrayList<SmgrContactRefRecord>();
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_SMGR_CONTACT_REFS_BY_OWNER_ID, builder, ownerCsuserId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            SmgrContactRefRecord sCRR = this.createSmgrContactRefRecord(row, keyspace);
            sCRRList.add(sCRR);
        }
        if (isFiner) {
            this.log.finer((Object)("getSmgrContactRefsByOwnerId: leave: SmgrContactRef records found via ownerId: " + sCRRList));
        }
        return sCRRList;
    }

    public void getOwnerCsUserIdsByKeyspace(UserStoreKeyspace keyspace, Collection<Long> ids) throws DMException {
        String fcn_name = "getOwnerCsUserIdsByKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getOwnerCsUserIdsByKeyspace: enter, keyspace=" + keyspace + ", ids.size=" + ids.size()));
        }
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_OWNERCSUSERIDS, builder, new Object[0]);
        long startTime = System.currentTimeMillis();
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder);
        for (Row row : rs) {
            if (row.isNull(0)) {
                this.log.warn((Object)"getOwnerCsUserIdsByKeyspace: retrieved a null ownercsuserid");
                continue;
            }
            long ownerCsUserId = row.getLong(0);
            ids.add(ownerCsUserId);
        }
        long endTime = System.currentTimeMillis();
        if (isFiner) {
            this.log.finer((Object)("getOwnerCsUserIdsByKeyspace: leave, ids.size=" + ids.size() + ", totalTimeMS=" + (endTime - startTime)));
        }
    }

    private SmgrContactRefRecord createSmgrContactRefRecord(Row row, UserStoreKeyspace keyspace) {
        String fcn_name = "createSmgrContactRefRecord";
        Date updateDateTime = row.getTimestamp("updatedatetime");
        long udTimestamp = updateDateTime != null ? updateDateTime.getTime() : 0L;
        SmgrContactRefKey sCRKey = new SmgrContactRefKey(row.isNull("ownercsuserid") ? this.invalidTableIdFound("createSmgrContactRefRecord", "ownercsuserid", 0L).longValue() : row.getLong("ownercsuserid"), SmgrContactRefKey.RecordType.fromAbrevString(row.getString("rectype")), row.getLong("recid"), keyspace);
        SmgrContactRefRecord smgrContactRef = new SmgrContactRefRecord(sCRKey, udTimestamp, row.isNull("clmid") ? this.invalidTableIdFound("createSmgrContactRefRecord", "clmid", 0L).longValue() : row.getLong("clmid"), row.getUUID("contactid"));
        return smgrContactRef;
    }

    protected UserStoreKeyspaceBuilder getKeyspaceBuilder(UserStoreKeyspace keyspace) {
        return new ContactKeyspaceBuilder(keyspace);
    }

    public List<KeyspaceMetaData> getKeyspaces() throws DMException {
        String fcn_name = "getKeyspaces";
        boolean isFiner = this.log.isFinerEnabled();
        ArrayList<KeyspaceMetaData> keyspaceList = new ArrayList<KeyspaceMetaData>();
        boolean rc = this.sessionDAO.getKeyspaces(keyspaceList);
        if (!rc) {
            String msg = "getKeyspaces: getKeyspaces() failed";
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        if (isFiner) {
            this.log.finer((Object)("getKeyspaces: keyspaces returned from SessionDAO: " + keyspaceList));
        }
        return keyspaceList;
    }

    public boolean doesTableExist(String keyspaceName, String tableName) throws DMException {
        String fcn_name = "doesTableExist";
        boolean isFiner = this.log.isFinerEnabled();
        boolean tableExists = false;
        tableExists = this.sessionDAO.doesTableExist(keyspaceName, tableName);
        if (isFiner) {
            this.log.finer((Object)("doesTableExist: contact table exists: " + tableExists));
        }
        return tableExists;
    }

    public void createKeyspaceAndCFs(UserStoreKeyspace keyspace, boolean ksexist) throws DMException {
        String fcn_name = "createKeyspaceAndCFs";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinerEnabled();
        String ksName = keyspace.getName();
        UserStoreKeyspaceBuilder ksbuilder = this.getKeyspaceBuilder(keyspace);
        if (!ksexist) {
            ksbuilder.createKeyspace(this.sessionDAO);
            if (isFinest) {
                this.log.finest((Object)("createKeyspaceAndCFs: created keyspace: " + keyspace));
            }
        }
        ksbuilder.createColumnFamilies(this.sessionDAO);
        if (isFiner) {
            this.log.finer((Object)("createKeyspaceAndCFs contact CFs are created for keyspace : " + ksName + ", keyspace exists: " + ksexist));
        }
    }

    public Long invalidTableIdFound(String callingMethodName, String typeOfDbId, Long valueToReturn) {
        this.log.warn((Object)(callingMethodName + ": " + typeOfDbId + " was null and shouldn't be, returning " + valueToReturn));
        return valueToReturn;
    }

    public Integer getContactsCount(UserStoreKeyspace keyspace, long csuserId) throws DMException {
        String fcn_name = "getContactsCount";
        boolean isFinest = this.log.isFinestEnabled();
        Integer count = null;
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        ContactPreparedStatementBuilder stBuilder = new ContactPreparedStatementBuilder(ContactPreparedStatementType.GET_CONTACTS_COUNT, builder, csuserId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder, builder);
        if (!rs.isExhausted()) {
            count = (int)rs.one().getLong("count");
        }
        if (isFinest) {
            this.log.finest((Object)("getContactsCount: contactCount retrieved from the DB: " + count));
        }
        return count;
    }

    private class UpdateContactBoundStatementBuilder
    extends BoundStatementBuilder<ContactPreparedStatementType> {
        private UstoreContactRecord uCRecord;

        public UpdateContactBoundStatementBuilder(UserStoreKeyspaceBuilder builder, UstoreContactRecord uCRecord, boolean addFlag) {
            super(ContactDAO.this.preparedStatements, addFlag ? ContactPreparedStatementType.ADD_CONTACT : ContactPreparedStatementType.UPDATE_CONTACT, builder);
            this.uCRecord = uCRecord;
        }

        @Override
        public void bindStatement(BoundStatement bs) {
            Date dateTime;
            bs.setLong("ownercsuserid", this.uCRecord.getKey().getOwnerCsuserId());
            bs.setUUID("id", this.uCRecord.getKey().getId());
            bs.setString("type", this.uCRecord.getType());
            Date date = dateTime = ((ContactPreparedStatementType)this.psType).equals((Object)ContactPreparedStatementType.ADD_CONTACT) ? new Date(this.uCRecord.getCreatedDateTime()) : new Date();
            if (((ContactPreparedStatementType)this.psType).equals((Object)ContactPreparedStatementType.ADD_CONTACT)) {
                bs.setTimestamp("createddatetime", dateTime);
            }
            bs.setTimestamp("updatedatetime", dateTime);
            ContactDAO.this.fillInTheUcrFields(bs, this.uCRecord);
        }
    }

    private class AddContactBoundStatementBuilder
    extends BoundStatementBuilder<ContactPreparedStatementType> {
        private UstoreContactRecord uCRecord;
        private Date updateTime;

        public AddContactBoundStatementBuilder(UserStoreKeyspaceBuilder builder, UstoreContactRecord uCRecord, Date updateTime) {
            super(ContactDAO.this.preparedStatements, ContactPreparedStatementType.ADD_CONTACT, builder);
            this.uCRecord = uCRecord;
            this.updateTime = updateTime;
        }

        @Override
        public void bindStatement(BoundStatement bs) {
            bs.setLong("ownercsuserid", this.uCRecord.getKey().getOwnerCsuserId());
            bs.setUUID("id", this.uCRecord.getKey().getId());
            bs.setString("type", this.uCRecord.getType());
            bs.setTimestamp("createddatetime", this.updateTime);
            bs.setTimestamp("updatedatetime", this.updateTime);
            ContactDAO.this.fillInTheUcrFields(bs, this.uCRecord);
        }
    }

    private class ContactBatchStatementBuilder
    extends BatchStatementBuilder<ContactPreparedStatementType> {
        public ContactBatchStatementBuilder(UserStoreKeyspaceBuilder builder) {
            super(ContactDAO.this.preparedStatements, builder);
        }
    }

    private class ContactPreparedStatementBuilder
    extends PreparedStatementBuilder<ContactPreparedStatementType> {
        public ContactPreparedStatementBuilder(ContactPreparedStatementType type, UserStoreKeyspaceBuilder builder, Object ... args) {
            super(ContactDAO.this.preparedStatements, type, builder, args);
        }
    }
}

