/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.datadistributionlayer.DDLException;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerData;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerDataKey;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.datadistributionlayer.GroupCommIntf;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DDLMessageSender {
    protected static DDLInterClusterMember interMember = null;
    protected static DDLIntraClusterMember intraMember = null;
    private static Logger log = AsmLogger.getLogger(DDLMessageSender.class);

    protected static void sendMessage(DataDistLayerMemberAddr member, DataDistLayerMessage message, boolean canSendToInter) throws DDLException {
        message.setHost(member);
        String clusterName = member.getClusterName();
        if (DDLMessageSender.intraMember.myClusterName.equals(clusterName)) {
            if (DDLMessageSender.intraMember.myClusterGroup != null) {
                DDLMessageSender.intraMember.myClusterGroup.sendMessage(member.getHostId(), message);
            }
        } else if (canSendToInter) {
            if (DDLMessageSender.interMember.myClusterName.equals(clusterName)) {
                if (DDLMessageSender.interMember.myClusterGroup != null && !DDLMessageSender.sendInterClusterMessage(member, message)) {
                    log.error((Object)("Failed sending " + message + " to " + member + " due to interoperation conversion problems."));
                }
            } else {
                for (DataDistLayerMemberAddr address : interMember.getMembers()) {
                    String curClusterName = address.getIpAddress();
                    if (!IPAddress.areEqual(curClusterName, clusterName)) continue;
                    if (DDLMessageSender.interMember.myClusterGroup != null && !DDLMessageSender.sendInterClusterMessage(address, message)) {
                        log.error((Object)("Failed sending " + message + " to " + member + " due to interoperation conversion problems."));
                    }
                    return;
                }
                if (log.isFinerEnabled()) {
                    log.error((Object)("Failed to send " + message + " to leader for " + member));
                }
            }
        } else if (DDLMessageSender.intraMember.myClusterLeaderId != null && DDLMessageSender.intraMember.myClusterGroup != null) {
            DDLMessageSender.intraMember.myClusterGroup.sendMessage(DDLMessageSender.intraMember.myClusterLeaderId, message);
        } else {
            intraMember.saveIntraMessage(message);
        }
    }

    protected static Long getAsmCommProfileId(String commProfileSetId) {
        try {
            return DDLUtilities.getAsmCommProfileId(Long.parseLong(commProfileSetId));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected static boolean sendInterClusterMessage(DataDistLayerMemberAddr target, DataDistLayerMessage message) {
        if (DataDistLayerMessage.TargetAppId.INTERNAL != message.getAppId()) {
            DDLMessageSender.interMember.myClusterGroup.sendMessage(target.getHostId(), message);
            return true;
        }
        switch (message.getMessageType()) {
            case 7: 
            case 12: 
            case 13: {
                if (DDLUtilities.supportsCommProfileSetIdBasedDDL(target)) break;
                ArrayList<DataDistLayerData> list = null;
                ArrayList<DataDistLayerData> sendList = new ArrayList<DataDistLayerData>();
                if (message.getPayload() instanceof List) {
                    list = (ArrayList<DataDistLayerData>)message.getPayload();
                } else if (message.getPayload() instanceof DataDistLayerData) {
                    list = new ArrayList<DataDistLayerData>();
                    list.add((DataDistLayerData)message.getPayload());
                }
                if (list == null) break;
                for (DataDistLayerData data : list) {
                    DataDistLayerDataKey key = data.getKey();
                    if (key.getKeyCategory() == DataDistLayerDataKey.Category.URE_CONTACTS || key.getKeyCategory() == DataDistLayerDataKey.Category.URE_SUBSCRIPTIONS) {
                        Long asmId = DDLMessageSender.getAsmCommProfileId(key.getKeyValue());
                        if (asmId == null) {
                            log.error((Object)("Sending DDL Data to older SM that used AsmCommProfile ID as key, but couldn't convert to CommProfileSet ID. Discarding data: " + data));
                            continue;
                        }
                        if (log.isFinestEnabled()) {
                            log.finest((Object)("Converting " + (Object)((Object)key.getKeyCategory()) + " key from " + key.getKeyValue() + " to " + asmId + " before sending to SM with version " + target.getMemberVersion()));
                        }
                        data = new DataDistLayerData(data);
                        data.getKey().setKeyValue(Long.toString(asmId));
                        if (data.getKey().getKeyCategory() == DataDistLayerDataKey.Category.URE_SUBSCRIPTIONS) {
                            data.setData(asmId);
                        }
                    }
                    sendList.add(data);
                }
                if (sendList.isEmpty()) {
                    return false;
                }
                if (sendList.size() == 1) {
                    message.setPayload((Serializable)sendList.get(0));
                    break;
                }
                message.setPayload(sendList);
                break;
            }
        }
        DDLMessageSender.interMember.myClusterGroup.sendMessage(target.getHostId(), message);
        return true;
    }

    protected static Object queryHost(DataDistLayerMemberAddr member, DataDistLayerMessage message, int timeout, boolean canSendToInter) {
        message.setHost(member);
        String clusterName = member.getClusterName();
        if (DDLMessageSender.intraMember.myClusterName.equals(clusterName)) {
            if (DDLMessageSender.intraMember.myClusterGroup == null) {
                return null;
            }
            return DDLMessageSender.intraMember.myClusterGroup.queryTheHost(member.getHostId(), message, timeout);
        }
        if (canSendToInter) {
            if (DDLMessageSender.interMember.myClusterName.equals(clusterName)) {
                if (DDLMessageSender.interMember.myClusterGroup == null) {
                    return null;
                }
                return DDLMessageSender.interMember.myClusterGroup.queryTheHost(member.getHostId(), message, timeout);
            }
            for (DataDistLayerMemberAddr address : interMember.getMembers()) {
                String curClusterName = address.getIpAddress();
                if (!IPAddress.areEqual(curClusterName, clusterName)) continue;
                if (DDLMessageSender.interMember.myClusterGroup == null) {
                    return null;
                }
                Object retValue = DDLMessageSender.interMember.myClusterGroup.queryTheHost(address.getHostId(), message, timeout);
                return retValue;
            }
            if (log.isFinerEnabled()) {
                log.finer((Object)("Failed to send query " + message + " to leader for " + member));
            }
            return null;
        }
        if (DDLMessageSender.intraMember.myClusterGroup == null) {
            return null;
        }
        Object retValue = DDLMessageSender.intraMember.myClusterGroup.queryTheHost(DDLMessageSender.intraMember.myClusterLeaderId, message, timeout);
        return retValue;
    }

    protected static Object queryOtherMember(GroupCommIntf.DDLGroupType type, DataDistLayerMessage message) {
        if (type == GroupCommIntf.DDLGroupType.INTER_SM_CLUSTER) {
            if (log.isFinestEnabled()) {
                log.finest((Object)"queryOtherMember: Querying the intra member leader.");
            }
            return intraMember.handleQuery(message, interMember.getMyId());
        }
        if (interMember != null) {
            if (log.isFinestEnabled()) {
                log.finest((Object)"queryOtherMember: Querying the inter member");
            }
            return interMember.handleQuery(message, intraMember.getMyId());
        }
        return null;
    }

    public static void setIntraMember(DDLIntraClusterMember intraMbr) {
        intraMember = intraMbr;
    }

    public static void setInterMember(DDLInterClusterMember interMbr) {
        interMember = interMbr;
    }
}

