/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmConstants;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DigitBasedRow {
    private final long id;
    private final short min;
    private final short max;
    private final byte[] digits;
    private final Long sipDomainId;
    private byte[] width = null;
    private final boolean isRange;

    public DigitBasedRow(long id, short min, short max, String digits, Long sipDomainId) {
        this.id = id;
        this.sipDomainId = sipDomainId;
        if (digits == null) {
            this.digits = null;
            this.min = 0;
            this.max = 0;
            this.isRange = false;
        } else {
            this.digits = digits.getBytes(AsmConstants.CHARSET);
            short length = (short)digits.indexOf(58);
            if (length == -1 || 2 * length + 1 != digits.length()) {
                this.min = min;
                this.max = max;
                this.isRange = false;
            } else {
                this.min = length;
                this.max = length;
                this.isRange = true;
            }
        }
    }

    public DigitBasedRow(short length, String digits, DigitBasedRow row) {
        this(row.id, length, length, digits, row.sipDomainId);
    }

    public long getId() {
        return this.id;
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    public String getDigits() {
        return this.digits == null ? null : new String(this.digits, AsmConstants.CHARSET);
    }

    public boolean isRange() {
        return this.isRange;
    }

    public Long getSipDomainId() {
        return this.sipDomainId;
    }

    public byte[] getWidth(boolean computeWidth) {
        if (computeWidth) {
            this.computeWidth();
        }
        return this.width;
    }

    public synchronized void computeWidth() {
        if (this.width == null) {
            if (!this.isRange) {
                int i;
                StringBuilder s = new StringBuilder("1");
                for (i = this.min; i < this.max; ++i) {
                    s.append("1");
                }
                for (i = this.digits.length; i < this.min; ++i) {
                    s.append("0");
                }
                for (i = 1; i < this.digits.length; ++i) {
                    if (this.digits[i] != 120 && this.digits[i] != 88) continue;
                    s.append("0");
                }
                BigInteger widthInt = new BigInteger(s.toString());
                if (this.digits[0] == 120 || this.digits[0] == 88) {
                    widthInt = widthInt.multiply(BigInteger.valueOf(12L));
                }
                this.width = widthInt.toByteArray();
            } else {
                int offset = this.digits[0] == 43 ? 1 : 0;
                int length = (this.digits.length - 1) / 2 - offset;
                BigInteger fromInt = new BigInteger(new String(this.digits, offset, length, AsmConstants.CHARSET));
                BigInteger widthInt = new BigInteger(new String(this.digits, offset * 2 + length + 1, length, AsmConstants.CHARSET));
                widthInt = widthInt.subtract(fromInt);
                widthInt = widthInt.add(BigInteger.valueOf(1L));
                this.width = widthInt.toByteArray();
            }
        }
    }

    public int compareWidth(DigitBasedRow otherRow) {
        int len;
        int diff;
        if (this.width == null) {
            this.computeWidth();
        }
        if (otherRow.width == null) {
            otherRow.computeWidth();
        }
        if ((diff = (len = this.width.length) - otherRow.width.length) != 0) {
            return diff;
        }
        for (int i = 0; i < len; ++i) {
            diff = (this.width[i] & 0xFF) - (otherRow.width[i] & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public List<? extends DigitBasedRow> getSubrows(Class<? extends DigitBasedRow> rowClass) {
        ArrayList<DigitBasedRow> rows = new ArrayList<DigitBasedRow>();
        if (this.isRange) {
            int diffIndex;
            int length = (this.digits.length - 1) / 2;
            String from = new String(this.digits, 0, length, AsmConstants.CHARSET);
            String to = new String(this.digits, length + 1, length, AsmConstants.CHARSET);
            for (diffIndex = 0; diffIndex < length && this.digits[diffIndex] == this.digits[diffIndex + length + 1]; ++diffIndex) {
            }
            this.expand(rows, from, to, from.substring(0, diffIndex), rowClass);
        } else {
            rows.add(this);
        }
        return rows;
    }

    private void expand(List<DigitBasedRow> rows, String from, String to, String pattern, Class<? extends DigitBasedRow> rowClass) {
        short length = (short)from.length();
        if (length == pattern.length() || this.contains(from, to, pattern)) {
            try {
                Constructor<? extends DigitBasedRow> constructor = rowClass.getConstructor(Short.TYPE, String.class, rowClass);
                DigitBasedRow newRow = constructor.newInstance(length, pattern, this);
                rows.add(newRow);
            }
            catch (Exception constructor) {
                // empty catch block
            }
            return;
        }
        int lowDigit = from.startsWith(pattern) ? from.charAt(pattern.length()) - 48 : 0;
        int highDigit = to.startsWith(pattern) ? to.charAt(pattern.length()) - 48 : 9;
        for (int digit = lowDigit; digit <= highDigit; ++digit) {
            this.expand(rows, from, to, pattern + digit, rowClass);
        }
    }

    public boolean contains(String from, String to, String pattern) {
        int patternLength = pattern.length();
        int compare = pattern.compareTo(from.substring(0, patternLength));
        if (compare < 0) {
            return false;
        }
        if (compare == 0 && !from.substring(patternLength).matches("^0*$")) {
            return false;
        }
        compare = pattern.compareTo(to.substring(0, patternLength));
        if (compare > 0) {
            return false;
        }
        return compare != 0 || to.substring(patternLength).matches("^9*$");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitBasedRow)) {
            return false;
        }
        DigitBasedRow other = (DigitBasedRow)object;
        if (this.digits.length != other.digits.length) {
            return false;
        }
        for (int i = 0; i < this.digits.length; ++i) {
            if (this.digits[i] == other.digits[i]) continue;
            return false;
        }
        if (this.min != other.min || this.max != other.max) {
            return false;
        }
        return (this.sipDomainId == null || this.sipDomainId.equals(other.sipDomainId)) && (this.sipDomainId != null || other.sipDomainId == null);
    }

    public int hashCode() {
        int hash = 23;
        hash = hash * 37 + Arrays.hashCode(this.digits);
        hash = hash * 37 + this.min;
        hash = hash * 37 + this.max;
        hash = hash * 37 + (this.sipDomainId == null ? 0 : (int)(this.sipDomainId ^ this.sipDomainId >>> 32));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("DigitBasedRow[id=" + this.id + ": " + new String(this.digits, AsmConstants.CHARSET) + "/" + this.min + "/" + this.max + " dom=" + this.sipDomainId);
        if (this.width != null) {
            buf.append(" width=" + new BigInteger(this.width));
        }
        buf.append("]");
        return buf.toString();
    }
}

