/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EventPayload
implements Serializable {
    private static final long serialVersionUID = 4977374548153587647L;
    protected TargetType targetType;
    protected List<Object> parameters;

    public EventPayload(TargetType targetType, List<Object> parameter) {
        this.targetType = targetType;
        this.parameters = parameter;
    }

    public EventPayload() {
        this.targetType = TargetType.All;
        this.parameters = new ArrayList<Object>();
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return EventPayload.class.getSimpleName() + "[targetType=" + (Object)((Object)this.targetType) + ",parameters=" + this.parameters + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventPayload)) {
            return false;
        }
        EventPayload eventPayload = (EventPayload)obj;
        return eventPayload.getTargetType() == this.targetType && eventPayload.getParameters().equals(this.parameters);
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + this.targetType.ordinal();
        if (this.parameters != null) {
            result = 37 * result + this.parameters.hashCode();
        }
        return result;
    }

    public static enum TargetType {
        All,
        Contact,
        CommProfile,
        UserCommunity,
        BSM,
        UserDevice,
        Location;

    }

    public static class UserDevice
    implements Serializable {
        private static final long serialVersionUID = -5561652791699117450L;
        public final Long commProfileId;
        public final String instanceId;
        public final String ipAddress;

        public UserDevice(Long commProfileId, String instanceId) {
            this.commProfileId = commProfileId;
            this.instanceId = instanceId;
            this.ipAddress = null;
        }

        public UserDevice(Long commProfileId, String instanceId, String ipAddress) {
            this.commProfileId = commProfileId;
            this.instanceId = instanceId;
            this.ipAddress = ipAddress;
        }

        public String toString() {
            return "UserDevice [commProfileId=" + this.commProfileId + ", instanceId=" + this.instanceId + ", ipAddress=" + this.ipAddress + "]";
        }
    }
}

