/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.MonitorTransitions;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicLong;

public class MonitoredAsset
implements Serializable {
    private static final long serialVersionUID = -7940192790023545219L;
    protected volatile Status status = Status.INITIALIZING;
    protected volatile String callId = null;
    protected volatile AtomicLong sentOptions = new AtomicLong(0L);
    protected volatile AtomicLong lastResponse = new AtomicLong(0L);
    protected volatile AtomicLong responseMs = new AtomicLong(0L);
    protected volatile String reason = null;
    protected static final int SAVED_TRANSITIONS = 20;
    protected final MonitorTransitions<Status> transitions = new MonitorTransitions(20);

    public MonitoredAsset() {
        this.transitions.update(this.status, this.reason);
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public String getCallId() {
        return this.callId;
    }

    public long getSentOptions() {
        return this.sentOptions.get();
    }

    public void setSentOptions(long sentOptions) {
        this.sentOptions.set(sentOptions);
    }

    public Status getStatus() {
        return this.status;
    }

    public long getLastResponse() {
        return this.lastResponse.get();
    }

    public long getResponseMs() {
        return this.responseMs.get();
    }

    public void processResponse(Status status, String reason) {
        this.status = status;
        this.reason = reason;
        long time = Calendar.getInstance().getTimeInMillis();
        this.lastResponse.set(time);
        this.responseMs.set(time - this.sentOptions.get());
        this.transitions.update(status, reason, time);
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuffer returnString = new StringBuffer("MonitoredAsset[status=" + (Object)((Object)this.status) + ", sentOptions=" + dateFormat.format(this.sentOptions.get()) + ", lastResponse=" + dateFormat.format(this.lastResponse.get()) + ", responseMs=" + this.responseMs + ", reason=\"" + this.reason + "\", transitions=" + this.transitions + "]");
        return returnString.toString();
    }

    public static enum Status {
        INITIALIZING,
        UP,
        DOWN;

    }
}

