/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.JBossTrustMgmtUtil;
import com.avaya.asm.trustmgmt.TMRevocationSSLSocketFactory;
import com.avaya.common.logging.client.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class TMRevocationSSLServerSocketFactory
extends SSLServerSocketFactory {
    private static final Logger log = AsmLogger.getLogger(TMRevocationSSLServerSocketFactory.class);
    private static SSLContext sslContext = null;
    private SSLServerSocketFactory sslServerSocketFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public TMRevocationSSLServerSocketFactory() throws Exception {
        String functionName = "TMRevocationSSLServerSocketFactory";
        boolean isFineEnabled = log.isFineEnabled();
        boolean isFinestEnabled = log.isFinestEnabled();
        if (sslContext != null) {
            Class<TMRevocationSSLServerSocketFactory> clazz = TMRevocationSSLServerSocketFactory.class;
            // MONITORENTER : com.avaya.asm.trustmgmt.TMRevocationSSLServerSocketFactory.class
            if (sslContext != null) {
                this.sslServerSocketFactory = sslContext.getServerSocketFactory();
            }
            // MONITOREXIT : clazz
            if (isFinestEnabled) {
                log.finest((Object)"TMRevocationSSLServerSocketFactory: Using existing SSLContext.");
            }
        }
        if (this.sslServerSocketFactory == null) {
            SSLContext ctx;
            if (isFinestEnabled) {
                log.finest((Object)"TMRevocationSSLServerSocketFactory: Creating new SSLContext.");
            }
            if ((ctx = JBossTrustMgmtUtil.getInstance().getSSLContext()) == null) {
                log.error((Object)"TMRevocationSSLServerSocketFactory: Could not create SSLContext.");
            } else {
                Class<TMRevocationSSLSocketFactory> clazz = TMRevocationSSLSocketFactory.class;
                // MONITORENTER : com.avaya.asm.trustmgmt.TMRevocationSSLSocketFactory.class
                sslContext = ctx;
                // MONITOREXIT : clazz
                SSLContext.setDefault(ctx);
                this.sslServerSocketFactory = ctx.getServerSocketFactory();
            }
        }
        if (!isFineEnabled) return;
        log.fine((Object)("TMRevocationSSLServerSocketFactory: Constructed. sslContext=" + sslContext));
    }

    @Override
    public String[] getDefaultCipherSuites() {
        String functionName = "getDefaultCipherSuites";
        boolean isFinestEnabled = log.isFinestEnabled();
        String[] defaultCipherSuites = this.sslServerSocketFactory.getDefaultCipherSuites();
        if (isFinestEnabled) {
            log.finest((Object)("getDefaultCipherSuites: length=" + defaultCipherSuites.length));
        }
        return defaultCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String functionName = "getSupportedCipherSuites";
        boolean isFinestEnabled = log.isFinestEnabled();
        String[] supportedCipherSuites = this.sslServerSocketFactory.getSupportedCipherSuites();
        if (isFinestEnabled) {
            log.finest((Object)("getSupportedCipherSuites: length=" + supportedCipherSuites.length));
        }
        return supportedCipherSuites;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        String functionName = "createServerSocket";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)"createServerSocket");
        }
        return this.sslServerSocketFactory.createServerSocket();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        String functionName = "createServerSocket";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("createServerSocket: port=" + port));
        }
        return this.sslServerSocketFactory.createServerSocket(port);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        String functionName = "createServerSocket";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("createServerSocket: port=" + port + ", backlog=" + backlog));
        }
        return this.sslServerSocketFactory.createServerSocket(port, backlog);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress inetAddress) throws IOException {
        String functionName = "createServerSocket";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)("createServerSocket: port=" + port + ", backlog=" + backlog + ", inetAddress=" + inetAddress));
        }
        return this.sslServerSocketFactory.createServerSocket(port, backlog, inetAddress);
    }

    public static ServerSocketFactory getDefault() {
        String functionName = "getDefault";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)"getDefault");
        }
        return SSLServerSocketFactory.getDefault();
    }
}

