/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore.client.mgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.ContactDM;
import com.avaya.asm.datamgr.UpdatedContactsDM;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.helpers.PostgresConnectionInfo;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.AsmDBMgr;
import com.avaya.ustore.UtilityErrorHandler;
import com.avaya.ustore.client.UstoreContactMgrException;
import com.avaya.ustore.client.UstoreFaultCodes;
import com.avaya.ustore.client.mgr.UstoreContactMgrAPI;
import com.avaya.ustore.client.objectapi.ContactData;
import com.avaya.ustore.client.objectapi.ContactList;
import com.avaya.ustore.objectapi.UpdatedUser;
import com.avaya.ustore.objectapi.UstoreContactKey;
import com.avaya.ustore.objectapi.UstoreContactRecord;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UstoreContactMgr
implements UstoreContactMgrAPI {
    Map<CassandraConnectionInfo, ContactDM> contactDmMap = new ConcurrentHashMap<CassandraConnectionInfo, ContactDM>();
    Map<CassandraConnectionInfo, UpdatedContactsDM> ucDmMap = new ConcurrentHashMap<CassandraConnectionInfo, UpdatedContactsDM>();
    private static final Object mutex = new Object();
    private final Logger log = AsmLogger.getLogger(UstoreContactMgr.class);

    @Override
    public ContactData getContactWithAsmInstances(List<AsmInstance> instances, long ownerCsuserId, UUID contactId, CassandraConnectionInfo cConnInfo, PostgresConnectionInfo pConnInfo) throws DMException, UstoreContactMgrException {
        String contactDataAddress;
        String fcn_name = "getContactWithAsmInstances";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            if (cConnInfo != null) {
                this.log.finer((Object)("getContactWithAsmInstances: enter with ASM Instances = " + instances + ", ownerCsuserId = " + ownerCsuserId + ", contactId = " + contactId + ", cassandra connection info = " + cConnInfo));
            } else {
                this.log.finer((Object)("getContactWithAsmInstances: enter with ASM Instances = " + instances + ", ownerCsuserId = " + ownerCsuserId + ", contactId = " + contactId + ", no cassandra connection info provided, using default connection info"));
            }
        }
        if (instances == null || contactId == null) {
            this.log.warn((Object)("getContactWithAsmInstances: We got bad data: ASM Instances = " + instances + ", contactId = " + contactId));
            return null;
        }
        this.validateUserDataOk(ownerCsuserId, cConnInfo);
        UstoreContactRecord uCR = this.getContactDM(cConnInfo).getContactWithKeyspace(new UserStoreKeyspace(instances), ownerCsuserId, contactId);
        if (uCR == null) {
            this.log.warn((Object)("getContactWithAsmInstances: Contact was not found in Cassandra for ownerCsuserId: " + ownerCsuserId + " and contactId: " + contactId));
            return null;
        }
        ContactData cData = new ContactData(uCR, pConnInfo);
        if (isFinest) {
            this.log.finest((Object)("getContactWithAsmInstances: UstoreContactRecord: " + uCR + " was converted to a ContactData object"));
        }
        if ((contactDataAddress = cData.getAddress()) != null) {
            if (!contactDataAddress.isEmpty()) {
                if (isFiner) {
                    this.log.finer((Object)("getContactWithAsmInstances: The ppmAddress has real data in it: " + contactDataAddress));
                }
                return cData;
            }
            if (isFiner) {
                this.log.finer((Object)("getContactWithAsmInstances: The ppmAddress was empty, so this contact is for a 'soft' deleted Enterprise user: ownerCsuserId: " + ownerCsuserId + " and contactId: " + contactId));
            }
            return null;
        }
        String msg = "Something's either very wrong with this contact or it's a contact for a 'hard' deleted Enterprise user: ownerCsuserId: " + ownerCsuserId + " and contactId: " + contactId;
        this.log.error((Object)("getContactWithAsmInstances: " + msg));
        throw new UstoreContactMgrException(UstoreFaultCodes.RequiredDataMissing, msg);
    }

    @Override
    public ContactList getAllContactsWithAsmInstances(List<AsmInstance> instances, long ownerCsuserId, CassandraConnectionInfo cConnInfo, PostgresConnectionInfo pConnInfo) throws DMException, UstoreContactMgrException {
        String fcn_name = "getAllContactsWithAsmInstances";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            if (cConnInfo != null) {
                this.log.finer((Object)("getAllContactsWithAsmInstances: enter with ASM Instances = " + instances + ", ownerCsuserId = " + ownerCsuserId + ", cassandra connection info = " + cConnInfo));
            } else {
                this.log.finer((Object)("getAllContactsWithAsmInstances: enter with ASM Instances = " + instances + ", ownerCsuserId = " + ownerCsuserId + ", no cassandra connection info provided, using default connection info"));
            }
        }
        if (instances == null) {
            this.log.warn((Object)("getAllContactsWithAsmInstances: We got bad data: Asm Instances = " + instances));
            return null;
        }
        this.validateUserDataOk(ownerCsuserId, cConnInfo);
        List<UstoreContactRecord> uCRList = this.getContactDM(cConnInfo).getAllContactsWithKeyspace(new UserStoreKeyspace(instances), ownerCsuserId);
        ArrayList<ContactData> cDList = new ArrayList<ContactData>();
        Long lastTimeContactListUpdated = null;
        if (uCRList != null && !uCRList.isEmpty()) {
            for (UstoreContactRecord uCR : uCRList) {
                if (uCR == null) continue;
                UUID contactId = uCR.getKey().getId();
                ContactData cData = new ContactData(uCR, pConnInfo);
                String contactDataAddress = cData.getAddress();
                if (contactDataAddress != null) {
                    if (!contactDataAddress.isEmpty()) {
                        cDList.add(cData);
                        if (!isFinest) continue;
                        this.log.finest((Object)("getAllContactsWithAsmInstances: The ppmAddress has real data in it: " + contactDataAddress));
                        continue;
                    }
                    if (!isFinest) continue;
                    this.log.finest((Object)"getAllContactsWithAsmInstances: The ppmAddress was empty, so this contact is for a 'soft' deleted Enterprise user and we'll skip over it.");
                    continue;
                }
                String msg = "Something's either very wrong with this contact or it's a contact for a 'hard' deleted Enterprise user: ownerCsuserId: " + ownerCsuserId + " and contactId: " + contactId;
                this.log.error((Object)("getAllContactsWithAsmInstances: " + msg));
                throw new UstoreContactMgrException(UstoreFaultCodes.RequiredDataMissing, msg);
            }
            if (cDList != null && !cDList.isEmpty() && (lastTimeContactListUpdated = this.getUpdatedContactDM(cConnInfo).getUserInfoTimestamp(ownerCsuserId)) == null) {
                lastTimeContactListUpdated = 0L;
                String msg = "Something's very wrong since ownerCsuserId: " + ownerCsuserId + "'s lastTimeContactListUpdated timestamp was null, and they have contacts in their contact list. We will still return their contact list, but with a default value for lastTimeContactListUpdated of " + lastTimeContactListUpdated + ".";
                this.log.warn((Object)("getAllContactsWithAsmInstances: " + msg));
            }
        }
        if (isFiner) {
            this.log.finer((Object)("getAllContactsWithAsmInstances: leave, contact data list size = " + (cDList == null || cDList.isEmpty() ? Integer.valueOf(0) : cDList.size() + " and that list was converted to a list of ContactData objects")));
        }
        return new ContactList(lastTimeContactListUpdated, cDList);
    }

    @Override
    public List<UpdatedUser> getUsersWithUpdatedContacts(long beginningAtTimeMillis, CassandraConnectionInfo cConnInfo) throws DMException {
        String fcn_name = "getUsersWithUpdatedContacts";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            if (cConnInfo != null) {
                this.log.finer((Object)("getUsersWithUpdatedContacts: enter with beginningAtTimeMillis = " + beginningAtTimeMillis + ", cassandra connection info = " + cConnInfo));
            } else {
                this.log.finer((Object)("getUsersWithUpdatedContacts: enter with beginningAtTimeMillis = " + beginningAtTimeMillis + ", no cassandra connection info provided, using default connection info"));
            }
        }
        List<UpdatedUser> updatedUsers = this.getUpdatedContactDM(cConnInfo).getUsersWithUpdatedContacts(beginningAtTimeMillis);
        ArrayList<UpdatedUser> updatedUserList = new ArrayList<UpdatedUser>();
        for (UpdatedUser user : updatedUsers) {
            updatedUserList.add(new UpdatedUser(user.getCsUserId(), user.getUpdateTimeMillis()));
        }
        if (isFiner) {
            this.log.finer((Object)("getUsersWithUpdatedContacts: leave, UpdatedUser list size = " + updatedUserList.size()));
        }
        return updatedUserList;
    }

    private void validateUserDataOk(long ownerCsuserId, CassandraConnectionInfo cConnInfo) throws DMException, UstoreContactMgrException {
        String fcn_name = "validateUserDataOk";
        boolean userDataOk = this.getUpdatedContactDM(cConnInfo).getUserInfoDataOkFlag(ownerCsuserId);
        if (!userDataOk) {
            this.log.info((Object)("validateUserDataOk: leave, ownerCsuserId " + ownerCsuserId + ", This User's community is changed. Contacts of this user are being moved to new keyspace."));
            throw new UstoreContactMgrException(UstoreFaultCodes.DataNotAvailable, "Contacts of the user with id = " + ownerCsuserId + " are being moved.");
        }
    }

    public UstoreContactKey getUstoreContactKey(long csuserId, List<Long> instanceIds) throws DMException {
        String fcn_name = "getUstoreContactKey";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("getUstoreContactKey: enter with csuserId: " + csuserId + ", list of asmInstanceIds: " + instanceIds));
        }
        AsmDBMgr dbMgr = new AsmDBMgr(new UtilityErrorHandler());
        ArrayList<AsmInstance> asmInstanceList = new ArrayList<AsmInstance>();
        try {
            for (Long id : instanceIds) {
                AsmInstance instance = new AsmInstance(id, 65535L, dbMgr.queryAsmHostName(id), false);
                if (isFinest) {
                    this.log.finest((Object)("getUstoreContactKey: newly created Asminstance: " + instance));
                }
                asmInstanceList.add(instance);
            }
        }
        catch (SQLException sql) {
            throw new DMException("getUstoreContactKey: had trouble getting the Asm's hostname ", sql);
        }
        UserStoreKeyspace keyspace = new UserStoreKeyspace(asmInstanceList);
        return new UstoreContactKey(csuserId, null, keyspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContactDM getContactDM(CassandraConnectionInfo cConnInfo) {
        ContactDM instance = this.contactDmMap.get(cConnInfo);
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                instance = new ContactDM(cConnInfo);
                this.contactDmMap.putIfAbsent(cConnInfo, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdatedContactsDM getUpdatedContactDM(CassandraConnectionInfo cConnInfo) {
        UpdatedContactsDM instance = this.ucDmMap.get(cConnInfo);
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                instance = new UpdatedContactsDM(cConnInfo);
                this.ucDmMap.putIfAbsent(cConnInfo, instance);
            }
        }
        return instance;
    }
}

