/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.DescribeCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_Describe")
class Describe
extends TextBuiltin {
    @Argument(index=0, metaVar="metaVar_treeish")
    private ObjectId tree;
    @Option(name="--long", usage="usage_LongFormat")
    private boolean longDesc;
    @Option(name="--match", usage="usage_Match", metaVar="metaVar_pattern")
    private List<String> patterns = new ArrayList<String>();

    Describe() {
    }

    @Override
    protected void run() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Git git = new Git(this.db);){
            DescribeCommand cmd = git.describe();
            if (this.tree != null) {
                cmd.setTarget(this.tree);
            }
            cmd.setLong(this.longDesc);
            cmd.setMatch(this.patterns.toArray(new String[0]));
            String result = null;
            try {
                result = cmd.call();
            }
            catch (RefNotFoundException e) {
                throw Describe.die(CLIText.get().noNamesFound, (Throwable)e);
            }
            if (result == null) {
                throw Describe.die(CLIText.get().noNamesFound);
            }
            this.outw.println(result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

