/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.StringGuidSupplier;
import com.avaya.commons.lang.ToLowerCaseFunction;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Strings {
    public static final int INDEX_NOT_FOUND = -1;

    private Strings() {
    }

    public static List<String> getLines(String input) {
        ArgAssert.assertNotNull(input, "input");
        BufferedReader reader = new BufferedReader(new StringReader(input));
        try {
            ArrayList lines = Lists.newArrayList();
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            ArrayList arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    public static boolean isValidInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Collection<String> toLowerCase(Collection<String> original) {
        return Strings.toLowerCase(original, Locale.getDefault());
    }

    public static Collection<String> toLowerCase(Collection<String> original, Locale locale) {
        ArgAssert.assertNotNull(original, "original");
        ArgAssert.assertNotNull(locale, "locale");
        return Collections2.transform(original, (Function)new ToLowerCaseFunction(locale));
    }

    public static String getUnique(String prefix, String suffix) {
        ArgAssert.assertNotNull(prefix, "prefix");
        ArgAssert.assertNotNull(suffix, "suffix");
        return prefix + new StringGuidSupplier().get() + suffix;
    }
}

