/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.reliableeventing;

import com.avaya.collaboration.reliableeventing.DestinationNameBuilder;
import com.avaya.collaboration.reliableeventing.ReliableEventHelper;
import com.avaya.collaboration.reliableeventing.ReliableEventingFactoryDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProviderException;

public final class ReliableEventingFactory {
    private static volatile ReliableEventingFactoryDelegate reliableEventingFactoryDelegate;
    private static String reliableEventingFactoryImplName;
    private static String serviceUtilClassName;
    private static String serviceDescriptorClassName;
    private static String getServiceDescriptorMethodName;
    private static String getServiceName;
    private static String getServiceVersion;

    private ReliableEventingFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReliableEventingFactoryDelegate getReliableEventingFactoryDelegate() {
        Class<ReliableEventingFactory> clazz = ReliableEventingFactory.class;
        synchronized (ReliableEventingFactory.class) {
            if (reliableEventingFactoryDelegate == null) {
                Constructor<?> clazzConstructor;
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName(reliableEventingFactoryImplName);
                }
                catch (Exception exception) {
                    throw new ProviderException("forName: Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") ", exception);
                }
                try {
                    clazzConstructor = clazz2.getConstructor(new Class[0]);
                }
                catch (Exception exception) {
                    throw new ProviderException("getConstructor: Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") ", exception);
                }
                try {
                    reliableEventingFactoryDelegate = (ReliableEventingFactoryDelegate)clazzConstructor.newInstance(new Object[0]);
                }
                catch (InstantiationException instantiationException) {
                    throw new ProviderException("newInstance(InstantiationException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") ", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ProviderException("newInstance(illegalAccessException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") ", illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ProviderException("newInstance(illegalArgumentException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") ", illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new ProviderException("newInstance(invocationTargetException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") ", invocationTargetException);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return reliableEventingFactoryDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReliableEventingFactoryDelegate getReliableEventingFactoryDelegate(String serviceName, String serviceVersion) {
        Class<ReliableEventingFactory> clazz = ReliableEventingFactory.class;
        synchronized (ReliableEventingFactory.class) {
            if (reliableEventingFactoryDelegate == null) {
                Constructor<?> clazzConstructor;
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName(reliableEventingFactoryImplName);
                }
                catch (Exception exception) {
                    throw new ProviderException("forName: Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
                }
                try {
                    clazzConstructor = clazz2.getConstructor(String.class, String.class);
                }
                catch (Exception exception) {
                    throw new ProviderException("getConstructor: Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
                }
                try {
                    reliableEventingFactoryDelegate = (ReliableEventingFactoryDelegate)clazzConstructor.newInstance(serviceName, serviceVersion);
                }
                catch (InstantiationException instantiationException) {
                    throw new ProviderException("newInstance(InstantiationException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ProviderException("newInstance(illegalAccessException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n", illegalAccessException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ProviderException("newInstance(illegalArgumentException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n", illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new ProviderException("newInstance(invocationTargetException): Failed to find delegate class for ReliableEventingFactory (" + reliableEventingFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n", invocationTargetException);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return reliableEventingFactoryDelegate;
        }
    }

    public static ReliableEventHelper getHelper() {
        StringBuffer serviceName = new StringBuffer();
        StringBuffer serviceVersion = new StringBuffer();
        ReliableEventingFactory.checkandObtainServiceNameVersionInfo(serviceName, serviceVersion);
        if (serviceName.length() != 0 && serviceVersion.length() != 0) {
            return ReliableEventingFactory.getReliableEventingFactoryDelegate(serviceName.toString(), serviceVersion.toString()).getReliableEventHelper();
        }
        return ReliableEventingFactory.getReliableEventingFactoryDelegate().getReliableEventHelper();
    }

    public static ReliableEventHelper getHelper(String serviceName, String serviceVersion) {
        return ReliableEventingFactory.getReliableEventingFactoryDelegate(serviceName, serviceVersion).getReliableEventHelper();
    }

    public static DestinationNameBuilder getDestinationNameBuilder() {
        return ReliableEventingFactory.getReliableEventingFactoryDelegate().getNameBuilder();
    }

    private static void checkandObtainServiceNameVersionInfo(StringBuffer serviceName, StringBuffer serviceVersion) {
        Class<?> serviceUtilClass = null;
        Class<?> serviceDescriptorClass = null;
        try {
            serviceUtilClass = Class.forName(serviceUtilClassName);
            serviceDescriptorClass = Class.forName(serviceDescriptorClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (serviceUtilClass != null && serviceDescriptorClass != null) {
            ReliableEventingFactory.invokeserviceDescriptorMethods(serviceUtilClass, serviceDescriptorClass, serviceName, serviceVersion);
        }
    }

    private static void invokeserviceDescriptorMethods(Class serviceUtilClass, Class serviceDescriptorClass, StringBuffer serviceName, StringBuffer serviceVersion) {
        try {
            Method method = serviceUtilClass.getMethod(getServiceDescriptorMethodName, null);
            Object serviceDescriptor = method.invoke((Object)serviceUtilClass, null);
            if (serviceDescriptor != null) {
                Object objserviceName = serviceDescriptorClass.getMethod(getServiceName, null).invoke(serviceDescriptor, null);
                Object objserviceVersion = serviceDescriptorClass.getMethod(getServiceVersion, null).invoke(serviceDescriptor, null);
                ReliableEventingFactory.checkAndUpdateServiceVersionDetails(objserviceName, objserviceVersion, serviceName, serviceVersion);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private static void checkAndUpdateServiceVersionDetails(Object objserviceName, Object objserviceVersion, StringBuffer serviceName, StringBuffer serviceVersion) {
        if (objserviceName != null && objserviceVersion != null && objserviceName instanceof String && objserviceVersion instanceof String) {
            serviceName.append((String)objserviceName);
            serviceVersion.append((String)objserviceVersion);
        }
    }

    static {
        reliableEventingFactoryImplName = "com.avaya.collaboration.reliableeventing.ReliableEventFactoryImpl";
        serviceUtilClassName = "com.avaya.zephyr.platform.dal.api.ServiceUtil";
        serviceDescriptorClassName = "com.avaya.zephyr.platform.dal.api.ServiceDescriptor";
        getServiceDescriptorMethodName = "getServiceDescriptor";
        getServiceName = "getName";
        getServiceVersion = "getVersion";
    }
}

