/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.synchronize.GitRemoteFile;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.ThreeWayDiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

class GitRemoteFolder
extends GitRemoteResource {
    private final GitSyncObjectCache cachedData;
    private final Repository repo;

    GitRemoteFolder(Repository repo, GitSyncObjectCache cachedData, RevCommit commitId, ObjectId objectId, String path) {
        super(commitId, objectId, path);
        this.repo = repo;
        this.cachedData = cachedData;
    }

    public boolean isContainer() {
        return true;
    }

    protected void fetchContents(IProgressMonitor monitor) throws TeamException {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GitRemoteFolder) {
            GitRemoteFolder that = (GitRemoteFolder)((Object)object);
            return this.getPath().equals(that.getPath()) && this.getObjectId().equals((AnyObjectId)that.getObjectId());
        }
        return false;
    }

    public int hashCode() {
        return this.getObjectId().hashCode() ^ this.getPath().hashCode();
    }

    GitRemoteResource[] members(IProgressMonitor monitor) {
        Collection<GitSyncObjectCache> members = this.cachedData.members();
        if (members == null || members.size() == 0) {
            return new GitRemoteResource[0];
        }
        ArrayList<GitRemoteFolder> result = new ArrayList<GitRemoteFolder>();
        monitor.beginTask(NLS.bind((String)CoreText.GitRemoteFolder_fetchingMembers, (Object)this.getPath()), this.cachedData.membersCount());
        try {
            for (GitSyncObjectCache member : members) {
                ThreeWayDiffEntry diffEntry = member.getDiffEntry();
                String memberPath = diffEntry.getPath();
                ObjectId id = diffEntry.getRemoteId().toObjectId();
                GitRemoteResource obj = diffEntry.isTree() ? new GitRemoteFolder(this.repo, member, this.getCommitId(), id, memberPath) : new GitRemoteFile(this.repo, this.getCommitId(), id, memberPath, diffEntry.getMetadata());
                result.add((GitRemoteFolder)obj);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
        return result.toArray(new GitRemoteResource[0]);
    }
}

