/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.UpdateCallBack;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.model.TreeLoader;
import com.avaya.eclipse.plugin.util.AESEncrypt;
import com.avaya.ssh.SSHConnector;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PropertyWindowEditor {
    private static Map<String, Control> controls = new HashMap<String, Control>();
    private static Shell shell;
    private static Properties serverPropes;
    private static Label statusLabel;
    private static String[] properties;

    public static Label getStatusLabel() {
        return statusLabel;
    }

    public static void setShell(Shell shell) {
        PropertyWindowEditor.shell = shell;
    }

    public static Control createPropertyContent(CTabFolder folder) {
        return PropertyWindowEditor.createPropertyContent(folder, properties, null, null);
    }

    public static Control createPropertyContent(CTabFolder folder, String[] props, UpdateCallBack update, Properties pDefault) {
        Composite composite = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout(2, false);
        int widthL = folder.getSize().x * 1 / 2 - 20;
        int widthR = folder.getSize().x * 1 / 2 - 20;
        try {
            composite.setLayout((Layout)layout);
        }
        catch (Exception e) {
            composite.setLayout((Layout)layout);
        }
        Group group = new Group(composite, 0);
        group.setText("Avaya Breeze\u00ae Configuration Properties");
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        try {
            group.setLayout((Layout)new RowLayout(256));
        }
        catch (Exception e) {
            group.setLayout((Layout)new RowLayout(256));
        }
        if (serverPropes == null) {
            serverPropes = PropertyWindowEditor.readProperties();
        }
        if (props == null) {
            props = properties;
        }
        for (String property : props) {
            Label label = new Label((Composite)group, 0);
            label.setText(property);
            label.setLayoutData((Object)new RowData(widthL, 20));
            Text value = null;
            value = "Avaya Breeze\u00ae Password".equals(property) || "Password (CLI User)".equals(property) ? new Text((Composite)group, 0x400800) : new Text((Composite)group, 2048);
            String tVal = "";
            tVal = pDefault != null ? pDefault.getProperty(property) : serverPropes.getProperty(property);
            if (tVal == null) {
                tVal = "";
            }
            value.setText(tVal);
            if (property.equals("SSH Port")) {
                label.setToolTipText("SSH port number if SSH service is not running on default port 22.");
                value.setToolTipText("SSH port number if SSH service is not running on default port 22.");
            }
            value.setLayoutData((Object)new RowData(widthR, 20));
            controls.put(property, (Control)value);
        }
        group = new Group(composite, 0);
        group.setText("Actions");
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new RowLayout(256));
        Button confirm = new Button((Composite)group, 8);
        confirm.setText("Save");
        confirm.setLayoutData((Object)new RowData(110, 30));
        PropertyWindowEditor.setPropertiesSaveAction(confirm, update, props);
        Button cancel = new Button((Composite)group, 8);
        cancel.setText("Cancel");
        cancel.setLayoutData((Object)new RowData(110, 30));
        PropertyWindowEditor.setPropertiesCancelOrCloseAction(cancel, update);
        return composite;
    }

    private static void setPropertiesCancelOrCloseAction(Button cancel, final UpdateCallBack update) {
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                update.onCancelOrClose();
            }
        });
    }

    public static Control createPropertyContent(Composite folder, UpdateCallBack update) {
        Composite composite = new Composite(folder, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        try {
            composite.setLayout((Layout)layout);
        }
        catch (Exception e) {
            composite.setLayout((Layout)layout);
        }
        int widthL = 100;
        int widthR = 200;
        Group group = new Group(composite, 0);
        group.setText("Maven Configuration");
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        try {
            group.setLayout((Layout)new RowLayout(256));
        }
        catch (Exception e) {
            group.setLayout((Layout)new RowLayout(256));
        }
        if (serverPropes == null) {
            serverPropes = PropertyWindowEditor.readProperties();
        }
        Label label = null;
        Text value = null;
        label = new Label((Composite)group, 0);
        label.setText("Maven Options");
        label.setLayoutData((Object)new RowData(widthL + 10, 20));
        value = new Text((Composite)group, 2048);
        value.setText(serverPropes.getProperty("Maven Options"));
        value.setToolTipText("Enter Maven build options here. Separte multiple options by comma(,). Example: -D Prop=value,-V, -l path/to/log/file");
        value.setLayoutData((Object)new RowData(widthR, 20));
        controls.put("Maven Options", (Control)value);
        group = new Group(composite, 0);
        group.setText("Actions");
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new RowLayout(256));
        Button addSMGR = new Button((Composite)group, 8);
        addSMGR.setText("Add SMGR");
        addSMGR.setLayoutData((Object)new RowData(110, 30));
        PropertyWindowEditor.setAddSMGRAction(addSMGR, update);
        Button confirm = new Button((Composite)group, 8);
        confirm.setText("Save");
        confirm.setLayoutData((Object)new RowData(110, 30));
        PropertyWindowEditor.setPropertiesSaveAction(confirm, update, new String[]{"Maven Options"});
        Button cancel = new Button((Composite)group, 8);
        cancel.setText("Close");
        cancel.setLayoutData((Object)new RowData(110, 30));
        PropertyWindowEditor.setPropertiesCancelOrCloseAction(cancel, update);
        group = new Group(composite, 0);
        group.setText("Status");
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 5;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new RowLayout(256));
        statusLabel = new Label((Composite)group, 0);
        statusLabel.setLayoutData((Object)new RowData(350, 30));
        statusLabel.setText("Please right click for more options");
        return composite;
    }

    private static void setAddSMGRAction(Button addSMGR, final UpdateCallBack update) {
        addSMGR.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                update.onAddSMGR();
            }
        });
    }

    public static Properties getServerConfProperties() {
        if (serverPropes == null) {
            PropertyWindowEditor.readProperties();
        }
        return serverPropes;
    }

    public static Properties readProperties() {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(PluginUtilities.getInstance().getWorkspace().getRoot().getRawLocation().toString() + "/ceconf.properties");
            PropertyWindowEditor.loadDefaults();
            serverPropes.load(fis);
        }
        catch (Exception e1) {
            PropertyWindowEditor.loadDefaults();
            PropertyWindowEditor.updateProperties();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Activator.log(4, 0, "Error reading properties", e);
                }
            }
        }
        return serverPropes;
    }

    public static void restoreEncryptedPasswords() {
        try {
            String ceUser = serverPropes.getProperty("Avaya Breeze\u00ae User Name");
            String smgrUser = serverPropes.getProperty("User Name (CLI User)");
            String ceDecPassword = AESEncrypt.decrypt(serverPropes.getProperty("Avaya Breeze\u00ae Password"), ceUser);
            String smgrDecPassword = AESEncrypt.decrypt(serverPropes.getProperty("Password (CLI User)"), smgrUser);
            serverPropes.setProperty("Password (CLI User)", smgrDecPassword);
            serverPropes.setProperty("Avaya Breeze\u00ae Password", ceDecPassword);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error decrypting passwords", e);
        }
    }

    public static void encryptPassword() {
        try {
            String ceUser = serverPropes.getProperty("Avaya Breeze\u00ae User Name");
            String smgrUser = serverPropes.getProperty("User Name (CLI User)");
            String ceDecPassword = AESEncrypt.encrypt(serverPropes.getProperty("Avaya Breeze\u00ae Password"), ceUser);
            String smgrDecPassword = AESEncrypt.encrypt(serverPropes.getProperty("Password (CLI User)"), smgrUser);
            serverPropes.setProperty("Password (CLI User)", smgrDecPassword);
            serverPropes.setProperty("Avaya Breeze\u00ae Password", ceDecPassword);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error encrypting passwords", e);
        }
    }

    public static String getMavenHome() {
        if (serverPropes == null) {
            PropertyWindowEditor.readProperties();
        }
        return serverPropes.getProperty("Maven Home Directory");
    }

    public static ElementInfo getSMGRElement() {
        ElementInfo element = new ElementInfo();
        String smgrIp = PropertyWindowEditor.getServerConfProperties().getProperty("System Manager IP");
        String user = PropertyWindowEditor.getServerConfProperties().getProperty("User Name (CLI User)");
        String password = PropertyWindowEditor.getServerConfProperties().getProperty("Password (CLI User)");
        String rootUser = PropertyWindowEditor.getServerConfProperties().getProperty("root User Name");
        String rootPassword = PropertyWindowEditor.getServerConfProperties().getProperty("root Password");
        String port = PropertyWindowEditor.getServerConfProperties().getProperty("SSH Port");
        element.setIp(smgrIp);
        element.setUserName(user);
        element.setPassword(password);
        boolean isRootEnabled = Boolean.valueOf(PropertyWindowEditor.getServerConfProperties().getProperty("Switch to root User"));
        element.setSwitchToSu(isRootEnabled);
        element.setRootUser(rootUser);
        element.setRootPassword(rootPassword);
        try {
            element.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            element.setPort(22);
        }
        element.setServerType(ElementInfo.ServerType.SMGR);
        return element;
    }

    public static List<ElementInfo> getCEElements(List<ElementInfo> elements) {
        ArrayList<ElementInfo> elementTempList = new ArrayList<ElementInfo>();
        if (elements != null) {
            for (ElementInfo element : elements) {
                for (ElementInfo element1 : element.getAssociatedElements()) {
                    if (element1.getServerType() == ElementInfo.ServerType.CLUSTER) {
                        for (ElementInfo elementC : element1.getAssociatedElements()) {
                            if (!elementC.isChecked()) continue;
                            elementTempList.add(elementC);
                        }
                        continue;
                    }
                    elementTempList.add(element);
                }
            }
        }
        return elementTempList;
    }

    public static List<ElementInfo> getSMGREmements() {
        return TreeLoader.getInstance().getSelectedNodesAsElement();
    }

    public static ElementInfo getCEElement() {
        ElementInfo element = new ElementInfo();
        String ceIp = PropertyWindowEditor.getServerConfProperties().getProperty("Avaya Breeze\u00ae Server IP(Management)");
        String user = PropertyWindowEditor.getServerConfProperties().getProperty("Avaya Breeze\u00ae User Name");
        String password = PropertyWindowEditor.getServerConfProperties().getProperty("Avaya Breeze\u00ae Password");
        String port = PropertyWindowEditor.getServerConfProperties().getProperty("SSH Port");
        element.setIp(ceIp);
        element.setUserName(user);
        element.setPassword(password);
        element.setSwitchToSu(false);
        try {
            element.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            element.setPort(22);
        }
        return element;
    }

    public static Properties loadDefaults() {
        serverPropes = new Properties();
        serverPropes.put("Maven Options", "");
        serverPropes.put("Maven Home Directory", "");
        serverPropes.put("Avaya Breeze\u00ae Service Log Name", "/var/log/Avaya/sm/asm.log");
        String consoleLogPath = "console.log";
        try {
            consoleLogPath = System.getProperty("user.home") + System.getProperty("file.separator") + "console.log";
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error getting system properties", e);
        }
        serverPropes.put("Service Log File Path", consoleLogPath);
        return serverPropes;
    }

    public static void validateConfigurations(boolean isMessageNeeded) {
        if (serverPropes == null) {
            PropertyWindowEditor.readProperties();
        }
    }

    public static void updateProperties() {
        try {
            FileOutputStream fos = new FileOutputStream(PluginUtilities.getInstance().getWorkspace().getRoot().getRawLocation().toString() + "/ceconf.properties");
            serverPropes.save(fos, "Initial Data");
            fos.close();
            PropertyWindowEditor.readProperties();
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error updating properties", e);
        }
    }

    public static void createRSESystem(List<ElementInfo> elements) {
        ISystemRegistry systemRegistry = PluginUtilities.getInstance().getTheSystemRegistry();
        ISystemProfile profile = systemRegistry.getSystemProfileManager().getDefaultPrivateSystemProfile();
        IRSESystemType systemType = PluginUtilities.getInstance().getRSECoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.ssh");
        ISubSystemConfiguration[] configurations = systemRegistry.getSubSystemConfigurationsBySystemType(systemType, true);
        class DefaultConfigurator
        implements ISubSystemConfigurator {
            private ISubSystemConfiguration _configuration;

            public DefaultConfigurator(ISubSystemConfiguration configuration) {
                this._configuration = configuration;
            }

            public boolean applyValues(ISubSystem ss) {
                return true;
            }

            public ISubSystemConfiguration getSubSystemConfiguration() {
                return this._configuration;
            }
        }
        ArrayList<DefaultConfigurator> configList = new ArrayList<DefaultConfigurator>();
        for (int i = 0; i < configurations.length; ++i) {
            ISubSystemConfiguration configuration = configurations[i];
            Activator.log(1, "System Conf :" + configuration.getId());
            configList.add(new DefaultConfigurator(configuration));
        }
        Collections.reverse(configList);
        ISubSystemConfigurator[] confs = configList.toArray(new ISubSystemConfigurator[configList.size()]);
        for (ElementInfo ei : elements) {
            if (ei.getServerType().equals((Object)ElementInfo.ServerType.SMGR)) {
                try {
                    PropertyWindowEditor.createHost(ei, profile, "SMGR-" + ei.getIp(), confs, systemType);
                }
                catch (Exception e) {
                    Activator.log(4, 0, "Error creating IHost for SMGR " + ei.getIp(), e);
                }
                continue;
            }
            if (!ei.getServerType().equals((Object)ElementInfo.ServerType.CE)) continue;
            try {
                PropertyWindowEditor.createHost(ei, profile, "Avaya Breeze Server-" + ei.getIp(), confs, systemType);
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error creating IHost for Avaya Breeze " + ei.getIp(), e);
            }
        }
    }

    private static void createHost(ElementInfo ei, ISystemProfile profile, String profileAlias, ISubSystemConfigurator[] confs, IRSESystemType systemType) {
        ISystemRegistry systemRegistry = PluginUtilities.getInstance().getTheSystemRegistry();
        try {
            IHost host = systemRegistry.getHost(profile, profileAlias);
            if (host != null) {
                systemRegistry.deleteHost(host);
            }
            host = systemRegistry.createHost(profile.getName(), systemType, profileAlias, ei.getIp(), null, ei.getUserName(), 2, confs);
            SystemSignonInformation info = new SystemSignonInformation(ei.getIp(), ei.getUserName(), ei.getPassword(), systemType);
            PluginUtilities.getInstance().addToPasswordPersistenceManager(info, true, false);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error creating IHost for " + ei.toString(), e);
        }
    }

    private static void setPropertiesSaveAction(Button confirm, final UpdateCallBack update, final String[] props) {
        confirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyWindowEditor.updateStatusLabel("Saving...");
                PropertyWindowEditor.updateUIProperties(e, update, props);
                PropertyWindowEditor.updateStatusLabel("Save complete");
            }
        });
    }

    public static void updateUIProperties(SelectionEvent event, UpdateCallBack update, String[] props) {
        try {
            Properties serverProperties = serverPropes;
            if (props == null) {
                props = properties;
            } else {
                serverProperties = new Properties();
            }
            for (String property : props) {
                if ("Switch to root User".equals(property) || !controls.containsKey(property)) continue;
                serverProperties.setProperty(property, ((Text)controls.get(property)).getText());
            }
            if (update != null) {
                if (serverProperties.containsKey("Maven Options")) {
                    serverPropes.setProperty("Maven Options", serverProperties.getProperty("Maven Options"));
                }
                PropertyWindowEditor.updateProperties();
                update.onUpdate(serverProperties);
            } else {
                PropertyWindowEditor.validateConfigurations(false);
                PropertyWindowEditor.updateProperties();
                SSHConnector.getInstance().disconnectAll();
                PluginUtilities.getInstance().openInformation(shell, "Save", "Properties Updated Successfully");
            }
        }
        catch (Exception e) {
            PluginUtilities.getInstance().openError(shell, "Configuration Error", e);
        }
    }

    public static boolean validateConnections(ElementInfo ceElement, String deviceTarget, boolean isMessageNeeded) {
        boolean isDeviceConnected = false;
        try {
            isDeviceConnected = SSHConnector.getInstance().getSSHConnection(ceElement).isConnected();
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error getting connection status for " + ceElement.getIp(), e);
        }
        if (!isDeviceConnected) {
            String prepend = "CE".equals(deviceTarget) ? "Avaya Breeze" : "System Manager";
            String connectionMessage = "Connection attempt failed with " + prepend + " host IP : " + ceElement.getIp() + ".";
            connectionMessage = connectionMessage + "Please check the '{}' IP address, SSH Port, reachability and credential configured for the server.".replace("{}", prepend);
            if (isMessageNeeded) {
                PluginUtilities.getInstance().openError(null, "Connection Error", connectionMessage);
            }
        }
        return isDeviceConnected;
    }

    public static void updateStatusLabel(String msg) {
        if (statusLabel != null) {
            statusLabel.setText(msg);
        }
    }

    static {
        properties = new String[]{"Maven Home Directory"};
        if (serverPropes == null) {
            try {
                PropertyWindowEditor.readProperties();
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error reading properties file", e);
            }
        }
    }
}

