/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.ButtonCallbackAdapter;
import com.avaya.eclipse.plugin.CEAction;
import com.avaya.eclipse.plugin.CheckboxTreeSelectionHelper;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.ServerTreeViewUiManager;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.model.ServerLabelProvider;
import com.avaya.eclipse.plugin.model.TreeLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ServerTreeView
extends Dialog {
    private Object result;
    private Shell shell;
    private Tree tree;
    private CheckboxTreeViewer checkboxTreeViewer;
    private CheckboxTreeSelectionHelper helper = null;
    public CEAction ceAction;

    public ServerTreeView(Shell parent) {
        super(parent, 2160);
        this.setText("System Manager Browser");
    }

    public CheckboxTreeViewer getCheckboxTreeViewer() {
        return this.checkboxTreeViewer;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    public void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(405, 360);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout());
        this.checkboxTreeViewer = new CheckboxTreeViewer(composite, 2048);
        this.tree = this.checkboxTreeViewer.getTree();
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tree.setToolTipText("Right click for more options");
        PropertyWindowEditor.createPropertyContent(composite, new ButtonCallbackAdapter(this.shell){

            @Override
            public void onUpdate(Properties props) {
                Activator.log(1, "property updated");
                TreeLoader.getInstance().save(ServerTreeView.this.helper.getCheckedElements(), ServerTreeView.this.helper.getGrayedElements());
            }

            @Override
            public void onAddSMGR() {
                ServerTreeViewUiManager x;
                ServerTreeViewUiManager serverTreeViewUiManager = x = new ServerTreeViewUiManager(ServerTreeView.this.shell, ServerTreeView.this.checkboxTreeViewer);
                serverTreeViewUiManager.getClass();
                ServerTreeViewUiManager.AddSystemManagerAction addSystemManager = serverTreeViewUiManager.new ServerTreeViewUiManager.AddSystemManagerAction((TreeViewer)ServerTreeView.this.checkboxTreeViewer);
                addSystemManager.run();
            }
        });
        this.checkboxTreeViewer.setUseHashlookup(true);
        Node node = TreeLoader.getInstance().getRootNode();
        ContentProvider cp = new ContentProvider();
        this.checkboxTreeViewer.setContentProvider((IContentProvider)cp);
        this.checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        this.helper = CheckboxTreeSelectionHelper.attach(this.checkboxTreeViewer, cp);
        this.checkboxTreeViewer.setInput((Object)node);
        this.checkboxTreeViewer.setCheckedElements(TreeLoader.getInstance().getSelectedNodes().toArray());
        this.checkboxTreeViewer.setGrayedElements(TreeLoader.getInstance().getGrayedNodes().toArray());
        new ServerTreeViewUiManager(this.shell, this.checkboxTreeViewer);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Activator.log(1, "Checked items (excluding grayed) are " + ServerTreeView.this.helper.getCheckedElements());
                Activator.log(1, "Grayed Elements : " + ServerTreeView.this.helper.getGrayedElements());
                if (ServerTreeView.this.ceAction != null) {
                    ServerTreeView.this.ceAction.setDisposed(true);
                }
            }
        });
    }

    private static class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return ((Node)parentElement).getChildren().toArray();
        }

        public Object getParent(Object element) {
            return ((Node)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return !((Node)element).getChildren().isEmpty();
        }
    }

    public static class Node {
        private String data;
        private List<Node> children = new ArrayList<Node>();
        private Node parent;
        private ElementInfo ei;
        private boolean checked;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return !(this.data == null ? other.data != null : !this.data.equals(other.data));
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public Node(String data) {
            this.data = data;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return this.children != null && this.children.size() > 0;
        }

        public void addChild(Node child) {
            this.children.add(child);
            child.setParent(this);
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public String getData() {
            return this.data;
        }

        public String toString() {
            return this.data;
        }

        public void setElementInfo(ElementInfo ei) {
            this.ei = ei;
        }

        public ElementInfo getElementInfo() {
            return this.ei;
        }
    }
}

