/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin.operation;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.CEProjectUtils;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.operation.CEOperation;
import com.avaya.eclipse.plugin.util.SelectedProjectFinder;
import com.avaya.ssh.SSHConnection;
import com.avaya.ssh.SSHConnectionGroup;
import com.avaya.ssh.SSHConnector;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.MessageConsole;

public class CEDeleteServiceOperation
extends CEOperation {
    private IProgressMonitor monitor;

    public CEDeleteServiceOperation(IProject project) {
        this.project = project;
    }

    public CEDeleteServiceOperation() {
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.setMessageConsoleStream();
        this.monitor = monitor;
        IStatus status = Status.OK_STATUS;
        CEProjectModel ceModelP = CEProjectUtils.evaluateAsCEProject(this.project.getLocation().toFile());
        monitor.beginTask("Undeploy " + ceModelP.getFullServiceName(), 3);
        this.startOperation(ceModelP);
        return status;
    }

    public void startOperation(CEProjectModel cep) {
        block17: {
            try {
                if (cep != null && cep.getAssociatedElements().size() == 0) {
                    CEOperation.openErrorDialog("Delete Service Operation Failure", "Please select at least one cluster to proceed with Avaya Breeze\u00ae Eclipse plug-in action.");
                    return;
                }
                if (cep == null || cep.getAssociatedElements() == null || cep.getAssociatedElements().size() <= 0) break block17;
                SSHConnectionGroup sshcg = new SSHConnectionGroup(cep.getAssociatedElements());
                Map<String, ElementInfo> smgrIPMap = CEProjectUtils.getElementsIPMap(cep.getAssociatedElements());
                this.logConsole("Start Undeploying service .....", cep.getAssociatedElements().toString());
                Map<String, String> returnMap = sshcg.execute("sudo /opt/Avaya/AUS/install/service_util.sh -p");
                sshcg.startUpdating(this);
                boolean undeploymentStatus = true;
                for (Map.Entry<String, String> retEntry : returnMap.entrySet()) {
                    for (ElementInfo cluster : smgrIPMap.get(retEntry.getKey()).getAssociatedElements()) {
                        String tag = "SMGR : " + retEntry.getKey() + " , Cluster : " + cluster.getName();
                        if (cluster.getAssociatedElements() == null || cluster.getAssociatedElements().size() == 0) {
                            this.logConsole("No Avaya Breeze\u00ae present on this Cluster ", tag);
                            continue;
                        }
                        SSHConnection sshce = SSHConnector.getInstance().getSSHConnection(smgrIPMap.get(retEntry.getKey()));
                        String clusters = sshce.execute("sudo /opt/Avaya/AUS/install/eclipse_helper.sh -s  '" + cluster.getName() + "'");
                        boolean isInstalled = false;
                        for (String line : clusters.split("\n")) {
                            String[] servDetails;
                            if (line.trim().length() == 0 || line.contains("could not change directory") || (servDetails = SelectedProjectFinder.getServiceStatus(line, cep)) == null) continue;
                            isInstalled = true;
                        }
                        if (isInstalled) {
                            SSHConnection sshSMGR = SSHConnector.getInstance().getSSHConnection(smgrIPMap.get(retEntry.getKey()));
                            sshSMGR.startUpdating(this);
                            sshSMGR.execute("sudo /opt/Avaya/AUS/install/service_util.sh -fu  " + cep.getServiceName() + " " + cep.getServiceVersion() + " '" + cluster.getName() + "'");
                            Map<String, ElementInfo> ceIPMap = CEProjectUtils.getElementsIPMap(cluster.getAssociatedElements());
                            boolean isUnDeploymentSuccess = true;
                            for (Map.Entry<String, ElementInfo> ceIPMapEntry : ceIPMap.entrySet()) {
                                boolean isUndeployed = this.isUndeployed(cep, ceIPMapEntry.getValue());
                                if (isUndeployed) {
                                    this.logConsole("Service Undeployed Successfully", "Cluster : " + cluster.getName() + " , Avaya Breeze\u00ae " + ceIPMapEntry.getValue().getIp());
                                    isUnDeploymentSuccess &= true;
                                    undeploymentStatus &= true;
                                    continue;
                                }
                                this.logConsole("Service Undeployment Failed", "Cluster : " + cluster.getName() + " , Avaya Breeze\u00ae " + ceIPMapEntry.getValue().getIp());
                                isUnDeploymentSuccess &= false;
                                undeploymentStatus &= false;
                            }
                            continue;
                        }
                        this.logConsole("Service is not installed on this Cluster", "SMGR : " + retEntry.getKey() + " , Avaya Breeze\u00ae : " + cluster.getName());
                    }
                }
                if (undeploymentStatus) {
                    this.logConsole("Operation finished Successfully", "");
                    for (Map.Entry<String, String> retEntry : returnMap.entrySet()) {
                        this.logConsole("Service is getting deleted.", "SMGR : " + retEntry.getKey() + " , Service : " + cep.getServiceName() + " Version: " + cep.getServiceVersion());
                        SSHConnection sshSMGR = SSHConnector.getInstance().getSSHConnection(smgrIPMap.get(retEntry.getKey()));
                        sshSMGR.startUpdating(this);
                        try {
                            String out = sshSMGR.execute("sudo /opt/Avaya/AUS/install/service_util.sh --delete  " + cep.getServiceName() + " " + cep.getServiceVersion());
                            if (out == null) continue;
                            if (out.contains(cep.getServiceName()) && out.contains(cep.getServiceVersion()) && out.contains("true")) {
                                this.logConsole("Service deleted successfully.", "SMGR : " + retEntry.getKey() + " , Service : " + cep.getServiceName() + " Version: " + cep.getServiceVersion());
                                continue;
                            }
                            this.logConsole("Service can not be deleted.Please verify that service is loaded.");
                        }
                        catch (Exception e) {
                            this.logConsole("Messgae:: " + e.getMessage());
                        }
                    }
                } else {
                    this.logConsole("Operation failed", "");
                }
                if (this.monitor != null) {
                    this.monitor.worked(1);
                }
                sshcg.stopUpdating(this);
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error in delete service operation", e);
                CEOperation.openDialog("UnDeployment Failure", e.getMessage());
            }
        }
    }

    public boolean deleteServiceFromCE(CEProjectModel cep, ElementInfo ceEi) throws Exception {
        this.logConsole("Try Directly On Avaya Breeze\u00ae to Undeploy " + cep.getFullServiceName());
        SSHConnection sshce = SSHConnector.getInstance().getSSHConnection(ceEi);
        sshce.startUpdating(this);
        sshce.execute("deploy_service -u  " + cep.getFullServiceName());
        sshce.stopUpdating(this);
        return this.isUndeployed(cep, ceEi);
    }

    private boolean isUndeployed(CEProjectModel cep, ElementInfo ceEi) {
        boolean isUndeployed = false;
        try {
            SSHConnection sshce = SSHConnector.getInstance().getSSHConnection(ceEi);
            sshce.startUpdating(this);
            for (int i = 0; i < 6; ++i) {
                String out = sshce.execute("deploy_service -lv");
                isUndeployed = !SelectedProjectFinder.getServiceStatusOnCE(out, cep);
                this.logConsole("Deployment Status of Project " + cep.getFullServiceName() + " is :" + !isUndeployed);
                if (isUndeployed) break;
                if (PluginUtilities.getInstance().isDemoMode()) continue;
                Thread.sleep(10000L);
            }
            sshce.stopUpdating(this);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error checking deployed status", e);
        }
        return isUndeployed;
    }

    @Override
    protected void setMessageConsoleStream(String projectName) {
        try {
            MessageConsole myConsole = this.findConsole(projectName);
            this.out = myConsole.newMessageStream();
            this.writer = new PrintWriter((OutputStream)this.out, true);
        }
        catch (Exception e) {
            this.writer = new PrintWriter(System.err, true);
        }
    }
}

