/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ssh;

public class CharBuffer {
    private char[] buffer = null;
    private int length = 0;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int length) {
        this.buffer = new char[length];
    }

    public CharBuffer(char[] bytes) {
        this.buffer = (char[])bytes.clone();
        this.length = bytes.length;
    }

    public CharBuffer append(char byteVal) {
        return this.insert(this.length, byteVal);
    }

    public CharBuffer append(char[] bytes) {
        return this.insert(this.length, bytes);
    }

    public CharBuffer append(CharBuffer bb) {
        return this.insert(this.length, bb);
    }

    void ensureCapacity(int newCapacity) {
        if (newCapacity > this.buffer.length) {
            int newSize = (this.buffer.length << 1) + 2;
            if (newCapacity > newSize) {
                newSize = newCapacity;
            }
            char[] newbuffer = new char[newSize];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.length);
            this.buffer = newbuffer;
        }
    }

    public CharBuffer insert(int offset, char[] bytes, int length) throws IndexOutOfBoundsException {
        if (offset > this.length || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.length + length);
        System.arraycopy(this.buffer, offset, this.buffer, offset + length, this.length - offset);
        System.arraycopy(bytes, 0, this.buffer, offset, length);
        this.length += length;
        return this;
    }

    public CharBuffer insert(int offset, char byteVal) throws IndexOutOfBoundsException {
        return this.insert(offset, new char[]{byteVal}, 1);
    }

    public CharBuffer insert(int offset, char[] bytes) throws IndexOutOfBoundsException {
        return this.insert(offset, bytes, bytes.length);
    }

    public CharBuffer insert(int offset, CharBuffer bb) throws IndexOutOfBoundsException {
        return this.insert(offset, bb.buffer, bb.length);
    }

    public int length() {
        return this.length;
    }

    public char getByteAt(int offset) throws IndexOutOfBoundsException {
        if (offset < 0 || offset >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[offset];
    }

    public CharBuffer clear(int offset, int count) throws IndexOutOfBoundsException {
        if (offset < 0 || count < 0 || offset + count > this.length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, offset + count, this.buffer, offset, this.length - (offset + count));
        this.length -= count;
        return this;
    }

    public CharBuffer copy(int offset, char[] source) {
        if (offset < 0 || offset + source.length > this.length) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(source, 0, this.buffer, offset, source.length);
        return this;
    }

    public static int find(char[] source, int length, char[] search, int offset) {
        while (offset + search.length <= length) {
            int i;
            for (i = 0; i < search.length && source[offset + i] == search[i]; ++i) {
            }
            if (i == search.length) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int find(char[] source, char[] search, int offset) {
        return CharBuffer.find(source, source.length, search, offset);
    }

    public int find(char[] search, int offset) {
        return CharBuffer.find(this.buffer, this.length, search, offset);
    }

    public char[] getChars() {
        char[] response = new char[this.length];
        System.arraycopy(this.buffer, 0, response, 0, this.length);
        return response;
    }

    public char[] getChars(int offset, int count) {
        char[] response = new char[count];
        System.arraycopy(this.buffer, offset, response, 0, count);
        return response;
    }
}

