/*
 * Decompiled with CFR 0.152.
 */
package com.example.editor;

import com.avaya.eclipse.plugin.Activator;
import com.example.editor.CEAttributeModel;
import com.example.editor.CEBaseAttribute;
import com.example.editor.CEChannelModel;
import com.example.editor.XMLParser;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CEPropertiesEditorUtils {
    private String selectedItem;
    private Map<String, CEAttributeModel> attributeMap = new LinkedHashMap<String, CEAttributeModel>();
    private Map<String, CEChannelModel> channelMap = new LinkedHashMap<String, CEChannelModel>();
    private Map<String, Control> attributeComponents = new HashMap<String, Control>();
    private Map<String, Control> channelComponents = new HashMap<String, Control>();
    private org.eclipse.swt.widgets.List attributeCategories;
    private org.eclipse.swt.widgets.List channelCategories;
    private XMLParser xmlParser;
    private static String[] tabs = new String[]{"Attributes", "Collaboration Bus"};
    private static CEPropertiesEditorUtils cePropertiesEditorUtils;

    public Map<String, CEAttributeModel> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, CEAttributeModel> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public Map<String, CEChannelModel> getChannelMap() {
        return this.channelMap;
    }

    public void setChannelMap(Map<String, CEChannelModel> channelMap) {
        this.channelMap = channelMap;
    }

    private CEPropertiesEditorUtils() {
    }

    public static CEPropertiesEditorUtils getInstance() {
        if (cePropertiesEditorUtils == null) {
            cePropertiesEditorUtils = new CEPropertiesEditorUtils();
        }
        return cePropertiesEditorUtils;
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(String selectedItem) {
        this.selectedItem = selectedItem;
    }

    public void onAttributeSelection(Class modelClass, Map<String, Control> controlMap, org.eclipse.swt.widgets.List categories) {
        int[] selectedItems = categories.getSelectionIndices();
        for (int loopIndex = 0; loopIndex < selectedItems.length; ++loopIndex) {
            Field[] fieldData;
            this.selectedItem = categories.getItem(selectedItems[loopIndex]);
            CEBaseAttribute ceo = modelClass.equals(CEAttributeModel.class) ? (CEBaseAttribute)this.attributeMap.get(this.selectedItem) : (CEBaseAttribute)this.channelMap.get(this.selectedItem);
            block3: for (Field f : fieldData = modelClass.getDeclaredFields()) {
                f.setAccessible(true);
                Control c = controlMap.get(f.getName());
                String val = "";
                try {
                    val = f.get(ceo) != null ? f.get(ceo).toString() : null;
                }
                catch (Exception e) {
                    Activator.log(4, 0, "Error", e);
                }
                if (c == null) continue;
                if (val == null) {
                    val = "";
                }
                if (c instanceof Text) {
                    ((Text)c).setText(val);
                    continue;
                }
                if (c instanceof Button) {
                    ((Button)c).setSelection(Boolean.valueOf(val).booleanValue());
                    continue;
                }
                if (!(c instanceof Combo)) continue;
                for (int i = 0; i < ((Combo)c).getItemCount(); ++i) {
                    if (!val.equals(((Combo)c).getItem(i))) continue;
                    ((Combo)c).select(i);
                    continue block3;
                }
            }
        }
    }

    public XMLParser getXmlParser() {
        return this.xmlParser;
    }

    public void setXmlParser(XMLParser xmlParser) {
        this.xmlParser = xmlParser;
    }

    public void updateModelFromUI(CEBaseAttribute ceo, Map<String, Control> componentMap) {
        Field[] fieldData;
        for (Field f : fieldData = ceo.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            Control c = componentMap.get(f.getName());
            try {
                if (c == null) continue;
                if (c instanceof Text) {
                    f.set(ceo, ((Text)c).getText());
                    continue;
                }
                if (c instanceof Button) {
                    f.set(ceo, "" + ((Button)c).getSelection());
                    continue;
                }
                if (!(c instanceof Combo)) continue;
                if (((Combo)c).getSelectionIndex() != -1) {
                    f.set(ceo, ((Combo)c).getItem(((Combo)c).getSelectionIndex()));
                    continue;
                }
                f.set(ceo, ((Combo)c).getItem(0));
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error updating model", e);
            }
        }
    }

    public void resetComponents(Map<String, Control> componentMap) {
        for (Control c : componentMap.values()) {
            try {
                if (c == null) continue;
                if (c instanceof Text) {
                    ((Text)c).setText("");
                    continue;
                }
                if (c instanceof Button) {
                    ((Button)c).setSelection(false);
                    continue;
                }
                if (!(c instanceof Combo)) continue;
                ((Combo)c).select(0);
            }
            catch (Exception e) {
                Activator.log(4, 0, "Error resetting components", e);
            }
        }
    }

    public void loadAttributeMap() {
        List<Object> attrs = this.xmlParser.getAllAttributesAsModel(CEAttributeModel.class);
        this.attributeMap.clear();
        for (int i = 0; i < attrs.size(); ++i) {
            CEAttributeModel ceo = (CEAttributeModel)attrs.get(i);
            this.attributeMap.put(ceo.getName(), ceo);
        }
    }

    public void loadChannelMapMap() {
        List<Object> attrs = this.xmlParser.getAllAttributesAsModel(CEChannelModel.class);
        this.channelMap.clear();
        for (int i = 0; i < attrs.size(); ++i) {
            CEChannelModel ceo = (CEChannelModel)attrs.get(i);
            this.channelMap.put(ceo.getName(), ceo);
        }
    }

    public Combo getPropertiesSelectComponent(Group ownerInfo) {
        Combo combo = new Combo((Composite)ownerInfo, 8);
        combo.add("STRING");
        combo.add("ENCRYPTED_STRING");
        return combo;
    }

    public void initXMLParser(String absolutePath) {
        this.xmlParser = new XMLParser(absolutePath);
    }

    public Composite createAttributeTab(CTabFolder cfolder) {
        Composite shell = new Composite((Composite)cfolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        shell.setLayout((Layout)gridLayout);
        shell.setBackground(new Color((Device)shell.getDisplay(), 239, 239, 239));
        Group attributeInfo = new Group(shell, 0);
        attributeInfo.setBackground(new Color((Device)attributeInfo.getDisplay(), 239, 239, 239));
        attributeInfo.setText("Attribute List");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        attributeInfo.setLayout((Layout)gridLayout);
        GridData gridData1 = new GridData(4, 2, true, false);
        gridData1.horizontalSpan = 1;
        attributeInfo.setLayoutData((Object)gridData1);
        Composite sideComposite = new Composite((Composite)attributeInfo, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        sideComposite.setLayout((Layout)gridLayout);
        Button delete = new Button(sideComposite, 0);
        delete.setLayoutData((Object)new GridData(3, 2, true, true));
        delete.setText("Delete");
        delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.xmlParser.removeNode(CEPropertiesEditorUtils.this.xmlParser.getNode(CEPropertiesEditorUtils.this.getSelectedItem(), CEAttributeModel.class));
                CEPropertiesEditorUtils.this.xmlParser.saveDocument();
                CEPropertiesEditorUtils.this.resetComponents(CEPropertiesEditorUtils.this.attributeComponents);
                CEPropertiesEditorUtils.this.reloadUI();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Button newB = new Button(sideComposite, 0);
        newB.setLayoutData((Object)new GridData(3, 2, true, true));
        newB.setText("New");
        newB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.clearAttributeItems();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.attributeCategories = new org.eclipse.swt.widgets.List((Composite)attributeInfo, 2562);
        this.attributeCategories.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.onAttributeSelection(CEAttributeModel.class, CEPropertiesEditorUtils.this.attributeComponents, CEPropertiesEditorUtils.this.attributeCategories);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.onAttributeSelection(CEAttributeModel.class, CEPropertiesEditorUtils.this.attributeComponents, CEPropertiesEditorUtils.this.attributeCategories);
            }
        });
        if (this.attributeMap.keySet().size() > 0) {
            this.attributeCategories.setItems(this.attributeMap.keySet().toArray(new String[1]));
        }
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 4;
        gridData.horizontalSpan = 1;
        int listHeight = this.attributeCategories.getItemHeight() * 12;
        Rectangle trim = this.attributeCategories.computeTrim(0, 0, 0, listHeight);
        gridData.heightHint = trim.height;
        this.attributeCategories.setLayoutData((Object)gridData);
        Group ownerInfo = new Group(shell, 0);
        ownerInfo.setText("Attribute Details");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        ownerInfo.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        ownerInfo.setLayoutData((Object)gridData);
        new Label((Composite)ownerInfo, 0).setText("Name:");
        Text attributeName = new Text((Composite)ownerInfo, 2052);
        attributeName.setLayoutData((Object)new GridData(4, 2, true, false));
        this.attributeComponents.put("name", (Control)attributeName);
        new Label((Composite)ownerInfo, 0).setText("Display Name:");
        Text attributeDisplayName = new Text((Composite)ownerInfo, 2052);
        attributeDisplayName.setLayoutData((Object)new GridData(4, 2, true, false));
        this.attributeComponents.put("displayName", (Control)attributeDisplayName);
        new Label((Composite)ownerInfo, 0).setText("Type:");
        Combo combo = this.getPropertiesSelectComponent(ownerInfo);
        combo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.attributeComponents.put("validation", (Control)combo);
        new Label((Composite)ownerInfo, 0).setText("Value:");
        Text attributeValue = new Text((Composite)ownerInfo, 2052);
        attributeValue.setLayoutData((Object)new GridData(4, 2, true, false));
        this.attributeComponents.put("value", (Control)attributeValue);
        new Label((Composite)ownerInfo, 0).setText("Help Info:");
        Text helpInfo = new Text((Composite)ownerInfo, 2052);
        helpInfo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.attributeComponents.put("helpInfo", (Control)helpInfo);
        new Label((Composite)ownerInfo, 0).setText("Is Global:");
        Button button = new Button((Composite)ownerInfo, 32);
        button.setText("");
        button.setLayoutData((Object)new GridData(4, 2, true, false));
        this.attributeComponents.put("global", (Control)button);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button.setLayoutData((Object)new GridData(4, 2, true, false));
        new Label((Composite)ownerInfo, 0).setText("Is Admin Visible:");
        Button buttonIaAdminVisible = new Button((Composite)ownerInfo, 32);
        buttonIaAdminVisible.setText("");
        this.attributeComponents.put("admin_visible", (Control)buttonIaAdminVisible);
        buttonIaAdminVisible.setLayoutData((Object)new GridData(4, 2, true, false));
        buttonIaAdminVisible.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)ownerInfo, 0).setText("Is User Changeable:");
        Button isUserChangable = new Button((Composite)ownerInfo, 32);
        isUserChangable.setText("");
        isUserChangable.setLayoutData((Object)new GridData(4, 2, true, false));
        this.attributeComponents.put("user_changeable", (Control)isUserChangable);
        isUserChangable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button enter = new Button((Composite)ownerInfo, 8);
        enter.setText("Save");
        enter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.saveAttributeItem();
            }
        });
        shell.pack();
        return shell;
    }

    public Composite createChannelTab(CTabFolder cfolder) {
        Composite shell = new Composite((Composite)cfolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        shell.setLayout((Layout)gridLayout);
        shell.setBackground(new Color((Device)shell.getDisplay(), 239, 239, 239));
        Group attributeInfo = new Group(shell, 0);
        attributeInfo.setBackground(new Color((Device)attributeInfo.getDisplay(), 239, 239, 239));
        attributeInfo.setText("Channel List");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        attributeInfo.setLayout((Layout)gridLayout);
        GridData gridData1 = new GridData(4, 2, true, false);
        gridData1.horizontalSpan = 1;
        attributeInfo.setLayoutData((Object)gridData1);
        Composite sideComposite = new Composite((Composite)attributeInfo, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        sideComposite.setLayout((Layout)gridLayout);
        Button delete = new Button(sideComposite, 0);
        delete.setLayoutData((Object)new GridData(3, 2, true, true));
        delete.setText("Delete");
        delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.xmlParser.removeNode(CEPropertiesEditorUtils.this.xmlParser.getNode(CEPropertiesEditorUtils.this.getSelectedItem(), CEChannelModel.class));
                CEPropertiesEditorUtils.this.resetComponents(CEPropertiesEditorUtils.this.channelComponents);
                CEPropertiesEditorUtils.this.reloadUI();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Button newB = new Button(sideComposite, 0);
        newB.setLayoutData((Object)new GridData(3, 2, true, true));
        newB.setText("New");
        newB.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.clearChannelItems();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.channelCategories = new org.eclipse.swt.widgets.List((Composite)attributeInfo, 2562);
        this.channelCategories.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.onAttributeSelection(CEChannelModel.class, CEPropertiesEditorUtils.this.channelComponents, CEPropertiesEditorUtils.this.channelCategories);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.onAttributeSelection(CEChannelModel.class, CEPropertiesEditorUtils.this.channelComponents, CEPropertiesEditorUtils.this.channelCategories);
            }
        });
        if (this.channelMap.keySet().size() > 0) {
            this.channelCategories.setItems(this.channelMap.keySet().toArray(new String[1]));
        }
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 4;
        gridData.horizontalSpan = 1;
        int listHeight = this.channelCategories.getItemHeight() * 12;
        Rectangle trim = this.channelCategories.computeTrim(0, 0, 0, listHeight);
        gridData.heightHint = trim.height;
        this.channelCategories.setLayoutData((Object)gridData);
        Group ownerInfo = new Group(shell, 0);
        ownerInfo.setText("Channel Details");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        ownerInfo.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        ownerInfo.setLayoutData((Object)gridData);
        new Label((Composite)ownerInfo, 0).setText("Name:");
        Text attributeName = new Text((Composite)ownerInfo, 2052);
        attributeName.setLayoutData((Object)new GridData(4, 2, true, false));
        this.channelComponents.put("name", (Control)attributeName);
        new Label((Composite)ownerInfo, 0).setText("Type:");
        Combo combo = new Combo((Composite)ownerInfo, 8);
        combo.add("ptop-single");
        combo.add("pubsub-multi");
        combo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.channelComponents.put("type", (Control)combo);
        new Label((Composite)ownerInfo, 0).setText("Listener Class:");
        Text attributeValue = new Text((Composite)ownerInfo, 2052);
        attributeValue.setLayoutData((Object)new GridData(4, 2, true, false));
        this.channelComponents.put("listenerClass", (Control)attributeValue);
        Button enter = new Button((Composite)ownerInfo, 8);
        enter.setText("Save");
        enter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CEPropertiesEditorUtils.this.saveChannelItem();
            }
        });
        shell.pack();
        return shell;
    }

    public void clearAttributeItems() {
        this.setSelectedItem(null);
        if (this.attributeCategories != null) {
            this.attributeCategories.setSelection(-1);
        }
        this.resetComponents(this.attributeComponents);
    }

    public void clearChannelItems() {
        this.setSelectedItem(null);
        if (this.channelCategories != null) {
            this.channelCategories.setSelection(-1);
        }
        this.resetComponents(this.channelComponents);
    }

    public void saveChannelItem() {
        CEChannelModel ceo = this.channelMap.get(this.getSelectedItem());
        String actualKey = null;
        if (ceo == null) {
            Activator.log(1, "Seems to be a new Item....");
            ceo = new CEChannelModel();
            this.updateModelFromUI(ceo, this.channelComponents);
            actualKey = ceo.getName();
        } else {
            actualKey = ceo.getName();
            this.updateModelFromUI(ceo, this.channelComponents);
        }
        if (actualKey != null && !actualKey.isEmpty()) {
            Document document = this.xmlParser.getDocument();
            NodeList nodeList = document.getElementsByTagName("message");
            if (nodeList == null || nodeList.getLength() == 0) {
                NodeList nodeListSMGR = document.getElementsByTagName("smgr");
                for (int i = 0; i < nodeListSMGR.getLength(); ++i) {
                    Element smgrElement = (Element)nodeListSMGR.item(i);
                    Element mesageElement = document.createElement("message");
                    smgrElement.appendChild(mesageElement);
                }
            }
            this.xmlParser.saveModel(ceo, actualKey);
            this.reloadUI();
        }
    }

    public void saveAttributeItem() {
        CEAttributeModel ceo = this.attributeMap.get(this.getSelectedItem());
        String actualKey = null;
        if (ceo == null) {
            Activator.log(1, "Seems to be a new Item....");
            ceo = new CEAttributeModel();
            this.updateModelFromUI(ceo, this.attributeComponents);
            actualKey = ceo.getName();
        } else {
            actualKey = ceo.getName();
            this.updateModelFromUI(ceo, this.attributeComponents);
        }
        if (actualKey != null && !actualKey.isEmpty()) {
            this.xmlParser.saveModel(ceo, actualKey);
            this.reloadUI();
        }
    }

    public void reloadUI() {
        this.loadAttributeMap();
        this.loadChannelMapMap();
        if (this.attributeCategories != null) {
            if (this.attributeMap.keySet().size() > 0) {
                this.attributeCategories.setItems(this.attributeMap.keySet().toArray(new String[1]));
            } else {
                this.attributeCategories.removeAll();
            }
        }
        if (this.channelCategories != null) {
            if (this.channelMap.keySet().size() > 0) {
                this.channelCategories.setItems(this.channelMap.keySet().toArray(new String[1]));
            } else {
                this.channelCategories.removeAll();
            }
        }
    }

    public CTabFolder createPartControl(Composite shell) {
        final CTabFolder folder = new CTabFolder(shell, 128);
        folder.setSize(100, 200);
        folder.setUnselectedCloseVisible(false);
        folder.setSimple(false);
        for (int i = 0; i < tabs.length; ++i) {
            CTabItem item = new CTabItem(folder, 0);
            item.setText(tabs[i]);
        }
        folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                CEPropertiesEditorUtils.this.createTabContents(folder);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                CEPropertiesEditorUtils.this.createTabContents(folder);
            }
        });
        folder.setSelection(0);
        this.createTabContents(folder);
        return folder;
    }

    public void createTabContents(CTabFolder cfolder) {
        this.selectedItem = null;
        if (cfolder.getSelectionIndex() == 0) {
            cfolder.getSelection().setControl((Control)this.createAttributeTab(cfolder));
        } else {
            cfolder.getSelection().setControl((Control)this.createChannelTab(cfolder));
        }
    }
}

