/*
 * Decompiled with CFR 0.152.
 */
package com.example.editor;

import com.avaya.eclipse.plugin.Activator;
import com.example.editor.CEAttributeInfo;
import com.example.editor.CEBaseAttribute;
import com.example.editor.Ignore;
import com.example.editor.PrimaryKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLParser {
    private XPathFactory xpf = XPathFactory.newInstance();
    private Document document = null;
    private String xmlName;

    public Document getDocument() {
        return this.document;
    }

    public XMLParser(String xmlName) {
        this.init(xmlName);
        this.xmlName = xmlName;
    }

    private void init(String xmlName) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.document = dbf.newDocumentBuilder().parse(new File(xmlName));
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error initializing XML parser", e);
        }
    }

    public Node getNode(String attributeName, Class metaAttributeClass) {
        try {
            CEAttributeInfo ceAttrInfo = null;
            if (metaAttributeClass.isAnnotationPresent(CEAttributeInfo.class)) {
                ceAttrInfo = metaAttributeClass.getAnnotation(CEAttributeInfo.class);
            }
            if (ceAttrInfo == null) {
                return null;
            }
            XPath xpath = this.xpf.newXPath();
            XPathExpression expression = xpath.compile(ceAttrInfo.attributeSearchPath().replace("{0}", attributeName));
            Node b13Node = (Node)expression.evaluate(this.document, XPathConstants.NODE);
            return b13Node;
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error getting node", e);
            return null;
        }
    }

    public void removeNode(Node node) {
        node.getParentNode().removeChild(node);
    }

    public Node addNode(Node newChild, Class metaAttributeClass) {
        try {
            CEAttributeInfo ceAttrInfo = null;
            if (metaAttributeClass.isAnnotationPresent(CEAttributeInfo.class)) {
                ceAttrInfo = metaAttributeClass.getAnnotation(CEAttributeInfo.class);
            }
            if (ceAttrInfo == null) {
                return null;
            }
            XPathExpression expression = this.xpf.newXPath().compile(ceAttrInfo.rootPath());
            Node cN = (Node)expression.evaluate(this.document, XPathConstants.NODE);
            Node firstDocImportedNode = this.document.importNode(newChild, true);
            cN.appendChild(firstDocImportedNode);
            return firstDocImportedNode;
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error adding node", e);
            return null;
        }
    }

    public Node getNewNodeFromTemplate(CEBaseAttribute ceo) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Document d = factory.newDocumentBuilder().parse(new InputSource(new StringReader(ceo.getXmlString())));
            return d.getFirstChild();
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error editing node", e);
            return null;
        }
    }

    public Node editNode(Node node, Map<String, String> dataContainer, CEBaseAttribute ceo) {
        try {
            for (Map.Entry<String, String> nodeE : ceo.getNodePathMap().entrySet()) {
                this.editNode(node, this.xpf.newXPath(), nodeE.getValue(), dataContainer.get(nodeE.getKey()));
            }
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error editing node", e);
        }
        return node;
    }

    public void saveDocument() {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.transform(new DOMSource(this.document), new StreamResult(new FileOutputStream(this.xmlName)));
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error saving document", e);
        }
    }

    private void editNode(Node node, XPath xpath, String nodePath, String destValue) {
        try {
            XPathExpression expression = xpath.compile(nodePath);
            Node cN = (Node)expression.evaluate(node, XPathConstants.NODE);
            if (cN == null) {
                XPathExpression parentExpression = xpath.compile(nodePath.substring(0, nodePath.indexOf("/text()")));
                cN = (Node)parentExpression.evaluate(node, XPathConstants.NODE);
                if (cN == null) {
                    throw new Exception("invalid base xml");
                }
                Text textNode = this.document.createTextNode(destValue);
                cN.appendChild(textNode);
                return;
            }
            cN.setNodeValue(destValue);
            cN.setNodeValue(destValue);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error editing node", e);
        }
    }

    public List<Object> getAllAttributesAsModel(Class model) {
        try {
            CEAttributeInfo ceAttrInfo = null;
            if (model.isAnnotationPresent(CEAttributeInfo.class)) {
                ceAttrInfo = model.getAnnotation(CEAttributeInfo.class);
            }
            if (ceAttrInfo == null) {
                return null;
            }
            XPath xpath = this.xpf.newXPath();
            XPathExpression expression = xpath.compile(ceAttrInfo.basePath());
            NodeList nodes = (NodeList)expression.evaluate(this.document, XPathConstants.NODESET);
            ArrayList<Object> myObjList = new ArrayList<Object>(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                myObjList.add(this.getAttributeModel(nodes.item(i), model));
            }
            return myObjList;
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error getting attributes", e);
            return null;
        }
    }

    private Object getAttributeModel(Node n, Class modelClass) {
        try {
            CEAttributeInfo ceAttrInfo = null;
            if (modelClass.isAnnotationPresent(CEAttributeInfo.class)) {
                ceAttrInfo = modelClass.getAnnotation(CEAttributeInfo.class);
            }
            if (ceAttrInfo == null) {
                return null;
            }
            Field[] fields = modelClass.getDeclaredFields();
            Object modelObject = modelClass.newInstance();
            for (Field f : fields) {
                f.setAccessible(true);
                if (f.isAnnotationPresent(Ignore.class)) continue;
                if (f.isAnnotationPresent(PrimaryKey.class)) {
                    f.set(modelObject, this.xpf.newXPath().evaluate(ceAttrInfo.attributeNamePath(), n));
                    continue;
                }
                if (f.getName().contains("cobertura")) continue;
                f.set(modelObject, this.fetchNodeValue(n, this.xpf.newXPath(), ((CEBaseAttribute)modelObject).getNodePathMap().get(f.getName())));
            }
            return modelObject;
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error getting attrbute", e);
            return null;
        }
    }

    private String fetchNodeValue(Node node, XPath xpath, String nodePath) {
        try {
            XPathExpression expression = xpath.compile(nodePath);
            Node cN = (Node)expression.evaluate(node, XPathConstants.NODE);
            if (cN == null) {
                return "";
            }
            return cN.getNodeValue();
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error fetching node value", e);
            return null;
        }
    }

    public void saveModel(Object ceo, String primaryKey) {
        HashMap<String, String> kvp = new HashMap<String, String>();
        for (Field f : ceo.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.isAnnotationPresent(Ignore.class)) continue;
            try {
                if (f.get(ceo) == null) continue;
                kvp.put(f.getName(), f.get(ceo).toString());
            }
            catch (IllegalArgumentException e) {
                Activator.log(4, 0, "Error saving model", e);
            }
            catch (IllegalAccessException e) {
                Activator.log(4, 0, "Error saving model", e);
            }
        }
        Node n = this.getNode(primaryKey, ceo.getClass());
        if (n == null) {
            n = this.getNewNodeFromTemplate((CEBaseAttribute)ceo);
            n = this.addNode(n, ceo.getClass());
        }
        this.editNode(n, kvp, (CEBaseAttribute)ceo);
        this.saveDocument();
    }
}

