/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.email;

import com.avaya.collaboration.email.ContentType;
import com.avaya.collaboration.email.EmailBodyPart;
import com.avaya.collaboration.email.EmailFactoryDelegate;
import com.avaya.collaboration.email.EmailRequest;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProviderException;

public final class EmailFactory {
    private static volatile EmailFactoryDelegate emailFactoryDelegate;
    private static String emailFactoryImplName;
    private static String serviceName;
    private static String serviceVersion;
    private static boolean junitTestInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static EmailFactoryDelegate getEmailFactoryDelegate() {
        if (emailFactoryDelegate != null) return emailFactoryDelegate;
        Class<EmailFactory> clazz = EmailFactory.class;
        synchronized (EmailFactory.class) {
            Constructor<?> clazzConstructor;
            Class<?> clazz2;
            if (!junitTestInProgress) {
                ServiceDescriptor serviceDescriptor = ServiceUtil.getServiceDescriptor();
                serviceName = serviceDescriptor.getName();
                serviceVersion = serviceDescriptor.getVersion();
            }
            try {
                clazz2 = Class.forName(emailFactoryImplName);
            }
            catch (Exception exception) {
                throw new ProviderException("forName: Failed to find delegate class for EmailFactory (" + emailFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
            }
            try {
                clazzConstructor = clazz2.getConstructor(String.class, String.class);
            }
            catch (Exception exception) {
                throw new ProviderException("getConstructor: Failed to find delegate class for EmailFactory (" + emailFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion, exception);
            }
            try {
                emailFactoryDelegate = (EmailFactoryDelegate)clazzConstructor.newInstance(serviceName, serviceVersion);
            }
            catch (InstantiationException instantiationException) {
                throw new ProviderException("newInstance(InstantiationException): Failed to find delegate class for EmailFactory (" + emailFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + instantiationException, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ProviderException("newInstance(illegalAccessException): Failed to find delegate class for EmailFactory (" + emailFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + illegalAccessException, illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ProviderException("newInstance(illegalArgumentException): Failed to find delegate class for EmailFactory (" + emailFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + illegalArgumentException, illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ProviderException("newInstance(invocationTargetException): Failed to find delegate class for EmailFactory (" + emailFactoryImplName + ") name/version=" + serviceName + "/" + serviceVersion + "\n" + invocationTargetException + " target exception=" + invocationTargetException.getMessage() + " target cause=" + invocationTargetException.getCause() + " target localized message=" + invocationTargetException.getLocalizedMessage(), invocationTargetException);
            }
            return emailFactoryDelegate;
        }
    }

    public static EmailRequest createEmailRequest() {
        return EmailFactory.getEmailFactoryDelegate().getEmailRequest();
    }

    static EmailBodyPart createBodyPart(ContentType contentType, String content) {
        return EmailFactory.getEmailFactoryDelegate().getEmailBodyPart(contentType, content);
    }

    static {
        emailFactoryImplName = "com.avaya.collaboration.email.EmailFactoryImpl";
        serviceName = null;
        serviceVersion = null;
        junitTestInProgress = false;
    }
}

