/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.lib;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lfs.LfsPointer;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class LfsPointerFilter
extends TreeFilter {
    private LfsPointer pointer;

    public LfsPointer getPointer() {
        return this.pointer;
    }

    public boolean include(TreeWalk walk) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.pointer = null;
        if (walk.isSubtree()) {
            return walk.isRecursive();
        }
        ObjectId objectId = walk.getObjectId(0);
        ObjectLoader object = walk.getObjectReader().open((AnyObjectId)objectId);
        if (object.getSize() > 1024L) {
            return false;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (ObjectStream stream = object.openStream();){
            this.pointer = LfsPointer.parseLfsPointer((InputStream)stream);
            return this.pointer != null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean shouldBeRecursive() {
        return false;
    }

    public TreeFilter clone() {
        return new LfsPointerFilter();
    }
}

