/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.businessdata.api.ClusterData;
import com.avaya.collaboration.businessdata.api.ClusterNotFoundException;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusClusterService;
import com.avaya.zephyr.platform.dal.api.objectapi.AusInstance;
import com.avaya.zephyr.platform.dal.api.objectapi.AusService;
import com.avaya.zephyr.platform.dal.api.objectapi.Cluster;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dao.AusServiceDAO;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClusterDataImpl
implements ClusterData {
    private static final int REQUIRE_NUMBER_OF_LOOKUPLOCATORS = 1;
    public static final String PORT_TO_OPEN = "PortsToOpen";
    private Logger logger = Logger.getLogger(ClusterDataImpl.class);

    protected final ClusterAttributeDAO getClusterAttributeDAO() {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        return dm.getClusterAttributeDAO();
    }

    protected final AusServiceDAO getAusServiceDAO() {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        return dm.getAusServiceDAO();
    }

    public final String getClusterAttribute(String attrName) throws NoAttributeFoundException {
        this.logger.fine((Object)("Getting attribute value for " + attrName));
        return this.getClusterAttributeDAO().getClusterAttribute(attrName);
    }

    public final List<String> getClusterAttributeList() {
        this.logger.fine((Object)"Getting the list of cluster attributes");
        return this.getClusterAttributeDAO().getClusterAttributeList();
    }

    public final String getClusterEncryptedAttribute(String attrName) throws NoAttributeFoundException {
        this.logger.fine((Object)("Getting encrypted attribute value for " + attrName));
        return this.getClusterAttributeDAO().getClusterEncryptedAttribute(attrName);
    }

    public final String getClusterName() {
        this.logger.fine((Object)"Getting cluster name for the current Avaya Breeze instance");
        return this.getClusterAttributeDAO().getClusterName();
    }

    public final String getClusterDomainName() {
        this.logger.fine((Object)"Getting cluster domain name for the current Avaya Breeze instance");
        return this.getClusterAttributeDAO().getClusterDomainName();
    }

    public final String getClusterHost() {
        this.logger.fine((Object)"Getting cluster host for the current Avaya Breeze instance");
        return this.getClusterAttributeDAO().getClusterHost();
    }

    public final String getClusterDescription() {
        this.logger.fine((Object)"Getting cluster description for the current Avaya Breeze instance");
        return this.getClusterAttributeDAO().getClusterDescription();
    }

    public final Long getClusterProfileID() {
        this.logger.fine((Object)"Getting cluster profile ID for the current Avaya Breeze instance");
        return this.getClusterAttributeDAO().getClusterProfileID();
    }

    public final String getClusterProfileName() {
        this.logger.fine((Object)"Getting cluster profile name for the current Avaya Breeze instance");
        return this.getClusterAttributeDAO().getClusterProfileName();
    }

    public final String getLusLocatorForCluster(String clusterName) throws ClusterNotFoundException {
        if (this.logger.isFineEnabled()) {
            this.logger.fine((Object)("Getting LUS Locator String for the cluster " + clusterName));
        }
        if (clusterName != null) {
            Long clusterId = this.getClusterAttributeDAO().getClusterIDByClusterName(clusterName);
            if (clusterId == null) {
                throw new ClusterNotFoundException("There is no cluster with name " + clusterName);
            }
            return this.getLookupLocatorsStr(clusterId);
        }
        throw new ClusterNotFoundException("Null value provided for cluster name");
    }

    public final Map<String, String> getLusLocatorsForInstalledService(String serviceName) throws ServiceNotFoundException {
        if (this.logger.isFineEnabled()) {
            this.logger.fine((Object)("Getting LUS Locator String for the cluster on which particular service" + serviceName + " is installed "));
        }
        if (serviceName != null) {
            boolean isServiceExists = this.checkServiceExists(serviceName);
            if (isServiceExists) {
                List<Long> clusters = this.lookforServiceInClusters(serviceName);
                HashMap<String, String> mapClusterLusLocator = new HashMap<String, String>();
                for (Long clusterId : clusters) {
                    String lookupLocatorsStr = this.getLookupLocatorsStr(clusterId);
                    String name = this.getClusterAttributeDAO().getClusterMap().get(clusterId).getName();
                    mapClusterLusLocator.put(name, lookupLocatorsStr);
                }
                return mapClusterLusLocator;
            }
            throw new ServiceNotFoundException("No service was found with name " + serviceName);
        }
        throw new ServiceNotFoundException("Null value provided for service name");
    }

    public final Map<String, String> getLusLocators() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine((Object)"Getting LUS Locator String for all clusters");
        }
        HashMap<String, String> mapClusterLusLocator = new HashMap<String, String>();
        Map<Long, Cluster> mapAllClusters = this.getClusterAttributeDAO().getClusterMap();
        for (Map.Entry<Long, Cluster> entry : mapAllClusters.entrySet()) {
            String lookupLocatorsStr = this.getLookupLocatorsStr(entry.getKey());
            String clusternName = entry.getValue().getName();
            mapClusterLusLocator.put(clusternName, lookupLocatorsStr);
        }
        return mapClusterLusLocator;
    }

    private String getLookupLocatorsStr(Long clusterId) {
        String lookupLocators = "";
        try {
            ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
            ClusterAttributeDAO clusterAttrDao = dm.getClusterAttributeDAO();
            AusInstanceDAO ausInstanceDAO = dm.getAusInstanceDAO();
            if (!this.checkPrerequisitesForLus(clusterId, clusterAttrDao)) {
                return "";
            }
            ArrayList<AusInstance> ausInstanceListoflus = new ArrayList<AusInstance>();
            ausInstanceListoflus.addAll(ausInstanceDAO.getLookUpService(clusterId));
            String lusPort = this.getGSLUSPort(clusterId);
            if (ausInstanceListoflus.size() < 1) {
                this.logger.info((Object)"getLookupLocatorsStr: the no of Breeze instances for cluster Id is less than 1");
                return "";
            }
            if (lusPort == null) {
                throw new RuntimeException("getLookupLocatorsStr: Unable to get LUS Port value for " + clusterId + " DAO might not be ready");
            }
            StringBuffer buf = new StringBuffer();
            for (AusInstance entry : ausInstanceListoflus) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(entry.getManagementAccessPointHostName());
                buf.append(":");
                buf.append(lusPort);
            }
            lookupLocators = buf.toString();
        }
        catch (Exception e) {
            this.logger.error((Object)"getLookupLocatorsStr failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        return lookupLocators;
    }

    private boolean checkPrerequisitesForLus(Long clusterId, ClusterAttributeDAO clusterAttrDao) {
        if (clusterAttrDao == null || !clusterAttrDao.getClusterIdToAttributeMap().containsKey(clusterId)) {
            this.logger.error((Object)("getLookupLocatorsStr: getClusterAttributeDAO failed, no data found for clusterId " + clusterId + " DAO might not be ready"));
            throw new RuntimeException("getLookupLocatorsStr: getClusterAttributeDAO failed, no data found for clusterId " + clusterId + " DAO might not be ready");
        }
        String isGridRequired = clusterAttrDao.getClusterIdToAttributeMap().get(clusterId).get("GridRequired").getOverrideValue();
        return isGridRequired != null && !isGridRequired.contentEquals("false");
    }

    private String getGSLUSPort(Long clusterId) {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        ClusterAttributeDAO clusterAttrDao = dm.getClusterAttributeDAO();
        try {
            if (clusterAttrDao == null) {
                this.logger.error((Object)"getGSPorts: getClusterAttributeDAO failed, DAO might not be ready");
                throw new RuntimeException("getGSPorts: Unable to get reference for ClusterAttributeDAO failed, DAO might not be ready");
            }
            String portRange = clusterAttrDao.getClusterIdToAttributeMap().get(clusterId).get(PORT_TO_OPEN).getOverrideValue();
            String[] ports = portRange.split("-");
            Integer firstPort = Integer.valueOf(ports[0].trim());
            return firstPort.toString();
        }
        catch (Exception e) {
            this.logger.error((Object)"getGSPorts failed", (Throwable)e);
            return null;
        }
    }

    private boolean checkServiceExists(String serviceName) {
        Map<Long, AusService> ausServiceList = this.getAusServiceDAO().getAllAusServicesMap();
        for (Map.Entry<Long, AusService> entry : ausServiceList.entrySet()) {
            if (!entry.getValue().getName().contentEquals(serviceName)) continue;
            return true;
        }
        return false;
    }

    private List<Long> lookforServiceInClusters(String serviceName) {
        ArrayList<Long> servicesInstalledinCluster = new ArrayList<Long>();
        Map<Long, Map<String, AusClusterService>> mapClusterService = this.getAusServiceDAO().getClusterIdToServiceMap();
        Long serviceId = this.getAusServiceDAO().getServiceIDByServiceName(serviceName);
        for (Map.Entry<Long, Map<String, AusClusterService>> entry : mapClusterService.entrySet()) {
            if (!this.checkServiceIdInClusterServiceMap(serviceId, entry.getValue())) continue;
            servicesInstalledinCluster.add(entry.getKey());
        }
        return servicesInstalledinCluster;
    }

    private boolean checkServiceIdInClusterServiceMap(Long serviceId, Map<String, AusClusterService> clusterServiceMap) {
        if (serviceId == null || clusterServiceMap == null || clusterServiceMap.size() == 0) {
            return false;
        }
        Iterator<Map.Entry<String, AusClusterService>> iterator = clusterServiceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            AusClusterService ausClusterService = iterator.next().getValue();
            if (ausClusterService == null || ausClusterService.getServiceId() == null || !ausClusterService.getServiceId().equals(serviceId)) continue;
            return true;
        }
        return false;
    }

    public final String getClusterHostByName(String clusterName) throws ClusterNotFoundException {
        this.logger.fine((Object)"getClusterHostByName: Getting cluster IP for given clusterName");
        return this.getClusterAttributeDAO().getClusterHostByName(clusterName);
    }

    public final String getClusterFqdnByClusterName(String clusterName) throws ClusterNotFoundException {
        this.logger.fine((Object)"getClusterFqdnByClusterName: Getting cluster FQDN for the given clusterName");
        return this.getClusterAttributeDAO().getClusterFqdnByClusterName(clusterName);
    }
}

