/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.businessdata.api.Attribute;
import com.avaya.collaboration.businessdata.api.InvalidAddressTypeException;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.data.api.AddressType;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.encrypt.EncryptDecrypt;
import com.avaya.zephyr.platform.dal.api.AttributeImpl;
import com.avaya.zephyr.platform.dm.AusPlatformServiceDM;
import java.util.List;

public class ServiceDataImpl
implements ServiceData {
    private static final String SUPPLIER_ID_ATTRIBUTE_NAME = "com.avaya.supplierId";
    private Logger log = Logger.getLogger(ServiceDataImpl.class);
    private String serviceName = null;
    private String serviceRelease = null;

    public ServiceDataImpl() {
    }

    public ServiceDataImpl(String name) {
        this.serviceName = name;
    }

    public ServiceDataImpl(String name, String release) {
        this.serviceName = name;
        this.serviceRelease = release;
    }

    public String getServiceAttribute(String userHandle, String serviceName, String attrName) throws NoUserFoundException, ServiceNotFoundException, NoAttributeFoundException, NoServiceProfileFoundException {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        String attribute = dm.getServiceAttribute(userHandle, serviceName, attrName);
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("Attribute: " + attribute));
        }
        if (attribute == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Attribute:" + attrName + " not found."));
            }
            return null;
        }
        return attribute;
    }

    public String getServiceAttribute(String userHandle, AddressType addressType, String serviceName, String attrName) throws NoUserFoundException, ServiceNotFoundException, NoAttributeFoundException, NoServiceProfileFoundException, InvalidAddressTypeException {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        String attribute = dm.getServiceAttribute(userHandle, addressType, serviceName, attrName);
        if (this.log.isFineEnabled()) {
            this.log.finer((Object)("Attribute: " + attribute));
        }
        if (attribute == null) {
            this.log.warn((Object)("Attribute:" + attrName + " not found."));
            return null;
        }
        return attribute;
    }

    public String getServiceAttribute(String userAddress, String attrName) throws NoUserFoundException, NoAttributeFoundException, ServiceNotFoundException, NoServiceProfileFoundException {
        return this.getServiceAttribute(userAddress, this.serviceName, attrName);
    }

    public List<String> getServiceAttributeList() throws ServiceNotFoundException {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        return dm.getServiceAttributeList(this.serviceName);
    }

    public String getGlobalServiceAttribute(String attrName) throws NoAttributeFoundException, ServiceNotFoundException {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        String attribute = dm.getServiceAttribute(this.getServiceName(), attrName);
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("Attribute: " + attribute));
        }
        if (attribute == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Attribute:" + attrName + " not found."));
            }
            return null;
        }
        return attribute;
    }

    public String getServiceAttribute(String attrName) throws NoAttributeFoundException, ServiceNotFoundException {
        return this.getGlobalServiceAttribute(attrName);
    }

    public String getServiceName() throws ServiceNotFoundException {
        return this.serviceName;
    }

    public String getServiceVersion() throws ServiceNotFoundException {
        return this.serviceRelease;
    }

    public List<String> getGlobalServiceAttributeList() throws ServiceNotFoundException {
        return null;
    }

    public String getGlobalServiceEncryptedAttribute(String attrName) throws NoAttributeFoundException, ServiceNotFoundException {
        String attrValue = null;
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        String encryptedAttr = dm.getEncryptedServiceAttribute(this.serviceName, attrName);
        if (encryptedAttr == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Encrypted Attribute: " + attrName + " not found."));
            }
            return null;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Encrypted Attribute: " + encryptedAttr + " of Service: " + this.serviceName));
        }
        try {
            attrValue = EncryptDecrypt.decrypt((String)encryptedAttr, (String)this.serviceName);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while Decrypting attribute", (Throwable)e);
        }
        return attrValue;
    }

    public String getServiceEncryptedAttribute(String attrName) throws NoAttributeFoundException, ServiceNotFoundException {
        return this.getGlobalServiceEncryptedAttribute(attrName);
    }

    public String getServiceAttribute(String userAddress, AddressType addressType, String attrName) throws NoUserFoundException, NoAttributeFoundException, ServiceNotFoundException, NoServiceProfileFoundException, InvalidAddressTypeException {
        return this.getServiceAttribute(userAddress, addressType, this.serviceName, attrName);
    }

    public final boolean isSignedService() throws ServiceNotFoundException {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        return dm.getServiceTrustStatus(this.getServiceName(), this.getServiceVersion());
    }

    public final String getSupplierId() throws ServiceNotFoundException, NoAttributeFoundException {
        AusPlatformServiceDM dm = (AusPlatformServiceDM)DMFactory.getInstance().getDataMgr(AusPlatformServiceDM.class);
        String supplierId = dm.getServiceAttribute(this.getServiceName(), SUPPLIER_ID_ATTRIBUTE_NAME);
        if (supplierId == null) {
            throw new ServiceNotFoundException("No Service found with name = " + this.getServiceName());
        }
        return supplierId;
    }

    public Attribute createAttribute() {
        return new AttributeImpl();
    }
}

