/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api.objectapi;

import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitTreeDigitNode;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitTreeNodeMatcher;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitTreeObjectNodeMatch;

public class DigitTree<E> {
    public static final int SRE_STAR_INDEX = 10;
    public static final int SRE_POUND_INDEX = 11;
    public static final int SRE_PLUS_INDEX = 12;
    public static final int SRE_WILDCARD_INDEX = 13;
    private static final char[] gdaChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '#', '+', 'x'};
    private static final Logger log = Logger.getLogger(DigitTree.class);
    private final DigitTreeDigitNode<E> root = new DigitTreeDigitNode(this);

    public int getMaxDigits() {
        return gdaChars.length;
    }

    public char getGDAChar(int i) {
        return gdaChars[i];
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public String dumpTree() {
        return this.root.dumpNode(this, "").toString();
    }

    public int nodeIndex(String digits, int depth) {
        int index;
        try {
            index = this.gdaIndex(digits.charAt(depth));
        }
        catch (IndexOutOfBoundsException e) {
            index = -1;
        }
        if (index < 0) {
            log.error((Object)("Invalid digit at depth " + depth + " in " + digits));
            throw new UnsupportedOperationException("Invalid digit");
        }
        return index;
    }

    protected int gdaIndex(char digit) {
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        if (digit == '*') {
            return 10;
        }
        if (digit == '#') {
            return 11;
        }
        if (digit == '+') {
            return 12;
        }
        if (digit == 'x' || digit == 'X') {
            return 13;
        }
        return -1;
    }

    public boolean validRouteDigits(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if ((c < '0' || c > '9') && c != '*' && c != '#' && c != '+') {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == ',' || c == '!' || c == '&' || c == '$' || c == '%') continue;
            return false;
        }
        return true;
    }

    public boolean validDigits(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int i = 0;
        char c = s.charAt(0);
        if (c == '+' || c == '*' || c == '#' || c == 'x' || c == 'X') {
            i = 1;
        }
        while (i < s.length()) {
            c = s.charAt(i);
            if ((c < '0' || c > '9') && c != 'x' && c != 'X') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int nonDigitDelimiter(String digits) {
        char c;
        int i;
        int len = digits.length();
        if (len <= 1) {
            return len;
        }
        for (i = 1; i < digits.length() && (c = digits.charAt(i)) >= '0' && c <= '9'; ++i) {
        }
        return i;
    }

    public int getWildCardIndex() {
        return 13;
    }

    public void insert(String digits, short min, short max, E object, DigitTreeNodeMatcher<E> matcher) {
        String newDigits = null;
        if (digits != null) {
            newDigits = digits.trim();
        }
        if (newDigits != null) {
            if (!this.validDigits(newDigits)) {
                log.error((Object)("Insert invalid digit string " + newDigits));
                throw new IllegalArgumentException("Invalid digit string");
            }
            if (min < newDigits.length() || max < newDigits.length() || max < min) {
                log.error((Object)("Insert " + newDigits + " invalid min/max " + min + "/" + max));
                throw new IllegalArgumentException("Invalid min/max");
            }
            this.root.insert(this, 0, newDigits, min, max, object, matcher);
            if (log.isFineEnabled()) {
                log.fine((Object)("insert(" + newDigits + "/" + min + "/" + max + ") inserted " + object));
            }
        }
    }

    public void delete(String digits, short min, short max, DigitTreeNodeMatcher<E> matcher) {
        String newDigits = null;
        if (digits != null) {
            newDigits = digits.trim();
        }
        if (!this.validDigits(newDigits)) {
            log.error((Object)("Delete invalid digits " + newDigits));
            throw new IllegalArgumentException("Invalid digit string");
        }
        this.root.delete(this, 0, newDigits, min, max, matcher);
        if (log.isFinestEnabled()) {
            log.finest((Object)("delete(" + newDigits + "/" + min + "/" + max + ") succeeded"));
        }
    }

    public void update(String digits, short min, short max, E object, DigitTreeNodeMatcher<E> matcher) {
        String newDigits = null;
        if (digits != null) {
            newDigits = digits.trim();
        }
        if (newDigits != null) {
            if (!this.validDigits(newDigits)) {
                log.error((Object)("Update invalid digits " + newDigits));
                throw new IllegalArgumentException("Invalid digit string");
            }
            if (min < newDigits.length() || max < newDigits.length() || max < min) {
                log.error((Object)("Update " + newDigits + " invalid min/max " + min + "/" + max));
                throw new IllegalArgumentException("Invalid min/max");
            }
            this.root.update(this, 0, newDigits, min, max, object, matcher);
            if (log.isFinestEnabled()) {
                log.finest((Object)("update(" + newDigits + "/" + min + "/" + max + ") updated to " + object));
            }
        }
    }

    public E findBestMatch(String digits, DigitTreeNodeMatcher<E> matcher) {
        if (!this.validRouteDigits(digits)) {
            return null;
        }
        int i = this.nonDigitDelimiter(digits);
        DigitTreeObjectNodeMatch<E> match = this.root.findBestMatch(this, 0, digits.substring(0, i), matcher);
        return match == null ? null : (E)match.getNode().getObject();
    }

    public static void setLogLevelForJUnit() {
        log.setLevel(LogLevel.INFO);
    }
}

