/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusJDBCDataSource;
import com.avaya.zephyr.platform.dal.api.objectapi.AusJDBCDataSourceKey;
import com.avaya.zephyr.platform.dao.AusExtJDBCDataSoruceResultMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AusExtJDBCDataSourceDAO
extends DataAccessObject {
    protected static final Logger LOGGER = Logger.getLogger(AusExtJDBCDataSourceDAO.class);
    protected static final String ZR_EXT_JDBC_DATASOURCE = "zr_ext_jdbc_datasource";
    protected static final String GET_DSINFO_BYPROVIDER_NAME_AND_CLUSTER = "select provider.name_version, ds.id, ds.cluster_id, ds.provider_id, ds.name, ds.jndi_name, ds.url, ds.db_server_ip, ds.db_user_name, ds.db_password, ds.validation_query, ds.custom_properties, ds.description from zr_ext_jdbc_provider provider join zr_ext_jdbc_datasource ds on provider.id = ds.provider_id";
    protected static final String GET_DSINFO_BYPROVIDER_NAME_AND_CLUSTER_DS_ID = "select provider.name_version, ds.id, ds.cluster_id, ds.provider_id, ds.name, ds.jndi_name, ds.url, ds.db_server_ip, ds.db_user_name, ds.db_password, ds.validation_query, ds.custom_properties, ds.description from zr_ext_jdbc_provider provider join zr_ext_jdbc_datasource ds on provider.id = ds.provider_id where ds.id = ?";
    private Map<Long, Map<String, Map<Long, AusJDBCDataSource>>> dataSourceMap;
    private Map<Long, AusJDBCDataSourceKey> dsIdToClusterAndProviderMap;

    public AusExtJDBCDataSourceDAO() {
        super(true);
    }

    public final List<String> getDependentTables() {
        return Arrays.asList(ZR_EXT_JDBC_DATASOURCE);
    }

    protected final Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        Map<Long, AusJDBCDataSourceKey> dsIdToClusterAndProviderMapTmp;
        Map dataSourceMapTmp;
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"init ENTER");
        }
        AusExtJDBCDataSoruceResultMapper dataSourceMapper = new AusExtJDBCDataSoruceResultMapper();
        try {
            dataSourceMapTmp = (Map)this.dataSource.executeQuery(GET_DSINFO_BYPROVIDER_NAME_AND_CLUSTER, new Object[0], (Object)dataSourceMapper);
            dsIdToClusterAndProviderMapTmp = dataSourceMapper.getDatasourceIdToClusterAndProviderNameMap();
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOGGER.error((Object)"init Error initializing AusExtJDBCDataSourceDAO", (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.dataSourceMap = dataSourceMapTmp;
            this.dsIdToClusterAndProviderMap = dsIdToClusterAndProviderMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"init EXIT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateDAO(DAOTableEvent event) {
        Long id = event.getKey();
        AusJDBCDataSource oldEntry = null;
        AusJDBCDataSource newEntry = null;
        if (event.getTableName().equals(ZR_EXT_JDBC_DATASOURCE) && event.getOperation() != null) {
            try {
                this.lock.acquireWriteLock();
                if (event.getOperation().equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                    Map<Long, AusJDBCDataSource> dsIdToDSObjectMap;
                    AusJDBCDataSourceKey ausJDBCDataSourceKey = this.dsIdToClusterAndProviderMap.get(id);
                    Map<String, Map<Long, AusJDBCDataSource>> jdbcNameToDSMap = this.dataSourceMap.get(ausJDBCDataSourceKey.getClusterId());
                    if (jdbcNameToDSMap != null && (dsIdToDSObjectMap = jdbcNameToDSMap.get(ausJDBCDataSourceKey.getJdbcProviderName())) != null) {
                        oldEntry = dsIdToDSObjectMap.remove(id);
                    }
                } else {
                    try {
                        Map<Long, AusJDBCDataSource> dsIdToObjectMap;
                        AusExtJDBCDataSoruceResultMapper dataSourceMapper = new AusExtJDBCDataSoruceResultMapper();
                        Map dataSourceMapTmp = (Map)this.dataSource.executeQuery(GET_DSINFO_BYPROVIDER_NAME_AND_CLUSTER_DS_ID, new Object[]{id}, (Object)dataSourceMapper);
                        Map<Long, AusJDBCDataSourceKey> dsIdToClusterAndProviderMapTmp = dataSourceMapper.getDatasourceIdToClusterAndProviderNameMap();
                        AusJDBCDataSourceKey ausJDBCDataSourceKey = this.getAusJDBCDataSourceKey(dsIdToClusterAndProviderMapTmp, id);
                        AusJDBCDataSource ausJDBCDataSourceToInsert = (AusJDBCDataSource)((Map)((Map)dataSourceMapTmp.get(ausJDBCDataSourceKey.getClusterId())).get(ausJDBCDataSourceKey.getJdbcProviderName())).get(id);
                        Map<String, Map<Long, AusJDBCDataSource>> jdbcNameToDSMap = this.dataSourceMap.get(ausJDBCDataSourceKey.getClusterId());
                        if (jdbcNameToDSMap == null) {
                            jdbcNameToDSMap = new ConcurrentHashMap<String, Map<Long, AusJDBCDataSource>>();
                            this.dataSourceMap.put(ausJDBCDataSourceKey.getClusterId(), jdbcNameToDSMap);
                        }
                        if ((dsIdToObjectMap = jdbcNameToDSMap.get(ausJDBCDataSourceKey.getJdbcProviderName())) == null) {
                            dsIdToObjectMap = new ConcurrentHashMap<Long, AusJDBCDataSource>();
                            jdbcNameToDSMap.put(ausJDBCDataSourceKey.getJdbcProviderName(), dsIdToObjectMap);
                        }
                        oldEntry = dsIdToObjectMap.put(id, ausJDBCDataSourceToInsert);
                        newEntry = ausJDBCDataSourceToInsert;
                        this.dsIdToClusterAndProviderMap.put(id, ausJDBCDataSourceKey);
                    }
                    catch (DMException e) {
                        LOGGER.error((Object)("Error while updating cache for change in table zr_ext_jdbc_datasource For id=" + id + " Exception:" + e.getMessage()));
                        this.reinit();
                    }
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            this.updateListeners(oldEntry, newEntry);
        }
    }

    @SMConsole(description="Get JDBC data source Information by data source name")
    public List<AusJDBCDataSource> getDataSoruceInfoByJDBCNameAndCluster(long clusterId, String jdbcProviderName) {
        Map<Long, AusJDBCDataSource> dataSourceIdToObjectMap;
        ArrayList<AusJDBCDataSource> dataSourceList = new ArrayList<AusJDBCDataSource>();
        Map<String, Map<Long, AusJDBCDataSource>> jdbcNameToDSObjectMap = this.dataSourceMap.get(clusterId);
        if (jdbcNameToDSObjectMap != null && (dataSourceIdToObjectMap = jdbcNameToDSObjectMap.get(jdbcProviderName)) != null) {
            for (AusJDBCDataSource ausJDBCDataSource : dataSourceIdToObjectMap.values()) {
                dataSourceList.add(ausJDBCDataSource);
            }
        }
        return dataSourceList;
    }

    protected AusJDBCDataSourceKey getAusJDBCDataSourceKey(Map<Long, AusJDBCDataSourceKey> dsIdToClusterAndProviderMapTmp, Long id) {
        return dsIdToClusterAndProviderMapTmp.get(id);
    }
}

