/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.EventCatalog;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventCatalogDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(EventCatalogDAO.class);
    protected static final String ZR_EVENT_CATALOG = "zr_event_catalog";
    protected static final String ZR_EVENT_SCHEMA = "zr_event_schema";
    protected static final String GET_EVENTS = "select zr_event_catalog.id, zr_event_catalog.event_version, zr_event_catalog.family,  zr_event_catalog.event_type, zr_event_catalog.style, zr_event_schema.schema_type,zr_event_schema.schema, zr_event_catalog.family_display, zr_event_catalog.event_type_display, zr_event_schema.schema from zr_event_catalog, zr_event_schema WHERE zr_event_catalog.event_schema_id = zr_event_schema.id";
    protected static final String GET_EVENT_BY_ID = "select zr_event_catalog.id, zr_event_catalog.event_version, zr_event_catalog.family,  zr_event_catalog.event_type, zr_event_catalog.style, zr_event_schema.schema_type,zr_event_schema.schema, zr_event_catalog.family_display, zr_event_catalog.event_type_display, zr_event_schema.schema from zr_event_catalog, zr_event_schema WHERE zr_event_catalog.event_schema_id = zr_event_schema.id AND zr_event_catalog.id = ?";
    protected static final String GET_EVENTS_BY_SCHEMA_ID = "select zr_event_catalog.id, zr_event_catalog.event_version, zr_event_catalog.family,  zr_event_catalog.event_type, zr_event_catalog.style, zr_event_schema.schema_type,zr_event_schema.schema, zr_event_catalog.family_display, zr_event_catalog.event_type_display, zr_event_schema.schema from zr_event_catalog, zr_event_schema WHERE zr_event_catalog.event_schema_id = zr_event_schema.id AND zr_event_catalog.event_schema_id = ?";
    private Map<Long, EventCatalog> eventCatalogMap = new ConcurrentHashMap<Long, EventCatalog>();

    public Map<Long, EventCatalog> getEventCatalogMap() {
        return this.eventCatalogMap;
    }

    protected final ResultSetMapper getEventCatalogMapper() {
        return new RSMgetEventCatalogMapper();
    }

    protected final ResultSetMapper getEventCatalogMapperByID() {
        return new ResultSetMapper(){

            public EventCatalog mapResults(ResultSet results) throws SQLException, DMException {
                EventCatalog eventCatalog = null;
                while (results.next()) {
                    eventCatalog = new EventCatalog(results.getLong("id"), results.getString("event_version"), results.getString("family"), results.getString("event_type"), results.getString("style"), results.getString("schema_type"), results.getString("schema"), results.getString("family_display"), results.getString("event_type_display"));
                }
                if (eventCatalog != null) {
                    return eventCatalog;
                }
                return null;
            }
        };
    }

    public void init() {
        Map eventCatalogTmpMap;
        try {
            Object[] params = new Object[]{};
            eventCatalogTmpMap = (Map)this.dataSource.executeQuery(GET_EVENTS, params, (Object)this.getEventCatalogMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (eventCatalogTmpMap != null) {
                this.eventCatalogMap = eventCatalogTmpMap;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ZR_EVENT_CATALOG, ZR_EVENT_SCHEMA);
    }

    protected Object getMainCollection() {
        return null;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null) {
            if (tableName.equalsIgnoreCase(ZR_EVENT_CATALOG)) {
                this.updateZrEventCatalog(operation, id);
            }
            if (tableName.equalsIgnoreCase(ZR_EVENT_SCHEMA)) {
                this.updateZrEventSchema(operation, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateZrEventCatalog(DAOReplicationEvent.OperationType operation, Long id) {
        EventCatalog oldObject = null;
        EventCatalog newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            try {
                this.lock.acquireWriteLock();
                oldObject = this.eventCatalogMap.remove(id);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                newObject = (EventCatalog)this.dataSource.executeQuery(GET_EVENT_BY_ID, new Object[]{id}, (Object)this.getEventCatalogMapperByID());
                this.lock.acquireWriteLock();
                try {
                    this.eventCatalogMap.put(id, newObject);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table zr_event_catalog " + e.getMessage()));
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateZrEventSchema(DAOReplicationEvent.OperationType operation, Long id) {
        Object oldObjects;
        Map newObjects;
        block8: {
            newObjects = null;
            oldObjects = null;
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                try {
                    newObjects = (Map)this.dataSource.executeQuery(GET_EVENTS_BY_SCHEMA_ID, new Object[]{id}, (Object)this.getEventCatalogMapper());
                    if (newObjects == null) break block8;
                    this.lock.acquireWriteLock();
                    try {
                        for (EventCatalog event : newObjects.values()) {
                            EventCatalog eventCatalog = this.eventCatalogMap.get(event.getId());
                            if (eventCatalog == null) continue;
                            eventCatalog.setEventSchemaType(event.getEventSchemaType());
                            eventCatalog.setSchema(event.getSchema());
                        }
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                catch (DMException e) {
                    this.log.error((Object)("Error while updating Cache for table zr_event_schema " + e.getMessage()));
                }
            }
        }
        if (newObjects != null || oldObjects != null) {
            this.updateListeners(oldObjects, newObjects);
        }
    }

    @SMConsole(description="Get the list of all events")
    public List<EventCatalog> getEventList() {
        ArrayList<EventCatalog> events = new ArrayList<EventCatalog>();
        for (EventCatalog event : this.eventCatalogMap.values()) {
            events.add(event);
        }
        return events;
    }

    @SMConsole(description="Get list of events of specified family")
    public List<EventCatalog> getEventDefinitions(String family) {
        ArrayList<EventCatalog> eventDefinitions = new ArrayList<EventCatalog>();
        for (EventCatalog event : this.eventCatalogMap.values()) {
            if (!family.equals(event.getFamily())) continue;
            eventDefinitions.add(event);
        }
        if (!eventDefinitions.isEmpty()) {
            return eventDefinitions;
        }
        return null;
    }

    @SMConsole(description="Get the events of specified family and type")
    public List<EventCatalog> getEventDefinitions(String family, String eventType) {
        ArrayList<EventCatalog> eventDefinitions = new ArrayList<EventCatalog>();
        for (EventCatalog event : this.eventCatalogMap.values()) {
            if (!family.equals(event.getFamily()) || !eventType.equals(event.getEventType())) continue;
            eventDefinitions.add(event);
        }
        if (!eventDefinitions.isEmpty()) {
            return eventDefinitions;
        }
        return null;
    }

    public static class RSMgetEventCatalogMapper
    implements ResultSetMapper {
        public Map<Long, EventCatalog> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, EventCatalog> eventCatalogMapTmp = new ConcurrentHashMap<Long, EventCatalog>();
            while (results.next()) {
                Long id = (Long)results.getObject("id");
                eventCatalogMapTmp.put(id, new EventCatalog(results.getLong("id"), results.getString("event_version"), results.getString("family"), results.getString("event_type"), results.getString("style"), results.getString("schema_type"), results.getString("schema"), results.getString("family_display"), results.getString("event_type_display")));
            }
            if (!eventCatalogMapTmp.isEmpty()) {
                return eventCatalogMapTmp;
            }
            return null;
        }
    }
}

