/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.MailboxDetails;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class MailboxDetailsDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(MailboxDetailsDAO.class);
    private static final String IPT_AURAMESSAGING_SUB = "IPT_AURAMESSAGING_SUB";
    private static final String GET_MAILBOX_DETAILS = "SELECT CSUSER.ID AS USERID, IPT_AURAMESSAGING_SUB.ID AS MESSAGINGSUBID, CSCOMMPROFILESET.ID AS COMMPROFILESETID, IPT_AURAMESSAGING_SUB.MAILBOXNUMBER, IPT_AURAMESSAGING_SUB.MAILBOXNUMBER AS MMID FROM CSUSER,CSCOMMPROFILESET, CSCOMMPROFILE, MESSAGINGCOMMPROFILE, IPT_AURAMESSAGING_SUB WHERE CSCOMMPROFILESET.ID=CSCOMMPROFILE.CSCOMMPROFILESETID AND CSCOMMPROFILE.ID=MESSAGINGCOMMPROFILE.ID AND MESSAGINGCOMMPROFILE.MESSSUB_ID=IPT_AURAMESSAGING_SUB.ID AND CSCOMMPROFILESET.CSUSERID=CSUSER.ID";
    private static final String GET_MAILBOX_DETAILS_BY_MAILBOX_ID = "SELECT CSUSER.ID AS USERID, IPT_AURAMESSAGING_SUB.ID AS MESSAGINGSUBID, CSCOMMPROFILESET.ID AS COMMPROFILESETID, IPT_AURAMESSAGING_SUB.MAILBOXNUMBER, IPT_AURAMESSAGING_SUB.MAILBOXNUMBER AS MMID FROM CSUSER,CSCOMMPROFILESET, CSCOMMPROFILE, MESSAGINGCOMMPROFILE, IPT_AURAMESSAGING_SUB WHERE CSCOMMPROFILESET.ID=CSCOMMPROFILE.CSCOMMPROFILESETID AND CSCOMMPROFILE.ID=MESSAGINGCOMMPROFILE.ID AND MESSAGINGCOMMPROFILE.MESSSUB_ID=IPT_AURAMESSAGING_SUB.ID AND CSCOMMPROFILESET.CSUSERID=CSUSER.ID AND IPT_AURAMESSAGING_SUB.ID=?";
    private Map<Long, List<MailboxDetails>> userIdToMailboxDetailsMap = new ConcurrentHashMap<Long, List<MailboxDetails>>();

    protected final ResultSetMapper getMailboxDetailsMapperByMailboxId() {
        return new ResultSetMapper(){

            public MailboxDetails mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    MailboxDetails mailboxDetails = new MailboxDetails(results.getLong("MESSAGINGSUBID"), results.getString("MAILBOXNUMBER"), results.getLong("USERID"));
                    return mailboxDetails;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map userIdToMailboxDetailsMapTmp;
        MailboxDetailsMapper mailboxDetailsMapper = new MailboxDetailsMapper();
        try {
            Object[] params = new Object[]{};
            userIdToMailboxDetailsMapTmp = (Map)this.dataSource.executeQuery(GET_MAILBOX_DETAILS, params, (Object)mailboxDetailsMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (userIdToMailboxDetailsMapTmp != null) {
                this.userIdToMailboxDetailsMap = userIdToMailboxDetailsMapTmp;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList("ipt_auramessaging_sub");
    }

    protected Object getMainCollection() {
        return this.userIdToMailboxDetailsMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Mailbox DAO event: " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null && tableName.equalsIgnoreCase(IPT_AURAMESSAGING_SUB)) {
            this.updateIptAuraMessagingSub(operation, id);
        }
    }

    private void updateIptAuraMessagingSub(DAOReplicationEvent.OperationType operation, Long id) {
        MailboxDetails oldObject = null;
        MailboxDetails newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            oldObject = this.handleIptAuraMessagingDelete(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            newObject = this.handleIptAuraMessagingUpdate(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            newObject = this.handleIptAuraMessagingInsert(id);
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailboxDetails handleIptAuraMessagingInsert(Long id) {
        MailboxDetails newObject;
        block8: {
            newObject = null;
            try {
                newObject = (MailboxDetails)this.dataSource.executeQuery(GET_MAILBOX_DETAILS_BY_MAILBOX_ID, new Object[]{id}, (Object)this.getMailboxDetailsMapperByMailboxId());
                if (newObject == null) break block8;
                this.lock.acquireWriteLock();
                try {
                    List<MailboxDetails> mailBoxes;
                    if (this.userIdToMailboxDetailsMap == null) {
                        this.userIdToMailboxDetailsMap = new ConcurrentHashMap<Long, List<MailboxDetails>>();
                    }
                    if ((mailBoxes = this.userIdToMailboxDetailsMap.get(newObject.getUserId())) == null || mailBoxes.isEmpty()) {
                        mailBoxes = new ArrayList<MailboxDetails>();
                        mailBoxes.add(newObject);
                        this.userIdToMailboxDetailsMap.put(newObject.getUserId(), mailBoxes);
                    } else {
                        mailBoxes.add(newObject);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table IPT_AURAMESSAGING_SUB " + e.getMessage()));
            }
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailboxDetails handleIptAuraMessagingUpdate(Long id) {
        MailboxDetails newObject;
        block7: {
            newObject = null;
            try {
                newObject = (MailboxDetails)this.dataSource.executeQuery(GET_MAILBOX_DETAILS_BY_MAILBOX_ID, new Object[]{id}, (Object)this.getMailboxDetailsMapperByMailboxId());
                if (newObject == null) break block7;
                this.lock.acquireWriteLock();
                try {
                    List<MailboxDetails> mailboxes = this.userIdToMailboxDetailsMap.get(newObject.getUserId());
                    if (mailboxes != null) {
                        MailboxDetails mailboxDetails = this.getDeletedHandle(id, mailboxes);
                        if (mailboxDetails != null) {
                            mailboxes.remove(mailboxDetails);
                        }
                        mailboxes.add(newObject);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table IPT_AURAMESSAGING_SUB " + e.getMessage()));
            }
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailboxDetails handleIptAuraMessagingDelete(Long id) {
        MailboxDetails oldObject = null;
        this.lock.acquireWriteLock();
        try {
            for (List<MailboxDetails> mailboxes : this.userIdToMailboxDetailsMap.values()) {
                oldObject = this.getDeletedHandle(id, mailboxes);
                if (oldObject == null) continue;
                mailboxes.remove(oldObject);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return oldObject;
    }

    private MailboxDetails getDeletedHandle(Long id, List<MailboxDetails> mailboxes) {
        for (MailboxDetails mailboxDetails : mailboxes) {
            if (!mailboxDetails.getMessagingSubId().equals(id)) continue;
            return mailboxDetails;
        }
        return null;
    }

    @SMConsole(description="Get mail box numbers of user ID")
    public List<String> getMailboxNumbers(Long userId) {
        ArrayList<String> mailboxNumbers = new ArrayList<String>();
        if (this.userIdToMailboxDetailsMap.get(userId) == null || this.userIdToMailboxDetailsMap.get(userId).isEmpty()) {
            return mailboxNumbers;
        }
        for (MailboxDetails mailboxDetails : this.userIdToMailboxDetailsMap.get(userId)) {
            if (StringUtils.isEmpty((CharSequence)mailboxDetails.getMailboxNumber())) continue;
            mailboxNumbers.add(mailboxDetails.getMailboxNumber());
        }
        return mailboxNumbers;
    }

    public static class MailboxDetailsMapper
    implements ResultSetMapper {
        public Map<Long, List<MailboxDetails>> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, List<MailboxDetails>> userIdToMailboxDetailsMapTmp = new ConcurrentHashMap<Long, List<MailboxDetails>>();
            while (results.next()) {
                Long id = (Long)results.getObject("USERID");
                MailboxDetails mailboxDetails = new MailboxDetails(results.getLong("MESSAGINGSUBID"), results.getString("MAILBOXNUMBER"), results.getLong("USERID"));
                ArrayList<MailboxDetails> mailboxes = (ArrayList<MailboxDetails>)userIdToMailboxDetailsMapTmp.get(id);
                if (mailboxes == null || mailboxes.isEmpty()) {
                    mailboxes = new ArrayList<MailboxDetails>();
                    mailboxes.add(mailboxDetails);
                    userIdToMailboxDetailsMapTmp.put(id, mailboxes);
                    continue;
                }
                mailboxes.add(mailboxDetails);
            }
            if (!userIdToMailboxDetailsMapTmp.isEmpty()) {
                return userIdToMailboxDetailsMapTmp;
            }
            return null;
        }
    }
}

