/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.cassandra.locator;

import com.avaya.asm.cassandra.locator.SMLocatorDAO;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.locator.SeedProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(SMSeedProvider.class);
    static final String sqlCmd = "select managementaccesspointhostname from asminstance where sm_type = 'SM';";
    static final String mgmtiaCmd = "/usr/bin/mgmtia";
    static final String[] mgmtiaCmdArgs = new String[]{"/usr/bin/mgmtia", "-t", "-A", "-c", "select managementaccesspointhostname from asminstance where sm_type = 'SM';"};

    public SMSeedProvider(Map<String, String> args) {
    }

    public List<InetAddress> getSeeds() {
        return this.getSeedsByDAO();
    }

    private List<InetAddress> getSeedsByDAO() {
        String fcn_name = "getSeedsByDAO";
        SMLocatorDAO dao = SMLocatorDAO.getInstance();
        List<String> smList = dao.getSMs();
        ArrayList<InetAddress> inetList = new ArrayList<InetAddress>(smList.size());
        for (String sm : smList) {
            try {
                inetList.add(InetAddress.getByName(sm));
            }
            catch (UnknownHostException e) {
                logger.error("getSeedsByDAO: UnknownHostException received for  " + sm, (Throwable)e);
            }
        }
        return inetList;
    }
}

