/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.CustomClassLoader;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CustomClassLoadingUtil {
    private static final Logger log = AsmLogger.getLogger(CustomClassLoadingUtil.class);
    private static final List<File> JAR_SEARCH_DIRS = Arrays.asList(new File("/opt/Avaya/CommonServerPlatform/lib/jgroups"));
    private static final String CLASS_PATH_ATTR = "Class-Path";
    private static boolean debug = false;

    public static ClassLoader createCustomClassLoader(File[] customJars) {
        HashSet<URL> allURLs = new HashSet<URL>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < customJars.length; ++i) {
            File customJar = customJars[i];
            try {
                if (customJar.exists()) {
                    sb.append(customJar.getName() + (i + 1 == customJars.length ? "" : ", "));
                    allURLs.add(customJar.getAbsoluteFile().toURI().toURL());
                    allURLs.addAll(CustomClassLoadingUtil.allURLsOf(customJar));
                    continue;
                }
                log.warn((Object)(customJar.getName() + " does not exist."));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Failed to find or read the file (" + customJar.getPath() + "): " + e + ": " + e.getCause()));
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("Custom loading jars: " + sb.toString()));
        }
        CustomClassLoader classLoader = new CustomClassLoader(allURLs.toArray(new URL[allURLs.size()]), CustomClassLoadingUtil.class.getClassLoader());
        return classLoader;
    }

    public static Object load(String className, Class<?>[] ctrArgs, Object[] ctrVal, ClassLoader classLoader) throws Exception {
        if (log.isFinestEnabled() && debug) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < ctrArgs.length; ++i) {
                sb.append(ctrArgs[i] + "=" + ctrVal[i] + (i + 1 == ctrArgs.length ? "" : "\n"));
            }
            log.finest((Object)("Trying to construct " + className + " with provided args: " + sb.toString()));
        }
        Class<?> clazz = Class.forName(className, true, classLoader);
        Constructor<?> constructor = clazz.getConstructor(ctrArgs);
        return constructor.newInstance(ctrVal);
    }

    protected static List<URL> allURLsOf(File file) {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        if (file.isDirectory()) {
            try {
                dependencies.add(file.getAbsoluteFile().toURI().toURL());
                if (log.isFinerEnabled()) {
                    log.finer((Object)("Adding directory " + file.getAbsolutePath() + " to the set"));
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Not able to make URL out of " + file.getAbsolutePath()), (Throwable)e);
            }
            return dependencies;
        }
        for (String entry : CustomClassLoadingUtil.classPathInManifest(file).split(" ")) {
            File jar;
            if (entry.equals("")) continue;
            if (entry.equals(file.getName())) {
                entry = file.getName();
            }
            if (log.isFineEnabled()) {
                log.fine((Object)(file.getName() + " depends on ~" + entry + "~"));
            }
            if ((jar = CustomClassLoadingUtil.findFile(new File(entry).getName())) == null) {
                if (!log.isFineEnabled()) continue;
                log.finer((Object)("Didn't find copy of " + entry + " anywhere"));
                continue;
            }
            try {
                if (dependencies.contains(jar.getAbsoluteFile().toURI().toURL())) {
                    if (!log.isFinerEnabled()) continue;
                    log.finer((Object)("Skipping " + jar.getAbsolutePath() + " - already in the list"));
                    continue;
                }
                if (log.isFinerEnabled()) {
                    log.finer((Object)("Adding " + jar.getAbsolutePath() + " to set"));
                }
                dependencies.add(jar.getAbsoluteFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Not able to make URL out of " + file.getAbsolutePath()), (Throwable)e);
            }
            if (file.getName().equals(entry)) continue;
            dependencies.addAll(CustomClassLoadingUtil.allURLsOf(jar));
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("Returning these URLs: " + Arrays.toString(dependencies.toArray())));
        }
        return dependencies;
    }

    private static File findFile(String name) {
        File file = null;
        for (File dir : JAR_SEARCH_DIRS) {
            if (log.isFinestEnabled()) {
                log.finest((Object)("Looking for " + name + " in " + dir.getAbsolutePath()));
            }
            if ((file = new File(dir.getAbsolutePath() + "/" + name)).exists()) {
                if (!log.isFinestEnabled()) break;
                log.finest((Object)("Found " + file.getAbsolutePath()));
                break;
            }
            file = null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String classPathInManifest(File file) {
        String classPath;
        block14: {
            classPath = "";
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                Manifest manifest = jar.getManifest();
                if (manifest == null) break block14;
                for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
                    if (!entry.getKey().toString().equals(CLASS_PATH_ATTR)) continue;
                    if (log.isFinestEnabled()) {
                        log.finest((Object)("Returning " + (String)entry.getValue()));
                    }
                    classPath = (String)entry.getValue();
                    break;
                }
            }
            catch (IOException e) {
                log.warn((Object)("Not able to read from " + file.getAbsolutePath()), (Throwable)e);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("CustomClassLoadingUtil: Error closing JAR " + file), (Throwable)e);
                    }
                }
            }
        }
        return classPath;
    }
}

