/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.jni.JniExec;
import com.avaya.asm.jni.JniExecException;
import com.avaya.asm.jni.JniExecFilePointer;
import com.avaya.common.logging.client.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;

public class ProcessExecUtils {
    private static final Logger log = AsmLogger.getLogger(ProcessExecUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status spawnCapture(String[] args, Map<String, String> envMap) {
        String fcn_name = "spawnCapture";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        JniExec jniExec = new JniExec();
        JniExecFilePointer fp = null;
        Integer waitStatus = null;
        String output = null;
        if (isFiner) {
            log.finer((Object)("spawnCapture: enter, args=" + Arrays.toString(args) + ", environ.length=" + (envMap == null ? 0 : envMap.size())));
        }
        String[] environ = ProcessExecUtils.createEnvironArray(envMap);
        try {
            fp = jniExec.popene(args, environ, "r");
        }
        catch (JniExecException e) {
            String message = "spawnCapture: popene() for failed for command " + Arrays.toString(args);
            log.error((Object)message, e.getCause());
            return new Status(null, message, e);
        }
        if (isFinest) {
            log.finest((Object)"spawnCapture: pOpene() succeeded");
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(fp.getFD());
            bis = new BufferedInputStream(fis);
            isr = new InputStreamReader(bis);
            br = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            try {
                while (true) {
                    String line = br.readLine();
                    if (isFinest) {
                        log.finest((Object)("spawnCapture: readLine=" + line));
                    }
                    if (line == null) {
                        output = sb.toString();
                        break;
                    }
                    sb.append(line);
                    sb.append('\n');
                }
            }
            catch (IOException e) {
                String message = "spawnCapture: br.readLine threw IOException";
                log.error((Object)message, (Throwable)e);
                Status status = new Status(null, message, e);
                String method = null;
                try {
                    if (br != null) {
                        method = "br.close()";
                        br.close();
                    }
                    if (isr != null) {
                        method = "isr.close()";
                        isr.close();
                    }
                    if (bis != null) {
                        method = "bis.close()";
                        bis.close();
                    }
                    if (fis != null) {
                        method = "fis.close()";
                        fis.close();
                    }
                }
                catch (IOException e2) {
                    log.error((Object)("spawnCapture: " + method + " failed with IOException: "), (Throwable)e2);
                }
                try {
                    waitStatus = jniExec.pclose(fp);
                }
                catch (JniExecException e3) {
                    String message2 = "spawnCapture: jniExec.pclose() threw JniExecException";
                    log.error((Object)message2, (Throwable)e3);
                    return new Status(null, message2, e3);
                }
                if (isFinest) {
                    log.finest((Object)("spawnCapture: waitStatus=" + waitStatus));
                }
                return status;
            }
        }
        finally {
            String method = null;
            try {
                if (br != null) {
                    method = "br.close()";
                    br.close();
                }
                if (isr != null) {
                    method = "isr.close()";
                    isr.close();
                }
                if (bis != null) {
                    method = "bis.close()";
                    bis.close();
                }
                if (fis != null) {
                    method = "fis.close()";
                    fis.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("spawnCapture: " + method + " failed with IOException: "), (Throwable)e);
            }
            try {
                waitStatus = jniExec.pclose(fp);
            }
            catch (JniExecException e) {
                String message = "spawnCapture: jniExec.pclose() threw JniExecException";
                log.error((Object)message, (Throwable)e);
                return new Status(null, message, e);
            }
            if (isFinest) {
                log.finest((Object)("spawnCapture: waitStatus=" + waitStatus));
            }
        }
        if (isFiner) {
            log.finer((Object)("spawnCapture: leave, waitStatus=" + waitStatus));
        }
        return new Status(waitStatus, output, null);
    }

    public static String[] createEnvironArray(Map<String, String> envMap) {
        if (envMap == null) {
            return null;
        }
        String[] environ = new String[envMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            environ[i] = entry.getKey() + '=' + entry.getValue();
            ++i;
        }
        return environ;
    }

    public static class Status {
        private Integer waitStatus;
        private String output;
        private Throwable cause;

        public Status(Integer waitStatus, String output, Throwable cause) {
            this.waitStatus = waitStatus;
            this.output = output;
            this.cause = cause;
        }

        public Integer getWaitStatus() {
            return this.waitStatus;
        }

        public void setWaitStatus(Integer waitStatus) {
            this.waitStatus = waitStatus;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String output) {
            this.output = output;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public void setCause(Throwable cause) {
            this.cause = cause;
        }

        public String toString() {
            return "Status [waitStatus=" + this.waitStatus + ", output=" + this.output + ", cause=" + this.cause + "]";
        }
    }
}

