/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DeviceDataAPI;
import com.avaya.asm.datamgr.dao.cassandra.CassandraDAOFactory;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.ustore.DeviceDataDAO;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.DeviceDataKey;
import com.avaya.ustore.objectapi.DeviceDataRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DeviceDataDM
implements DeviceDataAPI {
    private final Logger log = AsmLogger.getLogger(DeviceDataDM.class);
    private CassandraDAOFactory<DeviceDataDAO> deviceDataDAOFactory = new CassandraDAOFactory();
    protected final SortByTimestampComparator sorter = new SortByTimestampComparator();

    private DeviceDataDAO getDeviceDataDAO() throws DMException {
        String fcn_name = "getDeviceDataDAO";
        DeviceDataDAO dao = this.deviceDataDAOFactory.getDAOInstance(null, DeviceDataDAO.class);
        if (dao == null) {
            String msg = "getDeviceDataDAO: DeviceDataDAO Instance failed.";
            this.log.error((Object)msg);
            throw new DMException(msg);
        }
        return dao;
    }

    @Override
    public List<DeviceDataRecord> getDeviceData(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle, String dataName) throws DMException {
        String fcn_name = "getDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceData: enter with keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle + ", dataName = " + dataName));
        }
        if (keyspace == null) {
            String message = "getDeviceData: We got bad data: keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle + ", dataName = " + dataName;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceData(keyspace, acpId, dataCategory, deviceHandle, dataName);
        if (isFiner) {
            this.log.finer((Object)("getDeviceData: leave with keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle + ", dataName = " + dataName + ", ddrList = " + ddrList));
        }
        return ddrList;
    }

    @Override
    public List<DeviceDataRecord> getDeviceDataRecordsForSmEm(UserStoreKeyspace keyspace, Long acpId, String dataCategory, Integer limit) throws DMException {
        String fcn_name = "getDeviceDataRecordsForSmEm";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSmEm: enter with keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", limit = " + limit));
        }
        if (keyspace == null) {
            String message = "getDeviceDataRecordsForSmEm: We got bad data: keyspace = " + keyspace + ". Also, acpId = " + acpId + ", dataCategory = " + dataCategory + ", limit = " + limit;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceDataRecordsForSmEm(keyspace, acpId, dataCategory, limit);
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSmEm: leave with keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", limit = " + limit + ", ddrList = " + ddrList));
        }
        return ddrList;
    }

    @Override
    public List<DeviceDataRecord> getDeviceDataRecordsForSMGR(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle) throws DMException {
        String fcn_name = "getDeviceDataRecordsForSMGR";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSMGR: enter with keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle));
        }
        if (keyspace == null) {
            String message = "getDeviceDataRecordsForSMGR: We got bad data: keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceDataForSpecificEndpointFamily(keyspace, acpId, dataCategory, deviceHandle);
        Collections.sort(ddrList, this.sorter);
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSMGR: leave with ddrList = " + ddrList));
        }
        return ddrList;
    }

    @Override
    public List<DeviceDataRecord> getDeviceDataWithNoValues(UserStoreKeyspace keyspace, long acpId) throws DMException {
        String fcn_name = "getDeviceDataWithNoValues";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataWithNoValues: enter with keyspace = " + keyspace + ", acpId = " + acpId));
        }
        if (keyspace == null) {
            String message = "getDeviceDataWithNoValues: We got bad data: keyspace = " + keyspace + ", acpId = " + acpId;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        List<DeviceDataRecord> ddrList = dDAO.getDeviceDataWithNoValues(keyspace, acpId);
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataWithNoValues: leave with keyspace = " + keyspace + ", acpId = " + acpId + ", ddrList = " + ddrList));
        }
        return ddrList;
    }

    @Override
    public void deleteDeviceData(UserStoreKeyspace keyspace, Collection<DeviceDataKey> ddrCollection, boolean isAtomic) throws DMException {
        String fcn_name = "deleteDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceData: enter with keyspace = " + keyspace + ", ddrCollection = " + ddrCollection + ", isAtomic = " + isAtomic));
        }
        if (keyspace == null) {
            String message = "deleteDeviceData: We got bad data: keyspace = " + keyspace + ", ddrCollection = " + ddrCollection;
            this.log.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.deleteDeviceData(keyspace, ddrCollection, isAtomic);
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceData: leave with keyspace = " + keyspace + ", ddrCollection = " + ddrCollection + ", isAtomic = " + isAtomic));
        }
    }

    @Override
    public void setDeviceData(Collection<DeviceDataRecord> ddrCollection, boolean isAtomic) throws DMException {
        String fcn_name = "setDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setDeviceData: enter with ddrCollection = " + ddrCollection + ", isAtomic = " + isAtomic));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setDeviceData(ddrCollection, isAtomic);
        if (isFiner) {
            this.log.finer((Object)("setDeviceData: leave with ddrCollection = " + ddrCollection + ", isAtomic = " + isAtomic));
        }
    }

    @Override
    public void setDeviceDataTimestamp(DeviceDataKey deviceDataKey, long timestamp) throws DMException {
        String fcn_name = "setDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp: enter with deviceDataKey = " + deviceDataKey + ", timestamp = " + timestamp));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setDeviceDataTimestamp(deviceDataKey, timestamp);
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp: leave with deviceDataKey = " + deviceDataKey + ", timestamp = " + timestamp));
        }
    }

    @Override
    public void setDeviceDataTimestamp(Collection<DeviceDataRecord> ddrCollection, long timestamp, boolean isAtomic) throws DMException {
        String fcn_name = "setDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp: enter with ddrCollection = " + ddrCollection + ", timestamp = " + timestamp + ", isAtomic = " + isAtomic));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setDeviceDataTimestamp(ddrCollection, timestamp, isAtomic);
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp: leave with ddrCollection = " + ddrCollection + ", timestamp = " + timestamp + ", isAtomic = " + isAtomic));
        }
    }

    @Override
    public void getDistinctAcpIdsFromKeyspace(UserStoreKeyspace keyspace, Collection<Long> distinctAcpIdList) throws DMException {
        String fcn_name = "getDistinctAcpIdsFromKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDistinctAcpIdsFromKeyspace: enter with keyspace = " + keyspace));
        }
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.getDistinctAcpIdsFromKeyspace(keyspace, distinctAcpIdList);
        if (isFiner) {
            this.log.finer((Object)("getDistinctAcpIdsFromKeyspace: leave with distinctAcpIdList = " + distinctAcpIdList + ", size = " + distinctAcpIdList.size()));
        }
    }

    public boolean getBatchStatementsArePreferred(CassandraConnectionInfo cConnInfo) throws DMException {
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        return dDAO.getBatchStatementsArePreferred();
    }

    public void setBatchStatementsArePreferred(boolean batchStatementsArePreferred, CassandraConnectionInfo cConnInfo) throws DMException {
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        dDAO.setBatchStatementsArePreferred(batchStatementsArePreferred);
    }

    @Override
    public void deleteDeviceDataForAcpId(UserStoreKeyspace keyspace, long acpId) throws DMException {
        DeviceDataDAO dDAO = this.getDeviceDataDAO();
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "deleteDeviceDataForAcpId";
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceDataForAcpId: ENTER. keyspace " + keyspace.getName() + ", acpId = " + acpId));
        }
        dDAO.deleteDeviceDataForAcpId(keyspace, acpId, true);
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceDataForAcpId: LEAVE. keyspace " + keyspace.getName() + ", acpId = " + acpId));
        }
    }

    @Override
    public void moveDeviceData(long acpId, UserStoreKeyspace oldKS, UserStoreKeyspace newKS) throws DMException {
        String fcn_name = "moveDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("moveDeviceData: enter, acpId=" + acpId + ", oldKeyspace=" + oldKS + ", newKeyspace=" + newKS));
        }
        if (oldKS.equals(newKS)) {
            if (isFiner) {
                this.log.finer((Object)("moveDeviceData: leave, oldKeyspace == newKeyspace: " + oldKS));
            }
            return;
        }
        List<DeviceDataRecord> devices = null;
        try {
            devices = this.getDeviceData(oldKS, acpId, null, null, null);
        }
        catch (DMException e) {
            this.log.error((Object)("moveDeviceData: DMException thrown by getDeviceData for keyspace=" + oldKS), (Throwable)e);
            throw e;
        }
        if (devices == null) {
            if (isFiner) {
                this.log.finer((Object)("moveDeviceData: LEAVE - devices is null so no devices for acpId " + acpId + ", oldKeyspace " + oldKS));
                return;
            }
        } else if (isFinest) {
            this.log.finest((Object)("moveDeviceData: num devices read is " + devices.size()));
        }
        if (devices != null && !devices.isEmpty()) {
            ArrayList<DeviceDataRecord> ddrlist = new ArrayList<DeviceDataRecord>();
            ArrayList<DeviceDataKey> ddkList = new ArrayList<DeviceDataKey>();
            for (DeviceDataRecord oldDdr : devices) {
                DeviceDataKey oldDdk = oldDdr.getKey();
                DeviceDataKey ddk = new DeviceDataKey(oldDdk.getAsmCommProfileId(), oldDdk.getDataCategory(), oldDdk.getDeviceHandle(), oldDdk.getDataName(), newKS);
                DeviceDataRecord newDdr = new DeviceDataRecord(ddk, oldDdr.getOwnerCsUserId(), oldDdr.getCreatedDateTime(), oldDdr.getUpdateDateTime(), oldDdr.getDataValue());
                ddrlist.add(newDdr);
                ddkList.add(oldDdk);
            }
            try {
                this.setDeviceData(ddrlist, true);
            }
            catch (DMException e) {
                this.log.error((Object)("moveDeviceData: DMException thrown by deviceDataDM.setDeviceData for acpId=" + acpId + ", ddrlist.size=" + ddrlist.size()), (Throwable)e);
                throw e;
            }
            try {
                this.deleteDeviceData(oldKS, ddkList, true);
            }
            catch (DMException e) {
                this.log.error((Object)("moveDeviceData: DMException thrown by deviceDataDM.deleteDeviceData for acpId=" + acpId + ", keyspace=" + oldKS), (Throwable)e);
                throw e;
            }
        }
        if (isFiner) {
            this.log.finer((Object)("moveDeviceData, leave, device data moved for acpId " + acpId + " to newKeyspace " + newKS));
        }
    }

    class SortByTimestampComparator
    implements Comparator<DeviceDataRecord> {
        SortByTimestampComparator() {
        }

        @Override
        public int compare(DeviceDataRecord ddRecord1, DeviceDataRecord ddRecord2) {
            Long ddrTimestamp1 = ddRecord1.getUpdateDateTime();
            Long ddrTimestamp2 = ddRecord2.getUpdateDateTime();
            return Long.compare(ddrTimestamp1, ddrTimestamp2);
        }
    }
}

