/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmStorageCluster;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AsmStorageClusterDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(AsmStorageClusterDAO.class);
    protected Map<Long, AsmStorageCluster> storageClusterMap = new HashMap<Long, AsmStorageCluster>();
    private final List<String> dependentTables = new ArrayList<String>();
    protected static final String getStorageClustersQuery = "SELECT id, name FROM asm_storage_cluster";
    protected static final String getStorageClusterByIdQuery = "SELECT id, name FROM asm_storage_cluster WHERE id=?";
    private static final ResultSetMapper storageClusterMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, AsmStorageCluster> map = new HashMap<Long, AsmStorageCluster>();
            while (rs.next()) {
                AsmStorageCluster sc = AsmStorageClusterDAO.createStorageCluster(rs);
                map.put(sc.getId(), sc);
            }
            return map;
        }
    };
    private static final ResultSetMapper storageClusterByIdMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            AsmStorageCluster sc = null;
            if (rs.next()) {
                sc = AsmStorageClusterDAO.createStorageCluster(rs);
            }
            return sc;
        }
    };

    public AsmStorageClusterDAO() {
        super(true);
        this.dependentTables.add("asm_storage_cluster");
    }

    protected static ResultSetMapper getMapper() {
        return storageClusterMapper;
    }

    protected static ResultSetMapper getIdMapper() {
        return storageClusterByIdMapper;
    }

    private static AsmStorageCluster createStorageCluster(ResultSet rs) throws SQLException {
        Long id = rs.getLong("id");
        String name = rs.getString("name");
        return new AsmStorageCluster(id, name);
    }

    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + AsmStorageClusterDAO.class.getSimpleName()));
        }
        this._init();
    }

    protected synchronized void _init() {
        Map storageClusterMapTMP;
        try {
            storageClusterMapTMP = (Map)this.dataSource.executeQuery(getStorageClustersQuery, new Object[0], AsmStorageClusterDAO.getMapper());
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.storageClusterMap = storageClusterMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String fcn_name = "updateDAO";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (isFiner) {
            this.log.finer((Object)("updateDAO: enter, operation=" + (Object)((Object)operation) + ", tableName=" + tableName + ", id=" + id));
        }
        AsmStorageCluster oldCluster = null;
        AsmStorageCluster newCluster = null;
        boolean lockHeld = false;
        try {
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                try {
                    newCluster = (AsmStorageCluster)this.dataSource.executeQuery(getStorageClusterByIdQuery, params, storageClusterByIdMapper);
                }
                catch (DMException e) {
                    this.log.error((Object)("updateDAO: DMException reading asm_storage_cluster id=" + id + ", re-initializing DAO"), (Throwable)e);
                    this.reinit();
                    if (!this.okay()) {
                        this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                    }
                    if (lockHeld) {
                        this.lock.releaseWriteLock();
                        lockHeld = false;
                    }
                    return;
                }
                if (newCluster != null && isFinest) {
                    this.log.finest((Object)("updateDAO: retrieved new cluster " + newCluster));
                }
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldCluster = this.storageClusterMap.get(id);
            if (oldCluster != null) {
                if (newCluster != null) {
                    this.storageClusterMap.put(id, newCluster);
                    if (isFinest) {
                        this.log.finest((Object)("updateDAO: replaced oldCluster=" + oldCluster + " with newCLuster=" + newCluster));
                    }
                } else {
                    this.storageClusterMap.remove(id);
                    if (isFinest) {
                        this.log.finest((Object)("updateDAO: removed oldCluster=" + oldCluster));
                    }
                }
            } else if (newCluster != null) {
                this.storageClusterMap.put(id, newCluster);
                if (isFinest) {
                    this.log.finest((Object)("updateDAO: added newCluster=" + newCluster));
                }
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
        }
        this.updateListeners(oldCluster, newCluster);
        if (isFiner) {
            this.log.finer((Object)"updateDAOleave, update successful");
        }
    }

    @Override
    public List<String> getDependentTables() {
        return this.dependentTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsmStorageCluster getStorageClusterById(long id) {
        this.lock.acquireReadLock();
        try {
            AsmStorageCluster asmStorageCluster = this.storageClusterMap.get(id);
            return asmStorageCluster;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all SM Storage Clusters.")
    public Map<Long, AsmStorageCluster> getStorageClusters() {
        this.lock.acquireReadLock();
        try {
            Map<Long, AsmStorageCluster> map = Collections.unmodifiableMap(this.storageClusterMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.storageClusterMap;
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

