/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmRecoveryIntf;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.AsmSettings;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.OldNewDataDiffs;
import com.avaya.asm.datamgr.dao.jdbc.JDBCBasedDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class DataAccessObject
extends DataMgr
implements GenericAlarmRecoveryIntf {
    private static final Logger log = AsmLogger.getLogger(DataAccessObject.class);
    protected JDBCBasedDAO dataSource;
    protected final ConcurrentLinkedQueue<DAOTableEvent> eventQueue = new ConcurrentLinkedQueue();

    public DataAccessObject() {
    }

    public DataAccessObject(boolean supportsListeners) {
        super(supportsListeners);
    }

    public String getDBURL() {
        return "jdbc:postgresql://localhost/asm?ssl";
    }

    public void setDataSource(JDBCBasedDAO dataSource) {
        this.dataSource = dataSource;
    }

    public final void queueUpdate(DAOTableEvent tableEvent) {
        this.eventQueue.add(tableEvent);
    }

    public final void processEventQueue() {
        int size = this.eventQueue.size();
        if (size == 0) {
            return;
        }
        if (size >= this.numChangesBeforeReinit()) {
            log.info((Object)("Reinitializing " + this.getClass().getSimpleName() + " instead of processing " + size + " events separately"));
            this.eventQueue.clear();
            this.reinit();
        } else {
            if (log.isFinerEnabled()) {
                log.finer((Object)("Processing " + size + " messages separately because " + this.getClass().getSimpleName() + " didn't get to " + this.numChangesBeforeReinit()));
            }
            while (!this.eventQueue.isEmpty()) {
                this.updateDAO((DAOTableEvent)this.eventQueue.remove());
            }
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)("Processing complete for " + size + " events!"));
        }
    }

    protected String logTag(DAOReplicationEvent.OperationType operation, String tableName, long id) {
        return this.getClass().getSimpleName() + ".updateDAO(" + (Object)((Object)operation) + " " + tableName + " " + id + "): ";
    }

    public abstract void updateDAO(DAOTableEvent var1);

    public abstract List<String> getDependentTables();

    @Override
    public boolean preAlarmAttemptRecovery(GenericAlarm alarm) {
        log.finer((Object)("Attempting to correct before alarming: " + alarm));
        return this.isCorrected(alarm);
    }

    @Override
    public boolean postAlarmAttemptRecovery(GenericAlarm alarm) {
        log.finer((Object)("Attempting to correct after alarming: " + alarm));
        return this.isCorrected(alarm);
    }

    protected boolean isCorrected(GenericAlarm alarm) {
        try {
            if (this.failed()) {
                this.reinit();
            }
            if (this.okay()) {
                return true;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Caught an exception on re-init attempt for " + this.getClass().getSimpleName()), (Throwable)e);
        }
        return false;
    }

    @Override
    public int numChangesBeforeReinit() {
        int size = 0;
        Object mainCollection = this.getMainCollection();
        if (mainCollection != null) {
            if (mainCollection instanceof Map) {
                size = this.getMapSize((Map)mainCollection);
            } else if (mainCollection instanceof Collection) {
                size = ((Collection)mainCollection).size();
            }
        }
        int reinitVal1 = (int)((double)size * AsmSettings.getMinThresholdContiguousEventsForReinit());
        int reinitVal2 = AsmSettings.getMinContiguousEventsForReinit();
        if (log.isFinerEnabled()) {
            log.finer((Object)("numChangesBeforeReinit: " + this.getClass().getSimpleName() + ": " + size + "; max of: " + reinitVal1 + " vs " + reinitVal2));
        }
        return Math.max(reinitVal1, reinitVal2);
    }

    protected final int getMapSize(Map mainCollection) {
        boolean hasNestedMap;
        int curSize = 0;
        Iterator valIter = mainCollection.values().iterator();
        boolean bl = hasNestedMap = valIter.hasNext() ? valIter.next() instanceof Map : false;
        if (!hasNestedMap) {
            curSize = mainCollection.size();
        } else {
            for (Object nestedMap : mainCollection.values()) {
                if (!(nestedMap instanceof Map)) continue;
                curSize += this.getMapSize((Map)nestedMap);
            }
        }
        return curSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataMgr.Status reinit() {
        List<OldNewDataDiffs> diffList;
        if (log.isFineEnabled()) {
            log.fine((Object)(this.getClass().getSimpleName() + ": Reinitializing now..."));
            if (!this.eventQueue.isEmpty()) {
                log.fine((Object)(this.getClass().getSimpleName() + ": Purging eventQueue of " + this.eventQueue.size() + " events because we are reinitializing"));
            }
        }
        this.eventQueue.clear();
        if (this.getListeners().isEmpty()) {
            this.init();
            if (log.isFinerEnabled()) {
                log.finer((Object)(this.getClass().getSimpleName() + ".reinit(): DB work complete; no listeners, so no diff work"));
            }
            return this.getStatus();
        }
        Object oldData = this.getMainCollection();
        this.init();
        Object newData = this.getMainCollection();
        if (log.isFinerEnabled()) {
            log.finer((Object)(this.getClass().getSimpleName() + ".reinit(): DB work complete; starting diff work"));
        }
        try {
            this.lock.acquireReadLock();
            diffList = this.compareOldNewData(oldData, newData);
        }
        finally {
            this.lock.releaseReadLock();
        }
        ArrayList<Object> oldList = new ArrayList<Object>();
        ArrayList<Object> newList = new ArrayList<Object>();
        for (OldNewDataDiffs diff : diffList) {
            if (diff.isEmpty()) continue;
            oldList.add(diff.getOldValue());
            newList.add(diff.getNewValue());
        }
        if (log.isFinerEnabled()) {
            log.finer((Object)(this.getClass().getSimpleName() + ".reinit(): Diff list built; sending to DMListeners"));
        }
        this.updateListeners(oldList, newList);
        if (log.isFinerEnabled()) {
            log.finer((Object)(this.getClass().getSimpleName() + ".reinit(): DMListener notification complete"));
        }
        return this.getStatus();
    }

    protected abstract Object getMainCollection();

    protected List<OldNewDataDiffs> compareOldNewData(Object oldData, Object newData) {
        List<OldNewDataDiffs> diffList = new ArrayList<OldNewDataDiffs>();
        if (oldData == null) {
            return diffList;
        }
        long preProcess = System.currentTimeMillis();
        if (oldData instanceof Map) {
            diffList = this.getDiffFromMap((Map)oldData, (Map)newData);
        } else if (oldData instanceof Collection) {
            diffList = this.getDiffFromList((Collection)oldData, (Collection)newData);
        } else {
            log.warn((Object)("compareOldNewData: " + oldData.getClass().getSimpleName() + " type not supported"));
        }
        long postProcess = System.currentTimeMillis();
        if (diffList.size() > 0 && log.isFinerEnabled()) {
            log.finer((Object)(this.getClass().getSimpleName() + ": compareOldNewData: Found " + diffList.size() + " diffs that will implicitly be updated for their listeners; Took " + (postProcess - preProcess) / 1000L + " seconds to generate diff list."));
            if (log.isFinestEnabled()) {
                log.finest((Object)(this.getClass().getSimpleName() + ": compareOldNewData: They are: " + diffList));
            }
        }
        return diffList;
    }

    private List<OldNewDataDiffs> getDiffFromList(Collection<?> oldList, Collection<?> newList) {
        ArrayList<OldNewDataDiffs> oldNewDiffs = new ArrayList<OldNewDataDiffs>();
        HashMap classMap = new HashMap();
        oldNewDiffs.addAll(this.getDiffFromList(oldList, newList, classMap, true));
        oldNewDiffs.addAll(this.getDiffFromList(newList, oldList, classMap, false));
        if ((oldList.size() > 10000 || newList.size() > 10000) && log.isInfoEnabled()) {
            log.info((Object)(this.getClass().getSimpleName() + ": Very large diff list, consider moving to a Map for efficiency"));
        }
        return oldNewDiffs;
    }

    private Method getObjects_getId_Method(Map<Class<?>, Method> map, Object o) {
        Class<?> clazz = o.getClass();
        Method m_getId = null;
        if (!map.containsKey(clazz)) {
            try {
                m_getId = clazz.getMethod("getId", null);
            }
            catch (Exception e) {
                log.warn((Object)("getDiffFromList: Missing getId() method from " + clazz.getSimpleName() + ", using equals comparison."));
            }
            map.put(clazz, m_getId);
        }
        return map.get(clazz);
    }

    private List<OldNewDataDiffs> getDiffFromList(Collection<?> outerList, Collection<?> innerList, Map<Class<?>, Method> classMap, boolean treatAsDelete) {
        ArrayList<OldNewDataDiffs> oldNewDiffs = new ArrayList<OldNewDataDiffs>();
        Method m_getId_old = null;
        Method m_getId_new = null;
        for (Object oldData : outerList) {
            if (oldData == null) continue;
            m_getId_old = this.getObjects_getId_Method(classMap, oldData);
            Class<?> oldDataClass = oldData.getClass();
            boolean foundInBothLists = false;
            for (Object newData : innerList) {
                if (newData == null) continue;
                m_getId_new = this.getObjects_getId_Method(classMap, newData);
                Class<?> newDataClass = newData.getClass();
                if (!newDataClass.equals(oldDataClass)) continue;
                if (m_getId_old != null && m_getId_new != null) {
                    try {
                        Object oldId = m_getId_old.invoke(oldData, (Object[])null);
                        Object newId = m_getId_new.invoke(newData, (Object[])null);
                        if (oldId == null || !oldId.equals(newId)) continue;
                        foundInBothLists = true;
                        if (!treatAsDelete || oldData.equals(newData)) break;
                        oldNewDiffs.add(new OldNewDataDiffs(oldData, newData));
                        break;
                    }
                    catch (Exception e) {
                        log.error((Object)("getDiffFromList: Error invoking getId() for " + newDataClass), (Throwable)e);
                        continue;
                    }
                }
                if (!oldData.equals(newData)) continue;
                foundInBothLists = true;
            }
            if (foundInBothLists) continue;
            if (treatAsDelete) {
                oldNewDiffs.add(new OldNewDataDiffs(oldData, null));
                continue;
            }
            oldNewDiffs.add(new OldNewDataDiffs(null, oldData));
        }
        return oldNewDiffs;
    }

    protected final List<OldNewDataDiffs> getDiffFromMap(Map<?, ?> oldMap, Map<?, ?> newMap) {
        ArrayList<OldNewDataDiffs> diffList = new ArrayList<OldNewDataDiffs>();
        boolean isNestedMap = false;
        for (Map.Entry<?, ?> oldEntry : oldMap.entrySet()) {
            Object oldValue = oldEntry.getValue();
            isNestedMap = oldValue instanceof Map;
            if (oldValue instanceof Collection) {
                log.warn((Object)("compareOldNewData: Composite collection not supported for comparison.  Skipping for " + this.getClass().getSimpleName()));
                break;
            }
            if (isNestedMap) {
                diffList.addAll(this.getDiffFromMap((Map)oldValue, (Map)newMap.get(oldEntry.getKey())));
                continue;
            }
            if (newMap.containsKey(oldEntry.getKey())) {
                Object newValue = newMap.get(oldEntry.getKey());
                if (oldValue == null) {
                    if (newValue == null) continue;
                    diffList.add(new OldNewDataDiffs(oldValue, newValue));
                    continue;
                }
                if (oldValue.equals(newValue)) continue;
                diffList.add(new OldNewDataDiffs(oldValue, newValue));
                continue;
            }
            diffList.add(new OldNewDataDiffs(oldValue, null));
        }
        if (!isNestedMap) {
            for (Map.Entry<?, ?> newEntry : newMap.entrySet()) {
                if (oldMap.containsKey(newEntry.getKey())) continue;
                diffList.add(new OldNewDataDiffs(null, newEntry.getValue()));
            }
        }
        return diffList;
    }
}

