/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ResolvedLocation;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.ResolvedIPAddress;
import com.avaya.asm.datamgr.objectapi.ResolvedName;
import com.avaya.asm.datamgr.objectapi.ResolvedNameChangeObj;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class HostNameDAO
extends DataAccessObject {
    protected final Logger log = AsmLogger.getLogger(HostNameDAO.class);
    protected Map<Long, ResolvedName> resolvedMap = new ConcurrentHashMap<Long, ResolvedName>();
    protected Map<Long, Long> ipToIdMap = new ConcurrentHashMap<Long, Long>();
    protected Map<String, ResolvedName> fqdnMap = new ConcurrentHashMap<String, ResolvedName>();
    protected Map<IPAddress, CopyOnWriteArraySet<ResolvedName>> ipAddressMap = new ConcurrentHashMap<IPAddress, CopyOnWriteArraySet<ResolvedName>>();
    protected Map<Long, List<String>> entityFQDNMap = new ConcurrentHashMap<Long, List<String>>();
    protected Map<String, CopyOnWriteArraySet<Long>> fqdnEntityMap = new ConcurrentHashMap<String, CopyOnWriteArraySet<Long>>();
    protected List<ResolvedName> ttlList = new CopyOnWriteArrayList<ResolvedName>();
    protected static final String getHostNameResolutions = "SELECT id, fqdn FROM asmhostnameresolution";
    protected static final String getHostNameResolution = "SELECT id, fqdn FROM asmhostnameresolution WHERE id = ?";
    protected static final String getHostNameResolutionIPs = "SELECT id, hostnameresolution_id, ipaddress, portnumber, transportprotocol, priority, weight FROM asmhostnameresolutionip";
    protected static final String getHostNameResolutionIPsForName = "SELECT id, hostnameresolution_id, ipaddress, portnumber, transportprotocol, priority, weight FROM asmhostnameresolutionip WHERE hostnameresolution_id = ?";
    protected static final String getHostNameResolutionIPsById = "SELECT id, hostnameresolution_id, ipaddress, portnumber, transportprotocol, priority, weight FROM asmhostnameresolutionip WHERE id = ?";
    protected final ResultSetMapper resolutionMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, ResolvedName> resolvedMap = new ConcurrentHashMap<Long, ResolvedName>();
            while (rs.next()) {
                long id = rs.getLong("id");
                ResolvedName resolved = new ResolvedName(id, rs.getString("fqdn").toLowerCase());
                resolvedMap.put(id, resolved);
            }
            return resolvedMap;
        }
    };
    protected final ResultSetMapper resolutionIPMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, ResolvedIPAddress> resolvedIPMap = new ConcurrentHashMap<Long, ResolvedIPAddress>();
            while (rs.next()) {
                long id = rs.getLong("id");
                ResolvedIPAddress resolved = new ResolvedIPAddress(id, rs.getLong("hostnameresolution_id"), rs.getString("ipaddress"), rs.getInt("portnumber"), rs.getString("transportprotocol"), rs.getInt("priority"), rs.getInt("weight"));
                resolvedIPMap.put(id, resolved);
            }
            return resolvedIPMap;
        }
    };

    public HostNameDAO() {
        super(true);
    }

    public Map<Long, ResolvedName> getResolvedMap() {
        return Collections.unmodifiableMap(this.resolvedMap);
    }

    @Override
    protected Object getMainCollection() {
        return this.resolvedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        ConcurrentHashMap<String, ResolvedName> fqdnMapTMP;
        Map resolvedMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + HostNameDAO.class.getSimpleName()));
        }
        ConcurrentHashMap<Long, Long> ipToIdMapTMP = new ConcurrentHashMap<Long, Long>();
        ConcurrentHashMap<IPAddress, CopyOnWriteArraySet<ResolvedName>> ipAddressMapTMP = new ConcurrentHashMap<IPAddress, CopyOnWriteArraySet<ResolvedName>>();
        try {
            Object[] params = new Object[]{};
            resolvedMapTMP = (Map)this.dataSource.executeQuery(getHostNameResolutions, params, this.resolutionMapper);
            Map resolvedIPMapTMP = (Map)this.dataSource.executeQuery(getHostNameResolutionIPs, params, this.resolutionIPMapper);
            for (ResolvedIPAddress resolvedIP : resolvedIPMapTMP.values()) {
                ipToIdMapTMP.put(resolvedIP.getId(), resolvedIP.getHostnameresolution_id());
                long hostnameresolution_id = resolvedIP.getHostnameresolution_id();
                if (resolvedMapTMP.containsKey(hostnameresolution_id)) {
                    ResolvedName resolvedName = (ResolvedName)resolvedMapTMP.get(hostnameresolution_id);
                    this.addIPAddress(resolvedName, resolvedIP, ipAddressMapTMP);
                    continue;
                }
                this.log.error((Object)("reinit(): no hostnameresolution " + hostnameresolution_id + " for asmhostnameresolutionip " + resolvedIP.getId()));
            }
            fqdnMapTMP = new ConcurrentHashMap<String, ResolvedName>();
            for (ResolvedName resolvedName : resolvedMapTMP.values()) {
                fqdnMapTMP.put(resolvedName.getFqdn(), resolvedName);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.resolvedMap = resolvedMapTMP;
                this.ipToIdMap = ipToIdMapTMP;
                this.fqdnMap = fqdnMapTMP;
                this.ipAddressMap = ipAddressMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        boolean locked = false;
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(HostNameDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        ResolvedName oldName = null;
        ResolvedName newName = null;
        this.lock.acquireWriteLock();
        locked = true;
        try {
            if (tableName.equals("asmhostnameresolution")) {
                oldName = this.resolvedMap.remove(id);
                if (oldName != null) {
                    String oldFQDN = oldName.getFqdn();
                    this.removeFQDN(oldFQDN, true);
                    if (this.fqdnEntityMap.get(oldFQDN) != null) {
                        oldName.setId(null);
                        oldName.setTtlExpiration(0L);
                        this.addToTtlList(oldName, this.ttlList);
                    }
                } else if (operation == DAOReplicationEvent.OperationType.DELETE) {
                    this.log.error((Object)"Received DELETE for a non-existent hostnameresolution");
                    return;
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getHostNameResolution, params, this.resolutionMapper);
                    if (map.size() != 1) {
                        throw new DMException("updateDAO: read " + map.size() + " ResolvedNames(" + id + ") from database");
                    }
                    newName = (ResolvedName)map.get(id);
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("Retrieved new ResolvedName " + newName));
                    }
                    this.removeFQDN(newName.getFqdn(), true);
                    this.resolvedMap.put(id, newName);
                    this.fqdnMap.put(newName.getFqdn(), newName);
                    Map ipMap = (Map)this.dataSource.executeQuery(getHostNameResolutionIPsForName, params, this.resolutionIPMapper);
                    for (ResolvedIPAddress resolvedIP : ipMap.values()) {
                        this.addIPAddress(newName, resolvedIP, this.ipAddressMap);
                    }
                }
            } else if (tableName.equals("asmhostnameresolutionip")) {
                Long resId = this.ipToIdMap.remove(id);
                Object[] params = new Object[]{id};
                Map ipMap = null;
                ResolvedIPAddress newAddress = null;
                if (resId != null && (oldName = this.resolvedMap.get(resId)) != null) {
                    ResolvedIPAddress oldAddress = oldName.remove(id);
                    if (oldAddress != null) {
                        String oldIP = oldAddress.getIpaddress();
                        boolean remove = true;
                        for (ResolvedIPAddress address : oldName.getAddresses()) {
                            if (!IPAddress.areEqual(address.getIpaddress(), oldIP)) continue;
                            remove = false;
                            break;
                        }
                        if (remove) {
                            this.removeNameFromReverseLookup(oldName, oldIP);
                        }
                    }
                    if (operation == DAOReplicationEvent.OperationType.UPDATE) {
                        ipMap = (Map)this.dataSource.executeQuery(getHostNameResolutionIPsById, params, this.resolutionIPMapper);
                        if (ipMap == null || ipMap.get(id) == null) {
                            throw new DMException("Data does not exist for" + (Object)((Object)operation) + " event");
                        }
                        newAddress = (ResolvedIPAddress)ipMap.get(id);
                        newName = this.resolvedMap.get(newAddress.getHostnameresolution_id());
                        if (newName == null || !oldName.getFqdn().equalsIgnoreCase(newName.getFqdn())) {
                            // empty if block
                        }
                    }
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    if (ipMap == null) {
                        ipMap = (Map)this.dataSource.executeQuery(getHostNameResolutionIPsById, params, this.resolutionIPMapper);
                        if (ipMap == null || ipMap.get(id) == null) {
                            throw new DMException("Data does not exist for" + (Object)((Object)operation) + " event");
                        }
                        newAddress = (ResolvedIPAddress)ipMap.get(id);
                        newName = this.resolvedMap.get(newAddress.getHostnameresolution_id());
                    }
                    if (newName == null) {
                        throw new DMException("Data does not exist for" + (Object)((Object)operation) + " event");
                    }
                    this.addIPAddress(newName, newAddress, this.ipAddressMap);
                    this.ipToIdMap.put(newAddress.getId(), newAddress.getHostnameresolution_id());
                }
            }
        }
        catch (DMException e) {
            this.log.error((Object)("Error updating " + HostNameDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        ResolvedNameChangeObj oldNameChangeObj = new ResolvedNameChangeObj(oldName, tableName);
        ResolvedNameChangeObj newNameChangeObj = new ResolvedNameChangeObj(newName, tableName);
        this.updateListeners(oldNameChangeObj, newNameChangeObj);
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(HostNameDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmhostnameresolution");
        list.add("asmhostnameresolutionip");
        return list;
    }

    public ResolvedName getResolvedName(String fqdn) {
        if (fqdn == null) {
            return null;
        }
        this.lock.acquireReadLock();
        try {
            ResolvedName resolvedName = this.fqdnMap.get(fqdn.toLowerCase());
            return resolvedName;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public ResolvedName getResolvedNameProvisionedOnly(String fqdn) {
        if (fqdn == null) {
            return null;
        }
        ResolvedName resolvedName = this.getResolvedName(fqdn = fqdn.toLowerCase());
        if (resolvedName == null) {
            return null;
        }
        ResolvedName resolvedNameProvisioned = new ResolvedName(resolvedName.getId(), fqdn, resolvedName.getUseRFC3263());
        List<ResolvedIPAddress> addresses = resolvedName.getAddresses();
        for (ResolvedIPAddress address : addresses) {
            if (address.getId() == null) continue;
            resolvedNameProvisioned.addResolvedIP(address);
        }
        return resolvedNameProvisioned.getAddresses().isEmpty() ? null : resolvedNameProvisioned;
    }

    @SMConsole(description="Get all provisioned ResolvedNames.")
    public Map<String, ResolvedName> getAllResolvedNames() {
        this.lock.acquireReadLock();
        try {
            Map<String, ResolvedName> map = Collections.unmodifiableMap(this.fqdnMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private boolean removeFQDN(String fqdn, boolean removeProvisioned) {
        String lookupFqdn = fqdn.toLowerCase();
        this.removeFromTtlList(lookupFqdn);
        ResolvedName name = this.fqdnMap.get(lookupFqdn);
        if (name != null) {
            if (name.getId() != null && !removeProvisioned) {
                if (this.log.isFineEnabled()) {
                    this.log.fine((Object)("removeFQDN() not removing provisioned data for " + fqdn));
                }
                return false;
            }
            for (ResolvedIPAddress address : name.getAddresses()) {
                this.removeNameFromReverseLookup(name, address.getIpaddress());
            }
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("removeFQDN() removing " + fqdn));
            }
            this.fqdnMap.remove(lookupFqdn);
        }
        return true;
    }

    private void addIPAddress(ResolvedName name, ResolvedIPAddress address, Map<IPAddress, CopyOnWriteArraySet<ResolvedName>> map) {
        name.addResolvedIP(address);
        try {
            IPAddress ipAddr = IPAddress.parseIPAddr(address.getIpaddress());
            CopyOnWriteArraySet<ResolvedName> names = map.get(ipAddr);
            if (names == null) {
                names = new CopyOnWriteArraySet();
                map.put(ipAddr, names);
            }
            names.add(name);
        }
        catch (ParseException e) {
            this.log.error((Object)("addIPAddress: bad address: " + address.getIpaddress()));
        }
    }

    private void removeNameFromReverseLookup(ResolvedName name, String address) {
        try {
            IPAddress ipAddr = IPAddress.parseIPAddr(address);
            Set names = this.ipAddressMap.get(ipAddr);
            if (names != null) {
                names.remove(name);
                if (names.size() == 0) {
                    this.ipAddressMap.remove(ipAddr);
                }
            }
        }
        catch (ParseException e) {
            this.log.error((Object)("removeNameFromReverseLookup: bad address " + address));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSIPEntityAddresses(Long entityId, String fqdn, boolean isFqdn2, List<ResolvedLocation> addressList, boolean useRFC3263, long ttl) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("setSIPEntityAddresses(entity=" + entityId + ", fqdn=" + fqdn + ", isFqdn2=" + isFqdn2 + ", useRFC3263=" + useRFC3263 + ", ttl=" + ttl + ") to " + addressList));
        }
        this.lock.acquireWriteLock();
        try {
            if (entityId != null) {
                this.updateEntityFQDNMapping(entityId, fqdn, isFqdn2);
            }
            if (fqdn == null) {
                return;
            }
            ResolvedName name = this.fqdnMap.get(fqdn.toLowerCase());
            if (name != null) {
                if (name.getId() != null) {
                    if (this.log.isFineEnabled()) {
                        this.log.fine((Object)("setSIPEntityAddresses(entity=" + entityId + ") not replacing provisioned data"));
                    }
                    return;
                }
                ArrayList<ResolvedIPAddress> removed = new ArrayList<ResolvedIPAddress>();
                ArrayList<ResolvedIPAddress> newAddresses = new ArrayList<ResolvedIPAddress>();
                removed.addAll(name.getAddresses());
                for (ResolvedLocation resolvedLocation : addressList) {
                    ResolvedIPAddress resolvedIP = new ResolvedIPAddress(resolvedLocation.getIpaddress().toString(), resolvedLocation.getPort(), resolvedLocation.getTransport());
                    if (removed.contains(resolvedIP)) {
                        removed.remove(resolvedIP);
                        continue;
                    }
                    newAddresses.add(resolvedIP);
                }
                for (ResolvedIPAddress resolvedIPAddress : removed) {
                    name.remove(resolvedIPAddress);
                    this.removeNameFromReverseLookup(name, resolvedIPAddress.getIpaddress());
                }
                for (ResolvedIPAddress resolvedIPAddress : newAddresses) {
                    this.addIPAddress(name, resolvedIPAddress, this.ipAddressMap);
                }
                CopyOnWriteArrayList<ResolvedName> newTtl = new CopyOnWriteArrayList<ResolvedName>(this.ttlList);
                newTtl.remove(name);
                name.setTtlExpiration(ttl);
                this.addToTtlList(name, newTtl);
                this.ttlList = newTtl;
            } else {
                for (ResolvedName ttlName : this.ttlList) {
                    if (!ttlName.getFqdn().equalsIgnoreCase(fqdn)) continue;
                    name = ttlName;
                    break;
                }
                if (name == null) {
                    name = new ResolvedName(fqdn.toLowerCase(), useRFC3263, ttl);
                    this.addToTtlList(name, this.ttlList);
                } else {
                    CopyOnWriteArrayList<ResolvedName> newTtl = new CopyOnWriteArrayList<ResolvedName>(this.ttlList);
                    newTtl.remove(name);
                    name.setTtlExpiration(ttl);
                    this.addToTtlList(name, newTtl);
                    this.ttlList = newTtl;
                }
                if (addressList.size() != 0) {
                    for (ResolvedLocation address : addressList) {
                        ResolvedIPAddress resolved = new ResolvedIPAddress(address.getIpaddress().toString(), address.getPort(), address.getTransport());
                        this.addIPAddress(name, resolved, this.ipAddressMap);
                    }
                    if (this.log.isFineEnabled()) {
                        this.log.fine((Object)("setSIPEntityAddresses(entity=" + entityId + ", fqdn=" + fqdn + ") storing " + name));
                    }
                    this.fqdnMap.put(name.getFqdn(), name);
                }
            }
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("setSIPEntityAddresses(entity=" + entityId + ", fqdn=" + fqdn + ") result is " + this.fqdnMap.get(name.getFqdn())));
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    private void addToTtlList(ResolvedName name, List<ResolvedName> ttlList) {
        int index = 0;
        Long newTime = name.getTTLExpiration();
        for (ResolvedName ttlName : ttlList) {
            if (newTime < ttlName.getTTLExpiration()) {
                ttlList.add(index, name);
                return;
            }
            ++index;
        }
        ttlList.add(name);
    }

    private ResolvedName removeFromTtlList(String fqdn) {
        ResolvedName name = null;
        for (ResolvedName ttlName : this.ttlList) {
            if (!ttlName.getFqdn().equals(fqdn)) continue;
            name = ttlName;
            break;
        }
        if (name != null) {
            this.ttlList.remove(name);
        }
        return name;
    }

    public void deleteEntity(Long entityId) {
        this.lock.acquireWriteLock();
        try {
            this.removeEntityFqdnMapping(entityId, false);
            this.removeEntityFqdnMapping(entityId, true);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void updateEntityFQDNMapping(Long entityId, String fqdn, boolean isFqdn2) {
        if (entityId == null) {
            return;
        }
        this.removeEntityFqdnMapping(entityId, isFqdn2);
        this.addEntityFqdnMapping(entityId, fqdn, isFqdn2);
    }

    private void addEntityFqdnMapping(long entityId, String fqdn, boolean isFqdn2) {
        int index;
        if (fqdn == null) {
            return;
        }
        List<String> fqdnList = this.entityFQDNMap.get(entityId);
        int n = index = isFqdn2 ? 1 : 0;
        if (fqdnList == null) {
            fqdnList = new ArrayList<String>(2);
            fqdnList.add(null);
            fqdnList.add(null);
            this.entityFQDNMap.put(entityId, fqdnList);
        }
        fqdnList.set(index, fqdn);
        this.addFqdnEntityMapping(fqdn, entityId);
    }

    private void removeEntityFqdnMapping(long entityId, boolean isFqdn2) {
        List<String> fqdnList = this.entityFQDNMap.get(entityId);
        if (fqdnList == null) {
            return;
        }
        int index = isFqdn2 ? 1 : 0;
        String oldFqdn = fqdnList.get(index);
        if (oldFqdn != null) {
            fqdnList.set(index, null);
            String otherFqdn = fqdnList.get(1 - index);
            if (otherFqdn == null) {
                this.entityFQDNMap.remove(entityId);
            }
            if (!oldFqdn.equals(otherFqdn)) {
                this.removeFqdnEntityMapping(oldFqdn, entityId);
            }
        }
    }

    private void removeFqdnEntityMapping(String fqdn, long entityId) {
        if (fqdn == null) {
            return;
        }
        Set entities = this.fqdnEntityMap.get(fqdn);
        if (entities != null) {
            entities.remove(entityId);
            if (entities.isEmpty()) {
                this.fqdnEntityMap.remove(fqdn);
                this.removeFQDN(fqdn, false);
            }
        }
    }

    private void addFqdnEntityMapping(String fqdn, long entityId) {
        if (fqdn == null) {
            return;
        }
        CopyOnWriteArraySet<Long> entities = this.fqdnEntityMap.get(fqdn);
        if (entities == null) {
            entities = new CopyOnWriteArraySet();
            this.fqdnEntityMap.put(fqdn, entities);
        }
        entities.add(entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResolvedName> getResolvedNameByAddress(String address) {
        HashSet<ResolvedName> names = new HashSet<ResolvedName>();
        this.lock.acquireReadLock();
        try {
            if (address != null) {
                try {
                    IPAddress ipAddr = IPAddress.parseIPAddr(address);
                    if (this.ipAddressMap.containsKey(ipAddr)) {
                        names.addAll((Collection<ResolvedName>)this.ipAddressMap.get(ipAddr));
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("getResolvedNameByAddress(" + address + ") returned " + names));
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return names;
    }

    public List<ResolvedName> getSIPEntityAddressesByTTL() {
        this.lock.acquireReadLock();
        try {
            List<ResolvedName> list = Collections.unmodifiableList(this.ttlList);
            return list;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get the reverse lookup map")
    public Map<IPAddress, CopyOnWriteArraySet<ResolvedName>> getIPAddressMap() {
        this.lock.acquireReadLock();
        try {
            Map<IPAddress, CopyOnWriteArraySet<ResolvedName>> map = Collections.unmodifiableMap(this.ipAddressMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get the FQDN lookup map")
    public Map<String, ResolvedName> getFQDNMap() {
        this.lock.acquireReadLock();
        try {
            Map<String, ResolvedName> map = Collections.unmodifiableMap(this.fqdnMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get the entity FQDN map")
    public Map<Long, List<String>> getEntityFQDNMap() {
        this.lock.acquireReadLock();
        try {
            Map<Long, List<String>> map = Collections.unmodifiableMap(this.entityFQDNMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get the FQDN entity map")
    public Map<String, CopyOnWriteArraySet<Long>> getFQDNEntityMap() {
        this.lock.acquireReadLock();
        try {
            Map<String, CopyOnWriteArraySet<Long>> map = Collections.unmodifiableMap(this.fqdnEntityMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setLogLevelForJUnit() {
        this.log.setLevel(LogLevel.INFO);
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

