/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.LocalSipObjectDAO;
import com.avaya.asm.datamgr.objectapi.LocalCommProfileSet;
import com.avaya.asm.datamgr.objectapi.LocalObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class LocalCommProfileSetDAO
extends LocalSipObjectDAO {
    static boolean isBranchFlag = DMUtilities.isBranch();
    private String selectBase = "SELECT set.id, asm.id AS asmid FROM cscommprofileset set, cscommprofile cs, asmcommprofile asm";
    private String selectBase_SM = this.selectBase + ", asmusercommunityassign uca";
    private String selectBase_BSM = this.selectBase + ", asminstance ai";
    private String whereBase = " WHERE cs.cscommprofilesetid = set.id AND asm.id = cs.id";
    private String whereBase_SM = this.whereBase + " AND uca.asmusercommunity_id = asm.usercommunity_id AND uca.asminstance_id = ?";
    private String whereBase_BSM = this.whereBase + " AND asm.survivability_server_id = ai.sipentity_id AND ai.id = ?";
    private String filterNotDeletedUsers = " AND set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ")";
    private String getLocalIDs_SM = this.selectBase_SM + this.whereBase_SM + this.filterNotDeletedUsers;
    private String getLocalIDs_BSM = this.selectBase_BSM + this.whereBase_BSM + this.filterNotDeletedUsers;
    protected String getLocalIDsQuery = isBranchFlag ? this.getLocalIDs_BSM : this.getLocalIDs_SM;
    private String getDeletedByUserId_SM = "SELECT u.isdeleted, set.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, asmusercommunityassign uca WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND uca.asmusercommunity_id = asm.usercommunity_id AND uca.asminstance_id = ? AND u.id = ?";
    private String getDeletedByUserId_BSM = "SELECT u.isdeleted, set.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, asminstance ai WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND asm.survivability_server_id = ai.sipentity_id AND ai.id=? AND u.id = ?";
    protected String getDeletedByUserIdQuery = isBranchFlag ? this.getDeletedByUserId_BSM : this.getDeletedByUserId_SM;
    private String filterNotDeletedUser = " AND set.csuserid = u.id AND u.isdeleted = false";
    private String isLocal_SM = this.selectBase_SM + ", csuser u" + this.whereBase_SM + this.filterNotDeletedUser;
    private String isLocal_BSM = this.selectBase_BSM + ", csuser u" + this.whereBase_BSM + this.filterNotDeletedUser;
    protected String isLocalQuery = (isBranchFlag ? this.isLocal_BSM : this.isLocal_SM) + " AND asm.id = ?";

    @Override
    protected LocalObject construct(long id) {
        return new LocalCommProfileSet(id);
    }

    @Override
    protected String getMainTable() {
        return "cscommprofileset";
    }

    public Collection<Long> getLocalCommProfileSetIDsCopy() {
        ArrayList<Long> retVal = new ArrayList<Long>();
        this.lock.acquireReadLock();
        try {
            retVal.addAll(this.mainCollection.values());
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retVal;
    }

    @SMConsole(description="Print a list of all local CommProfileSet IDs.")
    public Collection<Long> getLocalCommProfileSetIDs() {
        this.lock.acquireReadLock();
        try {
            Collection<Long> collection = Collections.unmodifiableCollection(this.mainCollection.values());
            return collection;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected String getLocalIDsQuery() {
        return this.getLocalIDsQuery;
    }

    @Override
    protected String isLocalQuery() {
        return this.isLocalQuery;
    }

    @Override
    protected String getDeletedByUserIdQuery() {
        return this.getDeletedByUserIdQuery;
    }

    public static void main(String[] args) {
        LocalCommProfileSetDAO dao = new LocalCommProfileSetDAO();
        dao.printQueries();
    }
}

