/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.GlobalDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.loadrulekeys.CacFields;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.GlobalParm;
import com.avaya.asm.datamgr.objectapi.Location;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={CacFields.class})
public class LocationDAO
extends DataAccessObject {
    protected static final Logger log = AsmLogger.getLogger(LocationDAO.class);
    protected static boolean ignoreSDP = false;
    protected Map<Long, Location> locationIdMap = new HashMap<Long, Location>();
    protected Map<String, Location> locationNameMap = new HashMap<String, Location>();
    protected Map<String, Location> ldnMap = new HashMap<String, Location>();
    protected boolean loadCACFields = false;
    protected static String getLocations = "SELECT id, name, dpt_in_survivable_mode, listed_directory_number, dpt_fs_sipentity_id FROM routingorigination";
    protected static String getLocation = getLocations + " WHERE id = ?";
    protected static final ResultSetMapper locationMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            boolean cacFields;
            HashMap<Long, Location> locationMap = new HashMap<Long, Location>();
            boolean bl = cacFields = rs.getMetaData().getColumnCount() != 5;
            while (rs.next()) {
                long id = rs.getLong("id");
                String listedDirectoryNumber = rs.getString("listed_directory_number");
                if (listedDirectoryNumber != null) {
                    boolean plus = listedDirectoryNumber.startsWith("+");
                    listedDirectoryNumber = listedDirectoryNumber.replaceAll("\\D", "");
                    if (plus) {
                        listedDirectoryNumber = "+" + listedDirectoryNumber;
                    }
                }
                if (cacFields) {
                    Object value = rs.getObject("cac_tot_bwidth_allow");
                    Long totalBW = value == null ? null : new Long(((Integer)value).intValue());
                    value = ignoreSDP ? null : rs.getObject("cac_normal_bwidth_video");
                    Long multimediaBW = value == null ? null : new Long(((Integer)value).intValue());
                    long avgBW = rs.getInt("cac_avg_bwidth_percall");
                    String units = rs.getString("cac_avg_bwidth_percall_uom");
                    if ("Mbit/sec".equals(units)) {
                        avgBW *= 1000L;
                    } else if ("Gbit/sec".equals(units)) {
                        avgBW *= 1000000L;
                    } else if ("Tbit/sec".equals(units)) {
                        avgBW *= 1000000000L;
                    }
                    if (totalBW != null || multimediaBW != null) {
                        units = rs.getString("cac_tot_bwidth_allow_uom");
                        if ("Mbit/sec".equals(units)) {
                            if (totalBW != null) {
                                totalBW = totalBW * 1000L;
                            }
                            if (multimediaBW != null) {
                                multimediaBW = multimediaBW * 1000L;
                            }
                        } else if ("Gbit/sec".equals(units)) {
                            if (totalBW != null) {
                                totalBW = totalBW * 1000000L;
                            }
                            if (multimediaBW != null) {
                                multimediaBW = multimediaBW * 1000000L;
                            }
                        } else if ("Tbit/sec".equals(units)) {
                            if (totalBW != null) {
                                totalBW = totalBW * 1000000000L;
                            }
                            if (multimediaBW != null) {
                                multimediaBW = multimediaBW * 1000000000L;
                            }
                        }
                    }
                    locationMap.put(id, new Location(id, rs.getString("name"), totalBW, multimediaBW, ignoreSDP ? true : rs.getBoolean("cac_can_audio_steal_from_video"), (Integer)rs.getObject("cac_max_bwidth_video_intraloc"), (Integer)rs.getObject("cac_max_bwidth_video_interloc"), avgBW, (Integer)rs.getObject("cac_min_acceptable_bwidth_video"), (Integer)rs.getObject("cac_audio_alarm_threshold_percent"), (Integer)rs.getObject("cac_video_alarm_threshold_percent"), rs.getInt("cac_audio_alarm_latency"), rs.getInt("cac_video_alarm_latency"), rs.getBoolean("dpt_in_survivable_mode"), listedDirectoryNumber, rs.getLong("dpt_fs_sipentity_id")));
                    continue;
                }
                locationMap.put(id, new Location(id, rs.getString("name"), rs.getBoolean("dpt_in_survivable_mode"), listedDirectoryNumber, rs.getLong("dpt_fs_sipentity_id")));
            }
            return locationMap;
        }
    };

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("cacfields".equals(((String)entry.getKey()).toLowerCase())) {
                boolean load = false;
                for (String value : (Set)entry.getValue()) {
                    if (!Boolean.parseBoolean(value)) continue;
                    load = true;
                }
                reinit |= this.setLoadCACFields(load);
                continue;
            }
            log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected boolean setLoadCACFields(boolean load) {
        try {
            this.lock.acquireWriteLock();
            if (this.loadCACFields != load) {
                this.loadCACFields = load;
                if (this.loadCACFields) {
                    getLocations = "SELECT id, name, cac_tot_bwidth_allow, cac_tot_bwidth_allow_uom, cac_avg_bwidth_percall, cac_avg_bwidth_percall_uom, cac_normal_bwidth_video, cac_min_acceptable_bwidth_video, cac_can_audio_steal_from_video, cac_max_bwidth_video_intraloc, cac_max_bwidth_video_interloc, cac_audio_alarm_threshold_percent, cac_video_alarm_threshold_percent, cac_audio_alarm_latency, cac_video_alarm_latency, dpt_in_survivable_mode, listed_directory_number, dpt_fs_sipentity_id FROM routingorigination";
                    getLocation = getLocations + " WHERE id = ?";
                } else {
                    getLocations = "SELECT id, name, dpt_in_survivable_mode, listed_directory_number, dpt_fs_sipentity_id FROM routingorigination";
                    getLocation = getLocations + " WHERE id = ?";
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return false;
    }

    protected String getLocationsQuery() {
        try {
            this.lock.acquireReadLock();
            String string = getLocations;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected String getLocationQuery() {
        try {
            this.lock.acquireReadLock();
            String string = getLocation;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    protected GlobalDAO getGlobalDAO() {
        return (GlobalDAO)this.getDataMgr(GlobalDAO.class);
    }

    public LocationDAO() {
        super(true);
    }

    @Override
    protected Object getMainCollection() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Location> map = this.locationIdMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map locationIdMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + LocationDAO.class.getSimpleName()));
        }
        HashMap<String, Location> locationNameMapTMP = new HashMap<String, Location>();
        HashMap<String, Location> ldnMapTMP = new HashMap<String, Location>();
        try {
            ignoreSDP = this.getGlobalDAO().cacIgnoreSDP();
            Object[] params = new Object[]{};
            locationIdMapTMP = (Map)this.dataSource.executeQuery(this.getLocationsQuery(), params, locationMapper);
            for (Location loc : locationIdMapTMP.values()) {
                locationNameMapTMP.put(loc.getName(), loc);
                if (loc.getListedDirectoryNumber() == null) continue;
                ldnMapTMP.put(loc.getListedDirectoryNumber(), loc);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.locationIdMap = locationIdMapTMP;
                this.locationNameMap = locationNameMapTMP;
                this.ldnMap = ldnMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("routingorigination");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        Location oldLoc = null;
        Location newLoc = null;
        boolean lockHeld = false;
        try {
            Map map = null;
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                map = (Map)this.dataSource.executeQuery(this.getLocationQuery(), params, locationMapper);
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldLoc = this.locationIdMap.remove(id);
            if (oldLoc != null) {
                this.locationNameMap.remove(oldLoc.getName());
                if (oldLoc.getListedDirectoryNumber() != null) {
                    this.ldnMap.remove(oldLoc.getListedDirectoryNumber());
                }
            }
            if (map != null && (newLoc = (Location)map.get(id)) != null) {
                if (log.isFinerEnabled()) {
                    log.finer((Object)(this.logTag(operation, tableName, id) + "Retrieved new Location " + newLoc));
                }
                this.locationIdMap.put(id, newLoc);
                this.locationNameMap.put(newLoc.getName(), newLoc);
                if (newLoc.getListedDirectoryNumber() != null) {
                    this.ldnMap.put(newLoc.getListedDirectoryNumber(), newLoc);
                }
            }
        }
        catch (DMException e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + LocationDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            newLoc = null;
            oldLoc = null;
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (oldLoc != null || newLoc != null) {
            this.updateListeners(oldLoc, newLoc);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    public Location getLocation(Long id) {
        this.lock.acquireReadLock();
        try {
            if (id == null) {
                Location location = null;
                return location;
            }
            Location location = this.locationIdMap.get(id);
            return location;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Location getLocationByName(String name) {
        this.lock.acquireReadLock();
        try {
            Location location = this.locationNameMap.get(name);
            return location;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Location getLocationByLDN(String listedDirectoryNumber) {
        this.lock.acquireReadLock();
        try {
            Location location = this.ldnMap.get(listedDirectoryNumber);
            return location;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned Locations.")
    public Map<Long, Location> getAllLocations() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Location> map = Collections.unmodifiableMap(this.locationIdMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Set<Long> getAllLocationIds() {
        this.lock.acquireReadLock();
        try {
            HashSet<Long> hashSet = new HashSet<Long>(this.locationIdMap.keySet());
            return hashSet;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (oldObject instanceof GlobalParm || newObject instanceof GlobalParm) {
            GlobalParm oldParm = (GlobalParm)oldObject;
            GlobalParm newParm = (GlobalParm)newObject;
            if (oldParm != null && "cac_ignore_sdp".equals(oldParm.getParam()) || newParm != null && "cac_ignore_sdp".equals(newParm.getParam())) {
                if (log.isFinestEnabled()) {
                    log.finest((Object)("objectChanged: " + oldParm + " became " + newParm));
                }
                this.reinit();
            }
        } else {
            super.objectChanged(oldObject, newObject);
        }
    }
}

