/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.FQDNOrIpAddr;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.ListenPort;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.SipMonResponseHandling;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SIPEntityDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(SIPEntityDAO.class);
    protected Map<Long, SIPEntity> entityMap = new HashMap<Long, SIPEntity>();
    protected Map<FQDNOrIpAddr, Map<Long, SIPEntity>> entityAddressMap = new HashMap<FQDNOrIpAddr, Map<Long, SIPEntity>>();
    protected Map<Long, ListenPort> portIdMap = new HashMap<Long, ListenPort>();
    protected Map<Long, SipMonResponseHandling> responseHandlingMap = new HashMap<Long, SipMonResponseHandling>();
    protected static final String getSIPEntities = "SELECT id, entitytype, ipaddr_family_type, fqdnoripaddr, fqdnoripaddr2, sip_fqdn, name, userfc3263, adaptation_id, outboundproxy_id, routingorigination_id, timer_bf_secs, do_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, monitor_okresponses, cdrsetting, cac_capable, bandwidth_sharing_sm1_id, bandwidth_sharing_sm2_id, tcp_failover_port, tls_failover_port, tcp_failover_port_v6, tls_failover_port_v6, commprofile_type_for_preferredhandle, securable, ipaddr_tolerant FROM sipentity";
    protected static final String getSIPEntity = "SELECT id, entitytype, ipaddr_family_type, fqdnoripaddr, fqdnoripaddr2, sip_fqdn, name, userfc3263, adaptation_id, outboundproxy_id, routingorigination_id, timer_bf_secs, do_monitoring, monitor_proactive_secs, monitor_reactive_secs, monitor_retries, monitor_okresponses, cdrsetting, cac_capable, bandwidth_sharing_sm1_id, bandwidth_sharing_sm2_id, tcp_failover_port, tls_failover_port, tcp_failover_port_v6, tls_failover_port_v6, commprofile_type_for_preferredhandle, securable, ipaddr_tolerant FROM sipentity WHERE id = ?";
    protected static final String getAllListenPorts = "SELECT id, portnumber, transportprotocol, sipdomain_id, sipentity_id, ipaddr_family, endpoint FROM listenport";
    protected static final String getListenPortByEntityId = "SELECT id, portnumber, transportprotocol, sipdomain_id, sipentity_id, ipaddr_family, endpoint FROM listenport WHERE sipentity_id=?";
    protected static final String getListenPortById = "SELECT id, portnumber, transportprotocol, sipdomain_id, sipentity_id, ipaddr_family, endpoint FROM listenport WHERE id=?";
    protected static final String getSipMonResponseHandling = "SELECT id, type, response, sipentity_id FROM sipmonresponsehandling";
    protected static final String getSipMonResponseHandlingById = "SELECT id, type, response, sipentity_id FROM sipmonresponsehandling WHERE id = ?";
    protected static final String getSipMonResponseHandlingByEntityId = "SELECT id, type, response, sipentity_id FROM sipmonresponsehandling WHERE sipentity_id = ?";
    protected static final ResultSetMapper entityMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, SIPEntity> map = new HashMap<Long, SIPEntity>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                String monitorString = rs.getString("do_monitoring");
                Boolean do_monitoring = null;
                if (monitorString.equals("yes")) {
                    do_monitoring = true;
                } else if (monitorString.equals("no")) {
                    do_monitoring = false;
                }
                String fqdnIpAddr1 = null;
                fqdnIpAddr1 = rs.getString("fqdnoripaddr");
                if (fqdnIpAddr1 != null) {
                    fqdnIpAddr1 = fqdnIpAddr1.toLowerCase();
                }
                String fqdnIpAddr2 = null;
                fqdnIpAddr2 = rs.getString("fqdnoripaddr2");
                if (fqdnIpAddr2 != null) {
                    fqdnIpAddr2 = fqdnIpAddr2.toLowerCase();
                }
                String sip_fqdn = null;
                sip_fqdn = rs.getString("sip_fqdn");
                if (sip_fqdn != null) {
                    sip_fqdn = sip_fqdn.toLowerCase();
                }
                SIPEntity entity = new SIPEntity(id, rs.getString("entitytype"), rs.getString("ipaddr_family_type"), fqdnIpAddr1, fqdnIpAddr2, sip_fqdn, rs.getString("name"), rs.getBoolean("userfc3263"), (Long)rs.getObject("adaptation_id"), (Long)rs.getObject("outboundproxy_id"), (Long)rs.getObject("routingorigination_id"), rs.getInt("timer_bf_secs"), do_monitoring, rs.getInt("monitor_proactive_secs"), rs.getInt("monitor_reactive_secs"), rs.getInt("monitor_retries"), rs.getInt("monitor_okresponses"), SIPEntity.CDRSetting.valueOf(rs.getString("cdrsetting")), rs.getBoolean("cac_capable"), (Long)rs.getObject("bandwidth_sharing_sm1_id"), (Long)rs.getObject("bandwidth_sharing_sm2_id"), (Integer)rs.getObject("tcp_failover_port"), (Integer)rs.getObject("tls_failover_port"), (Integer)rs.getObject("tcp_failover_port_v6"), (Integer)rs.getObject("tls_failover_port_v6"), rs.getString("commprofile_type_for_preferredhandle"), rs.getBoolean("securable"), rs.getBoolean("ipaddr_tolerant"));
                map.put(id, entity);
            }
            return map;
        }
    };
    protected static final ResultSetMapper listenPortMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, ListenPort> listenPortMap = new HashMap<Long, ListenPort>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                ListenPort listenPort = new ListenPort(id, rs.getLong("sipentity_id"), rs.getInt("portnumber"), rs.getString("transportprotocol"), rs.getLong("sipdomain_id"), rs.getBoolean("endpoint"), rs.getString("ipaddr_family"));
                listenPortMap.put(id, listenPort);
            }
            return listenPortMap;
        }
    };
    protected static final ResultSetMapper sipMonResponseHandlingMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, SipMonResponseHandling> map = new HashMap<Long, SipMonResponseHandling>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                String type = rs.getString("type");
                boolean up = false;
                if ("up".equals(type)) {
                    up = true;
                }
                map.put(id, new SipMonResponseHandling(id, rs.getLong("sipentity_id"), up, rs.getString("response")));
            }
            return map;
        }
    };

    public SIPEntityDAO() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap responseHandlingMapTMP;
        Map portIdMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + SIPEntityDAO.class.getSimpleName()));
        }
        HashMap<Long, SIPEntity> entityMapTMP = new HashMap<Long, SIPEntity>();
        HashMap<FQDNOrIpAddr, Map<Long, SIPEntity>> entityAddressMapTMP = new HashMap<FQDNOrIpAddr, Map<Long, SIPEntity>>();
        try {
            SIPEntity entity;
            Object[] params = new Object[]{};
            HashMap databaseMap = (HashMap)this.dataSource.executeQuery(getSIPEntities, params, entityMapper);
            for (Map.Entry e : databaseMap.entrySet()) {
                FQDNOrIpAddr sipFqdn;
                Long seId = (Long)e.getKey();
                SIPEntity entity2 = (SIPEntity)e.getValue();
                if (this.ignoreSIPEntity(entity2)) continue;
                entityMapTMP.put(seId, entity2);
                FQDNOrIpAddr fqdnOrIpAddr = entity2.getFQDNOrIpAddr();
                Map<Long, SIPEntity> map = (HashMap<Long, SIPEntity>)entityAddressMapTMP.get(fqdnOrIpAddr);
                if (map == null) {
                    map = new HashMap<Long, SIPEntity>();
                    entityAddressMapTMP.put(fqdnOrIpAddr, map);
                }
                map.put(seId, entity2);
                FQDNOrIpAddr fqdnOrIpAddr2 = entity2.getFQDNOrIpAddr2();
                if (!fqdnOrIpAddr2.isNull()) {
                    map = (Map)entityAddressMapTMP.get(fqdnOrIpAddr2);
                    if (map == null) {
                        map = new HashMap();
                        entityAddressMapTMP.put(fqdnOrIpAddr2, map);
                    }
                    map.put(seId, entity2);
                }
                if ((sipFqdn = entity2.getSIPFQDN()).isNull()) continue;
                map = (Map)entityAddressMapTMP.get(sipFqdn);
                if (map == null) {
                    map = new HashMap();
                    entityAddressMapTMP.put(sipFqdn, map);
                }
                map.put(seId, entity2);
            }
            portIdMapTMP = (Map)this.dataSource.executeQuery(getAllListenPorts, params, listenPortMapper);
            for (ListenPort port : portIdMapTMP.values()) {
                entity = (SIPEntity)entityMapTMP.get(port.getSipEntityId());
                if (entity == null) continue;
                entity.addListenPort(port);
            }
            responseHandlingMapTMP = (HashMap)this.dataSource.executeQuery(getSipMonResponseHandling, params, sipMonResponseHandlingMapper);
            for (SipMonResponseHandling responseHandling : responseHandlingMapTMP.values()) {
                entity = (SIPEntity)entityMapTMP.get(responseHandling.getEntityId());
                if (entity == null) continue;
                entity.addResponseHandling(responseHandling);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        if (this.okay()) {
            this.lock.acquireWriteLock();
            try {
                this.entityMap = entityMapTMP;
                this.entityAddressMap = entityAddressMapTMP;
                this.portIdMap = portIdMapTMP;
                this.responseHandlingMap = responseHandlingMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    protected boolean ignoreSIPEntity(SIPEntity entity) {
        return "ENDPTCONC".equals(entity.getType());
    }

    protected void updateMaps(SIPEntity newEntity) {
        SIPEntity oldEntity = this.entityMap.put(newEntity.getId(), newEntity);
        if (oldEntity != null) {
            this.deleteEntityAddrMap(oldEntity, oldEntity.getFQDNOrIpAddr());
            this.deleteEntityAddrMap(oldEntity, oldEntity.getFQDNOrIpAddr2());
            this.deleteEntityAddrMap(oldEntity, oldEntity.getSIPFQDN());
        }
        this.addEntityAddrMap(newEntity, newEntity.getFQDNOrIpAddr());
        this.addEntityAddrMap(newEntity, newEntity.getFQDNOrIpAddr2());
        this.addEntityAddrMap(newEntity, newEntity.getSIPFQDN());
    }

    protected SIPEntity delete(long entityId) {
        SIPEntity entity = this.entityMap.remove(entityId);
        if (entity != null) {
            this.deleteEntityAddrMap(entity, entity.getFQDNOrIpAddr());
            this.deleteEntityAddrMap(entity, entity.getFQDNOrIpAddr2());
            this.deleteEntityAddrMap(entity, entity.getSIPFQDN());
        }
        return entity;
    }

    protected void addEntityAddrMap(SIPEntity entity, FQDNOrIpAddr fqdnOrIpAddr) {
        if (fqdnOrIpAddr.isNull()) {
            return;
        }
        Map<Long, SIPEntity> map = this.entityAddressMap.get(fqdnOrIpAddr);
        if (map == null) {
            map = new HashMap<Long, SIPEntity>();
            this.entityAddressMap.put(fqdnOrIpAddr, map);
        }
        map.put(entity.getId(), entity);
    }

    protected void deleteEntityAddrMap(SIPEntity oldEntity, FQDNOrIpAddr fqdnOrIpAddr) {
        Map<Long, SIPEntity> map = this.entityAddressMap.get(fqdnOrIpAddr);
        if (map != null) {
            map.remove(oldEntity.getId());
            if (map.isEmpty()) {
                this.entityAddressMap.remove(fqdnOrIpAddr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        boolean locked = false;
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)("updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        SIPEntity oldEntity = null;
        SIPEntity newEntity = null;
        this.lock.acquireWriteLock();
        locked = true;
        try {
            if ("sipentity".equals(tableName)) {
                if (operation == DAOReplicationEvent.OperationType.DELETE) {
                    oldEntity = this.delete(id);
                }
                if (operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) {
                    Object[] params = new Object[]{id};
                    Map databaseMap = (Map)this.dataSource.executeQuery(getSIPEntity, params, entityMapper);
                    newEntity = (SIPEntity)databaseMap.get(id);
                    if (newEntity == null) {
                        throw new DMException("updateDAO: failed to read SIPEntity[id=" + id + "] from database");
                    }
                    if (this.ignoreSIPEntity(newEntity)) {
                        if (log.isFineEnabled()) {
                            log.fine((Object)("updateDAO: ignoring " + newEntity));
                        }
                        newEntity = null;
                    }
                    if (operation == DAOReplicationEvent.OperationType.UPDATE) {
                        if (newEntity == null) {
                            oldEntity = this.delete(id);
                        } else {
                            oldEntity = this.getSIPEntity(id);
                            if (oldEntity != null) {
                                newEntity.update(oldEntity);
                            }
                        }
                    }
                    if (newEntity != null) {
                        this.updateMaps(newEntity);
                    }
                    if (log.isFineEnabled()) {
                        log.fine((Object)("updateDAO: SIPEntity[id=" + id + "] is now " + this.entityMap.get(id)));
                    }
                }
            } else if (tableName.equals("listenport")) {
                Long affectedSE;
                ListenPort port = this.portIdMap.remove(id);
                Long l = affectedSE = port != null ? port.getSipEntityId() : null;
                if (port != null && (oldEntity = this.entityMap.get(port.getSipEntityId())) != null) {
                    oldEntity.removeListenPort(port);
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE) {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getListenPortById, params, listenPortMapper);
                    port = (ListenPort)map.get(id);
                    Long l2 = affectedSE = affectedSE == null ? port.getSipEntityId() : affectedSE;
                    if (port == null) {
                        throw new DMException("Listen port does not exist for " + (Object)((Object)operation) + " event");
                    }
                    newEntity = this.entityMap.get(port.getSipEntityId());
                    if (newEntity == null) {
                        throw new DMException("Listen port entity does not exist for " + (Object)((Object)operation) + " event");
                    }
                    this.portIdMap.put(port.getId(), port);
                    newEntity.addListenPort(port);
                }
            } else if ("sipmonresponsehandling".equals(tableName)) {
                SIPEntity entity;
                Object[] params;
                HashMap handlings;
                SIPEntity entity2;
                SipMonResponseHandling handling = this.responseHandlingMap.remove(id);
                if (handling != null && (entity2 = this.getSIPEntity(handling.getEntityId())) != null) {
                    entity2.removeResponseHandling(id);
                }
                if (operation != DAOReplicationEvent.OperationType.DELETE && (handling = (SipMonResponseHandling)(handlings = (HashMap)this.dataSource.executeQuery(getSipMonResponseHandlingById, params = new Object[]{id}, sipMonResponseHandlingMapper)).get(id)) != null && (entity = this.getSIPEntity(handling.getEntityId())) != null) {
                    entity.addResponseHandling(handling);
                    this.responseHandlingMap.put(id, handling);
                }
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)("Error updating " + SIPEntityDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            newEntity = null;
            oldEntity = null;
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.getClass().getSimpleName() + " Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
        }
        if (oldEntity != null || newEntity != null) {
            this.updateListeners(oldEntity, newEntity);
        }
        if (log.isFineEnabled()) {
            log.fine((Object)("updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id + " successful"));
        }
    }

    protected List<Long> findMissingIds(List<Long> oldEntityIds, List<Long> newEntityIds) {
        ArrayList<Long> missingIds = new ArrayList<Long>();
        if (oldEntityIds == null) {
            return missingIds;
        }
        for (Long oldId : oldEntityIds) {
            if (newEntityIds.contains(oldId)) continue;
            missingIds.add(oldId);
        }
        return missingIds;
    }

    protected List<Long> findNewIds(List<Long> oldEntityIds, List<Long> currentEntityIds) {
        List<Long> newIds;
        if (oldEntityIds == null) {
            newIds = currentEntityIds;
        } else {
            newIds = new ArrayList<Long>();
            for (Long neId : currentEntityIds) {
                if (oldEntityIds.contains(neId)) continue;
                newIds.add(neId);
            }
        }
        return newIds;
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("sipentity");
        list.add("listenport");
        list.add("sipmonresponsehandling");
        return list;
    }

    public SIPEntity getSIPEntity(Long entityId) {
        this.lock.acquireReadLock();
        try {
            SIPEntity sIPEntity = this.entityMap.get(entityId);
            return sIPEntity;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned SIPEntities.")
    public Map<Long, SIPEntity> getAllSIPEntities() {
        this.lock.acquireReadLock();
        try {
            Map<Long, SIPEntity> map = Collections.unmodifiableMap(this.entityMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all SIPEntities by address.")
    public Map<FQDNOrIpAddr, Map<Long, SIPEntity>> getEntityAddressMap() {
        this.lock.acquireReadLock();
        try {
            Map<FQDNOrIpAddr, Map<Long, SIPEntity>> map = Collections.unmodifiableMap(this.entityAddressMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SIPEntity> getSIPEntityByAddress(String address) {
        FQDNOrIpAddr fqdnOrIpAddr = new FQDNOrIpAddr(address);
        ArrayList<SIPEntity> entityList = new ArrayList<SIPEntity>();
        this.lock.acquireReadLock();
        try {
            Map<Long, SIPEntity> map = this.entityAddressMap.get(fqdnOrIpAddr);
            if (map != null) {
                entityList.addAll(map.values());
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("getSIPEntityByAddress(" + address + ") returned " + entityList));
        }
        return entityList;
    }

    @SMConsole(parameterNames={"sipEntityId"}, description="Given some SIP Entity id, pull out the listen ports associated with it.")
    public List<ListenPort> getListenPorts(Long sipEntityId) {
        SIPEntity se = this.entityMap.get(sipEntityId);
        return se == null ? null : se.getListenPorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenPort getListenPort(Integer portnumber, String transportprotocol, IPAddress.IPAddressFamily ipAddrFamily, Boolean endpoint, Long sipEntityId) {
        this.lock.acquireReadLock();
        try {
            SIPEntity entity = this.entityMap.get(sipEntityId);
            if (entity != null) {
                ListenPort listenPort = entity.getListenPort(portnumber, transportprotocol, ipAddrFamily, endpoint);
                return listenPort;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return null;
    }

    @Override
    protected Object getMainCollection() {
        return this.entityMap;
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

